/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.serialization.objects;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.conqat.lib.commons.serialization.SerializedEntityBase;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.SerializedEntitySerializer;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.classes.SerializedClassBase;

public abstract class SerializedObjectBase
extends SerializedEntityBase {
    protected int classHandle;

    protected SerializedObjectBase(SerializedEntityPool pool, int classHandle) {
        super(pool);
        this.classHandle = classHandle;
    }

    public SerializedClass getSerializedClass() throws IOException {
        return this.pool.getEntity(this.classHandle, SerializedClass.class);
    }

    public List<SerializedClass> getPlainClassHierarchy() throws IOException {
        int currentClassHandle = this.classHandle;
        ArrayList<SerializedClass> hierarchy = new ArrayList<SerializedClass>();
        while (currentClassHandle != 0) {
            SerializedClassBase classEntity = this.pool.getEntity(currentClassHandle, SerializedClassBase.class);
            if (classEntity instanceof SerializedClass) {
                hierarchy.add((SerializedClass)classEntity);
            }
            currentClassHandle = classEntity.getSuperClassHandle();
        }
        Collections.reverse(hierarchy);
        return hierarchy;
    }

    public int getClassHandle() {
        return this.classHandle;
    }

    public void setClassHandle(int classHandle) {
        this.classHandle = classHandle;
    }

    @Override
    protected void serializeContent(DataOutputStream dos, SerializedEntitySerializer serializer) throws IOException {
        dos.writeByte(this.getObjectTagConstant());
        this.pool.getEntity(this.classHandle, SerializedClassBase.class).serialize(dos, serializer);
        serializer.registerHandle(this);
        this.serializeObjectContent(dos, serializer);
    }

    protected abstract byte getObjectTagConstant();

    protected abstract void serializeObjectContent(DataOutputStream var1, SerializedEntitySerializer var2) throws IOException;
}

