/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.string;

import java.util.Iterator;

public class LineSplitter
implements Iterator<String>,
Iterable<String> {
    private String content;
    private int startIndex;
    private boolean includeTrailingEmptyLine = false;
    static final char UNICODE_NEL = '\u0085';

    public LineSplitter() {
    }

    public LineSplitter(String content) {
        this.setContent(content);
    }

    public void setContent(String content) {
        this.content = content;
        this.startIndex = 0;
    }

    @Override
    public boolean hasNext() {
        if (this.content == null) {
            return false;
        }
        if (this.includeTrailingEmptyLine && this.isTrailingEmptyLine()) {
            return true;
        }
        if (this.startIndex >= this.content.length()) {
            this.content = null;
            return false;
        }
        return true;
    }

    @Override
    public String next() {
        if (!this.hasNext()) {
            return null;
        }
        if (this.includeTrailingEmptyLine && this.isTrailingEmptyLine()) {
            ++this.startIndex;
            return "";
        }
        int skip = 0;
        int endIndex = this.startIndex;
        while (skip == 0 && endIndex < this.content.length()) {
            char c = this.content.charAt(endIndex);
            ++endIndex;
            if (c == '\n' || c == '\u0085') {
                skip = 1;
            }
            if (c != '\r') continue;
            skip = 1;
            if (endIndex >= this.content.length() || this.content.charAt(endIndex) != '\n') continue;
            skip = 2;
            ++endIndex;
        }
        String result = this.content.substring(this.startIndex, endIndex - skip);
        this.startIndex = endIndex;
        return result;
    }

    private boolean isTrailingEmptyLine() {
        if (this.startIndex > 0 && this.startIndex == this.content.length()) {
            char lastChar = this.content.charAt(this.startIndex - 1);
            return lastChar == '\n' || lastChar == '\r';
        }
        return false;
    }

    public void setIncludeTrailingEmptyLine(boolean includeTrailingEmptyLine) {
        this.includeTrailingEmptyLine = includeTrailingEmptyLine;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }
}

