/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.waiting;

import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.date.DurationUtils;
import org.conqat.lib.commons.waiting.EWaitOutcome;
import org.conqat.lib.commons.waiting.IConditionResult;
import org.conqat.lib.commons.waiting.IWaitCondition;
import org.conqat.lib.commons.waiting.WaitResult;
import org.jetbrains.annotations.CheckReturnValue;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public abstract class AbstractWaitSpec<RESULT_TYPE, EXCEPTION_TYPE extends Throwable, SELF extends AbstractWaitSpec<RESULT_TYPE, EXCEPTION_TYPE, SELF>> {
    private static final Duration DEFAULT_TIMEOUT = Duration.ofMinutes(2L);
    protected Duration timeout = DEFAULT_TIMEOUT;
    private Duration pollInterval = Duration.ofSeconds(1L);
    protected @Nullable String description = null;
    private final @Nullable Function<WaitResult<RESULT_TYPE>, EXCEPTION_TYPE> exceptionFunction;
    private static final AtomicInteger THREAD_COUNTER = new AtomicInteger();

    AbstractWaitSpec(Function<WaitResult<RESULT_TYPE>, EXCEPTION_TYPE> exceptionFunction) {
        CCSMAssert.isNotNull(exceptionFunction, "Exception function must not be null. Use continueSilentlyOnTimeoutOrInterrupt() instead to disable exception throwing.");
        this.exceptionFunction = exceptionFunction;
    }

    protected <OLD_EXCEPTION_TYPE extends Throwable> AbstractWaitSpec(AbstractWaitSpec<RESULT_TYPE, OLD_EXCEPTION_TYPE, ?> waitSpec, @Nullable Function<WaitResult<RESULT_TYPE>, EXCEPTION_TYPE> exceptionFunction) {
        this.timeout(waitSpec.timeout);
        this.pollInterval(waitSpec.pollInterval);
        this.description = waitSpec.description;
        this.exceptionFunction = exceptionFunction;
    }

    protected abstract IWaitCondition getCondition();

    public WaitResult<RESULT_TYPE> execute() throws EXCEPTION_TYPE {
        WaitResult<RESULT_TYPE> result = this.executeInternal();
        if (!result.isSuccess()) {
            throw (Throwable)Objects.requireNonNull(this.exceptionFunction).apply(result);
        }
        return result;
    }

    @CheckReturnValue
    public SELF timeout(Duration timeout) {
        CCSMAssert.isNotNull((Object)timeout, "Timeout must not be null");
        CCSMAssert.isTrue(timeout.isPositive(), "Timeout must be positive");
        this.timeout = timeout;
        return this.self();
    }

    @CheckReturnValue
    public SELF pollInterval(Duration interval) {
        CCSMAssert.isNotNull((Object)interval, "Poll interval must not be null");
        CCSMAssert.isTrue(interval.isPositive(), "Poll interval must be positive");
        this.pollInterval = interval;
        return this.self();
    }

    @CheckReturnValue
    public SELF asWaitingFor(String description) {
        this.description = description;
        CCSMAssert.isNotEmpty(description, "Explicitly set description must not be empty.");
        return this.self();
    }

    /*
     * Unable to fully structure code
     */
    protected final WaitResult<RESULT_TYPE> executeInternal() {
        this.validate();
        executor = Executors.newSingleThreadExecutor((ThreadFactory)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Runnable;)Ljava/lang/Thread;, createDaemonThread(java.lang.Runnable ), (Ljava/lang/Runnable;)Ljava/lang/Thread;)());
        lastResult = null;
        resultFuture = null;
        startTime = Instant.now();
        try {
            while (true) {
                if ((remaining = this.timeout.minus(elapsed = AbstractWaitSpec.computeElapsedDuration(startTime))).isZero() || remaining.isNegative()) {
                    var7_7 = AbstractWaitSpec.timeout(startTime, this.timeout, this.extractFailureReason(lastResult), null);
                    return var7_7;
                }
                resultFuture = executor.submit((Callable<IConditionResult>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, check(), ()Lorg/conqat/lib/commons/waiting/IConditionResult;)((IWaitCondition)this.getCondition()));
                try {
                    lastResult = resultFuture.get(remaining.toNanos(), TimeUnit.NANOSECONDS);
                    if (lastResult.isFulfilled()) {
                        var7_8 = AbstractWaitSpec.success(startTime, this.timeout, lastResult.getValue());
                        return var7_8;
                    }
                    ** if (!lastResult.isTerminated()) goto lbl-1000
                }
                catch (TimeoutException e) {
                    var8_15 = AbstractWaitSpec.timeout(startTime, this.timeout, this.extractFailureReason(lastResult), e);
                    return var8_15;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    var8_16 = AbstractWaitSpec.interrupted(e, startTime, this.timeout, this.extractFailureReason(lastResult));
                    return var8_16;
                }
                catch (ExecutionException e) {
                    var8_17 = AbstractWaitSpec.terminated(startTime, this.timeout, "Interrupted by exception. Previous failure: " + this.extractFailureReason(lastResult), e);
                    return var8_17;
                }
lbl-1000:
                // 1 sources

                {
                    var7_9 = AbstractWaitSpec.terminated(startTime, this.timeout, Objects.requireNonNull(lastResult.getFailureReason()), null);
                    return var7_9;
                }
lbl-1000:
                // 1 sources

                {
                }
                remaining = this.timeout.minus(AbstractWaitSpec.computeElapsedDuration(startTime).plus(this.pollInterval));
                if (remaining.isZero() || remaining.isNegative()) {
                    e = AbstractWaitSpec.timeout(startTime, this.timeout, this.extractFailureReason(lastResult), null);
                    return e;
                }
                try {
                    Thread.sleep(this.pollInterval.toMillis());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    var8_18 = AbstractWaitSpec.interrupted(e, startTime, this.timeout, this.extractFailureReason(lastResult));
                    return var8_18;
                }
            }
        }
        finally {
            if (resultFuture != null && !resultFuture.isDone()) {
                resultFuture.cancel(true);
            }
            executor.shutdownNow();
        }
    }

    private static <RESULT_TYPE> WaitResult<RESULT_TYPE> terminated(Instant startTime, Duration timeout, String failureReason, @Nullable Exception ex) {
        return new WaitResult<Object>(EWaitOutcome.TERMINATED, AbstractWaitSpec.computeElapsedDuration(startTime), timeout, failureReason, ex, null);
    }

    private static <RESULT_TYPE> WaitResult<RESULT_TYPE> interrupted(Exception interruptionException, Instant startTime, Duration timeout, String failureReason) {
        return new WaitResult<Object>(EWaitOutcome.INTERRUPTED, AbstractWaitSpec.computeElapsedDuration(startTime), timeout, "Interrupted by the system. Previous failure: " + failureReason, interruptionException, null);
    }

    public static <RESULT_TYPE> WaitResult<RESULT_TYPE> success(Instant startTime, Duration timeout, @Nullable RESULT_TYPE value) {
        return new WaitResult<RESULT_TYPE>(EWaitOutcome.SUCCESS, AbstractWaitSpec.computeElapsedDuration(startTime), timeout, null, null, value);
    }

    private static <RESULT_TYPE> WaitResult<RESULT_TYPE> timeout(Instant startTime, Duration timeout, String failureReason, @Nullable TimeoutException timeoutException) {
        return new WaitResult<Object>(EWaitOutcome.TIMEOUT, AbstractWaitSpec.computeElapsedDuration(startTime), timeout, failureReason, timeoutException, null);
    }

    private static Duration computeElapsedDuration(Instant startTime) {
        return Duration.between(startTime, Instant.now());
    }

    private static Thread createDaemonThread(Runnable runnable) {
        Thread thread = new Thread(runnable, "wait-condition-" + THREAD_COUNTER.incrementAndGet());
        thread.setDaemon(true);
        return thread;
    }

    private String extractFailureReason(@Nullable IConditionResult lastResult) {
        if (lastResult != null) {
            CCSMAssert.isFalse(lastResult.isFulfilled(), "Can not extract failure reason from fulfilled result.");
            return lastResult.formatFailureMessage(this.description);
        }
        return IConditionResult.Formatter.formatDescription(this.description, null) + "Unknown failure";
    }

    protected void validate() {
        CCSMAssert.isTrue(this.pollInterval.minus(this.timeout).isNegative(), "Poll interval must be smaller than timeout (pollInterval: " + DurationUtils.formatDurationHumanReadable(this.pollInterval) + ", timeout: " + DurationUtils.formatDurationHumanReadable(this.timeout) + ")");
    }

    protected SELF self() {
        return (SELF)this;
    }
}

