/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.waiting;

import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;
import org.conqat.lib.commons.waiting.IConditionResult;
import org.conqat.lib.commons.waiting.IWaitCondition;
import org.jspecify.annotations.NullMarked;

@NullMarked
@ThreadSafe
final class TerminationCondition
implements IWaitCondition {
    private final IWaitCondition condition;

    public TerminationCondition(IWaitCondition waitCondition) {
        this.condition = waitCondition;
    }

    @Override
    public IConditionResult check() throws Exception {
        IConditionResult result = this.condition.check();
        if (result.isTerminated()) {
            return result;
        }
        String description = result.getDescription();
        if (result.isFulfilled()) {
            String terminationReason = StringUtils.isEmptyOrElse((String)result.getValue(), StringUtils.isEmptyOrElse(description, "Condition fulfilled"));
            return IConditionResult.terminated(terminationReason, description);
        }
        return IConditionResult.fulfilled(description);
    }
}

