/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.waiting;

import java.time.Duration;
import org.conqat.lib.commons.date.DurationUtils;
import org.conqat.lib.commons.waiting.EWaitOutcome;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public record WaitResult<T>(EWaitOutcome outcome, Duration elapsed, Duration configuredTimeout, @Nullable String failureReason, @Nullable Exception lastException, @Nullable T value) {
    public boolean isSuccess() {
        return this.outcome == EWaitOutcome.SUCCESS;
    }

    public boolean isTimeout() {
        return this.outcome == EWaitOutcome.TIMEOUT;
    }

    public @Nullable T getReturnValue() {
        if (this.outcome != EWaitOutcome.SUCCESS) {
            throw new IllegalStateException("getReturnValue() can only be called on successful waits. Outcome was: " + String.valueOf((Object)this.outcome) + ". Failure reason: " + this.failureReason);
        }
        return this.value;
    }

    @Override
    public String toString() {
        if (this.isSuccess()) {
            return this.formatSuccessfulResult();
        }
        return this.formatFailureResult();
    }

    private String formatSuccessfulResult() {
        StringBuilder result = new StringBuilder("Wait succeeded after ").append(DurationUtils.formatDurationHumanReadable(this.elapsed));
        if (this.value != null) {
            result.append(" with value: ").append(this.value);
        }
        return result.toString();
    }

    private String formatFailureResult() {
        StringBuilder result = new StringBuilder();
        String waitTime = DurationUtils.formatDurationHumanReadable(this.elapsed);
        switch (this.outcome) {
            case TIMEOUT: {
                result.append("Wait timed out after ").append(waitTime);
                result.append(" (timeout was ").append(DurationUtils.formatDurationHumanReadable(this.configuredTimeout)).append(")");
                break;
            }
            case INTERRUPTED: {
                result.append("Wait was interrupted after ").append(waitTime);
                break;
            }
            case TERMINATED: {
                result.append("Wait was terminated after ").append(waitTime);
                break;
            }
            default: {
                result.append("Wait failed after ").append(waitTime);
            }
        }
        if (this.failureReason != null) {
            result.append(". Reason: ").append(this.failureReason);
        }
        if (this.lastException != null) {
            result.append(". Exception: ").append(this.lastException.getClass().getSimpleName());
            if (this.lastException.getMessage() != null) {
                result.append(" - ").append(this.lastException.getMessage());
            }
        }
        return result.toString();
    }
}

