/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.waiting;

import java.util.function.Function;
import java.util.function.Supplier;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.waiting.AbstractWaitSpec;
import org.conqat.lib.commons.waiting.IWaitCondition;
import org.conqat.lib.commons.waiting.WaitResult;
import org.jetbrains.annotations.CheckReturnValue;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public sealed class WaitSpec<RESULT_TYPE, EXCEPTION_TYPE extends Throwable, SELF extends WaitSpec<RESULT_TYPE, EXCEPTION_TYPE, SELF>>
extends AbstractWaitSpec<RESULT_TYPE, EXCEPTION_TYPE, SELF> {
    private final IWaitCondition condition;

    WaitSpec(IWaitCondition condition, Function<WaitResult<RESULT_TYPE>, EXCEPTION_TYPE> exceptionFunction) {
        super(exceptionFunction);
        CCSMAssert.isNotNull((Object)condition, "Condition must not be null");
        this.condition = condition;
    }

    public <OLD_EXCEPTION_TYPE extends Throwable> WaitSpec(WaitSpec<RESULT_TYPE, OLD_EXCEPTION_TYPE, ?> waitSpec, @Nullable Function<WaitResult<RESULT_TYPE>, EXCEPTION_TYPE> exceptionFunction) {
        super(waitSpec, exceptionFunction);
        this.condition = waitSpec.condition;
    }

    @Override
    public IWaitCondition getCondition() {
        return this.condition;
    }

    @CheckReturnValue
    public <NEW_EXCEPTION_TYPE extends Throwable> WaitSpec<RESULT_TYPE, NEW_EXCEPTION_TYPE, ?> throwOnTimeoutOrInterrupt(Function<WaitResult<RESULT_TYPE>, NEW_EXCEPTION_TYPE> exceptionFunction) {
        return new WaitSpec<RESULT_TYPE, NEW_EXCEPTION_TYPE, SELF>(this, exceptionFunction);
    }

    @CheckReturnValue
    public <NEW_EXCEPTION_TYPE extends Throwable> WaitSpec<RESULT_TYPE, NEW_EXCEPTION_TYPE, ?> throwOnTimeoutOrInterrupt(Supplier<NEW_EXCEPTION_TYPE> exceptionSupplier) {
        return new WaitSpec<RESULT_TYPE, Throwable, SELF>(this, ignored -> (Throwable)exceptionSupplier.get());
    }

    @CheckReturnValue
    public WaitSpecWithoutException<RESULT_TYPE> continueSilentlyOnTimeoutOrInterrupt() {
        return new WaitSpecWithoutException(this);
    }

    public static final class WaitSpecWithoutException<RETURN_TYPE>
    extends WaitSpec<RETURN_TYPE, RuntimeException, WaitSpecWithoutException<RETURN_TYPE>> {
        public WaitSpecWithoutException(WaitSpec<RETURN_TYPE, ?, ?> waitSpec) {
            super(waitSpec, null);
        }

        @Override
        public WaitResult<RETURN_TYPE> execute() {
            return this.executeInternal();
        }
    }
}

