/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.cache;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.conqat.engine.persistence.cache.StorageCacheBase;
import org.conqat.engine.persistence.cache.SynchronizedCacheAccess;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.function.SupplierWithException;

public class StorageCacheProvider {
    private static final String CACHE_INVALIDATION_SEND_CHANNEL = "cache-provider-invalidation";
    private final Map<Class<? extends StorageCacheBase>, SupplierWithException<StorageCacheBase, ReflectiveOperationException>> cacheFactoriesByClass = new HashMap<Class<? extends StorageCacheBase>, SupplierWithException<StorageCacheBase, ReflectiveOperationException>>();
    private final TwoDimHashMap<String, Class<? extends StorageCacheBase>, StorageCacheBase> cachesByStorageSystemAndCacheClass = new TwoDimHashMap();
    private final IMessageBroker messageBroker;

    StorageCacheProvider(List<SupplierWithException<StorageCacheBase, ReflectiveOperationException>> cacheFactories, IMessageBroker messageBroker) {
        cacheFactories.forEach(factory -> {
            try {
                this.cacheFactoriesByClass.put(((StorageCacheBase)factory.get()).getClass(), (SupplierWithException<StorageCacheBase, ReflectiveOperationException>)factory);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
        });
        this.messageBroker = messageBroker;
    }

    public synchronized void invalidateCaches() {
        this.cachesByStorageSystemAndCacheClass.getFirstKeys().forEach(this::invalidateCachesForStorageSystem);
    }

    public StorageSystemCacheProvider getCacheProvider(String storageSystemName) {
        return new StorageSystemCacheProvider(this, storageSystemName);
    }

    public static String buildMessageChannelId(String storageSystemName, Class<? extends StorageCacheBase> cacheClass) {
        return "cache-provider-invalidation/" + storageSystemName + "/" + cacheClass.getName();
    }

    private synchronized void invalidateCachesForStorageSystem(String storageSystemName) {
        Optional.ofNullable(this.cachesByStorageSystemAndCacheClass.getSecondMap((Object)storageSystemName)).ifPresent(cachesByClass -> cachesByClass.forEach((cacheClass, cache) -> {
            cache.invalidateThreadSafe();
            this.messageBroker.sendMessage(StorageCacheProvider.buildMessageChannelId(storageSystemName, cacheClass), "Invalidation of all caches for storage system: " + storageSystemName);
        }));
    }

    public class StorageSystemCacheProvider {
        private final String storageSystemName;
        final /* synthetic */ StorageCacheProvider this$0;

        private StorageSystemCacheProvider(StorageCacheProvider this$0, String storageSystemName) {
            StorageCacheProvider storageCacheProvider = this$0;
            Objects.requireNonNull(storageCacheProvider);
            this.this$0 = storageCacheProvider;
            this.storageSystemName = storageSystemName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T extends StorageCacheBase> T getCache(Class<T> cacheClass) {
            StorageCacheProvider storageCacheProvider = this.this$0;
            synchronized (storageCacheProvider) {
                StorageCacheBase cache = (StorageCacheBase)this.this$0.cachesByStorageSystemAndCacheClass.getValue((Object)this.storageSystemName, cacheClass);
                if (cache == null) {
                    try {
                        cache = (StorageCacheBase)this.this$0.cacheFactoriesByClass.get(cacheClass).get();
                    }
                    catch (ReflectiveOperationException e) {
                        throw new RuntimeException("Error creating cache " + String.valueOf(cacheClass), e);
                    }
                    this.bindMessageBroker(cache);
                    this.this$0.cachesByStorageSystemAndCacheClass.putValue((Object)this.storageSystemName, cacheClass, (Object)cache);
                }
                return (T)((StorageCacheBase)CCSMAssert.checkedCast((Object)cache, cacheClass));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void bindMessageBroker(StorageCacheBase cache) {
            StorageCacheProvider storageCacheProvider = this.this$0;
            synchronized (storageCacheProvider) {
                this.this$0.messageBroker.registerListener(StorageCacheProvider.buildMessageChannelId(this.storageSystemName, cache.getClass()), message -> cache.invalidateThreadSafe());
            }
        }

        public <T extends StorageCacheBase> SynchronizedCacheAccess<T> getCacheAccess(Class<T> cacheClass) {
            return new SynchronizedCacheAccess<T>(this.getCache(cacheClass), this.storageSystemName, this.this$0.messageBroker);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidateCaches() {
            StorageCacheProvider storageCacheProvider = this.this$0;
            synchronized (storageCacheProvider) {
                this.this$0.invalidateCachesForStorageSystem(this.storageSystemName);
            }
        }
    }
}

