/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.distribution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.distribution.IMessageListener;

public class LocalMessageBroker
implements IMessageBroker {
    private final Map<String, Channel> channelsByName = Collections.synchronizedMap(new HashMap());
    private final ExecutorService executor = Executors.newCachedThreadPool();
    private final Map<String, AtomicLong> counters = Collections.synchronizedMap(new HashMap());

    @Override
    public void sendMessage(String channel, String message) {
        this.getOrCreateChannel(channel).send(message);
    }

    @Override
    public void registerListener(String channel, IMessageListener listener) {
        this.getOrCreateChannel(channel).register(listener);
    }

    private Channel getOrCreateChannel(String channel) {
        return this.channelsByName.computeIfAbsent(channel, x -> new Channel(this));
    }

    @Override
    public long getCounterValue(String name) {
        return this.getCounter(name).get();
    }

    @Override
    public void resetCounterValue(String name) {
        this.getCounter(name).set(0L);
    }

    @Override
    public long getAndIncrementCounterValue(String name) {
        return this.getCounter(name).getAndIncrement();
    }

    private AtomicLong getCounter(String name) {
        return this.counters.computeIfAbsent(name, x -> new AtomicLong());
    }

    private class Channel {
        private final List<IMessageListener> listeners;
        final /* synthetic */ LocalMessageBroker this$0;

        private Channel(LocalMessageBroker localMessageBroker) {
            LocalMessageBroker localMessageBroker2 = localMessageBroker;
            Objects.requireNonNull(localMessageBroker2);
            this.this$0 = localMessageBroker2;
            this.listeners = new ArrayList<IMessageListener>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void send(String message) {
            List<IMessageListener> list = this.listeners;
            synchronized (list) {
                for (IMessageListener listener : this.listeners) {
                    this.this$0.executor.submit(() -> listener.receive(message));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void register(IMessageListener listener) {
            List<IMessageListener> list = this.listeners;
            synchronized (list) {
                this.listeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deregister(IMessageListener listener) {
            List<IMessageListener> list = this.listeners;
            synchronized (list) {
                this.listeners.remove(listener);
            }
        }
    }
}

