/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.PartitionAndPath;
import org.conqat.engine.persistence.index.PartitionIndexUtils;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class PartitionIndexBase
extends IndexBase {
    public static final String KEY_SEPARATOR = "#!#";
    public static final Pattern KEY_SEPARATOR_PATTERN = Pattern.compile(Pattern.quote("#!#"));

    protected PartitionIndexBase(IStore store) {
        super(store);
    }

    protected PartitionIndexBase(IStore store, boolean autoAbbreviateKeys) {
        super(store, autoAbbreviateKeys);
    }

    public void addPartition(String name) throws StorageException {
        this.addPartitions(Collections.singleton(name));
    }

    public void addPartitions(Set<String> partitionsToAdd) throws StorageException {
        PartitionIndexUtils.addStoredPartitions(this.store, partitionsToAdd);
    }

    public List<String> getPartitions() throws StorageException {
        return PartitionIndexUtils.getStoredPartitions(this.store);
    }

    public void addMergedFromOtherBranchesFor(List<PartitionAndPath> partitionAndPaths, CommitDescriptor mergeCommit) throws StorageException {
        Map pathsByPartition = partitionAndPaths.stream().collect(Collectors.groupingBy(PartitionAndPath::getPartition, Collectors.mapping(PartitionAndPath::getUniformPath, Collectors.toList())));
        for (Map.Entry entry : pathsByPartition.entrySet()) {
            PartitionIndexUtils.addMergedPathsOfPartition(this.store, entry.getKey(), entry.getValue(), this.store.getAbbreviator(), mergeCommit);
        }
    }

    public void purgeFromOtherBranches(Collection<String> partitions) throws StorageException {
        HashSet<String> mergedPartitions = new HashSet<String>(PartitionIndexUtils.getStoredPartitions(this.store, "#-#partitions-with-merges#-#"));
        Sets.SetView mergedAndToPurgePartitions = Sets.intersection(mergedPartitions, new HashSet<String>(partitions));
        PairList<String, String> mergedPaths = PartitionIndexUtils.getMergedPathsOfPartition(this.store, Set.copyOf(mergedAndToPurgePartitions), this.store.getAbbreviator());
        List mergedPathKeys = mergedPaths.map(PartitionIndexBase::makeKey);
        this.store.removeWithStrings(mergedPathKeys);
        PartitionIndexUtils.removeAllMergedPathsOfPartition(this.store, (Collection<String>)mergedAndToPurgePartitions);
    }

    public static ListMap<String, String> splitKeys(Collection<String> keys) {
        ListMap result = new ListMap();
        for (String key : keys) {
            if (PartitionIndexBase.isHiddenKey(key)) continue;
            String[] parts = KEY_SEPARATOR_PATTERN.split(key, 2);
            result.add((Object)parts[0], (Object)parts[1]);
        }
        return result;
    }

    protected static PartitionAndPath splitKey(String key) {
        String[] parts = KEY_SEPARATOR_PATTERN.split(key, 2);
        CCSMAssert.isTrue((parts.length == 2 ? 1 : 0) != 0, (String)("Invalid key given " + key));
        return new PartitionAndPath(parts[0], parts[1]);
    }

    protected static Pair<String, UniformPath> splitKeyAsUniformPath(String key) {
        String[] parts = KEY_SEPARATOR_PATTERN.split(key, 2);
        return new Pair((Object)parts[0], (Object)UniformPathCompatibilityUtil.convert((String)parts[1]));
    }

    public static List<PartitionAndPath> getPartitionAndPaths(Collection<String> rawKeys) {
        return (List)rawKeys.stream().filter(key -> !PartitionIndexBase.isHiddenKey(key)).map(PartitionIndexBase::splitKey).collect(CollectionUtils.toArrayList());
    }

    protected static List<String> getRawKeys(Collection<PartitionAndPath> partitionAndPaths) {
        return CollectionUtils.map(partitionAndPaths, PartitionIndexBase::makeKey);
    }

    public static String makeKey(PartitionAndPath partitionAndPath) {
        return PartitionIndexBase.makeKey(partitionAndPath.getPartition(), partitionAndPath.getUniformPath());
    }

    public static String makeKey(String partition, String uniformPath) {
        return PartitionIndexBase.makePartitionKeyPrefix(partition) + uniformPath;
    }

    protected static String makeKey(String partition, UniformPath uniformPath) {
        return PartitionIndexBase.makeKey(partition, uniformPath.toString());
    }

    public static Set<String> getUniformPaths(Collection<String> deltaKeys) {
        return deltaKeys.stream().filter(key -> !PartitionIndexBase.isHiddenKey(key)).map(PartitionIndexBase::splitKey).map(PartitionAndPath::getUniformPath).collect(Collectors.toSet());
    }

    protected static List<String> makeKeys(String partition, Collection<String> uniformPaths) {
        return CollectionUtils.map(uniformPaths, uniformPath -> PartitionIndexBase.makeKey(partition, uniformPath));
    }

    protected static List<String> makeKeysForUniformPaths(String partition, List<UniformPath> uniformPaths) {
        return PartitionIndexBase.makeKeys(partition, CollectionUtils.map(uniformPaths, UniformPath::toString));
    }

    protected static String makePartitionKeyPrefix(String partition) {
        return partition + KEY_SEPARATOR;
    }

    protected void removeValues(Collection<PartitionAndPath> partitionsAndUniformPaths) throws StorageException {
        ArrayList<String> keysToRemove = new ArrayList<String>();
        partitionsAndUniformPaths.forEach(entry -> keysToRemove.add(PartitionIndexBase.makeKey(entry.getPartition(), entry.getUniformPath())));
        this.store.removeWithStrings(keysToRemove);
    }

    private static boolean isHiddenKey(String key) {
        return key.startsWith("#-#partitions-with-merges#-#") || key.equals("#-#partition-list#-#");
    }

    @VisibleForTesting
    public List<PartitionAndPath> getAllKeysDebug() throws StorageException {
        ArrayList<PartitionAndPath> list = new ArrayList<PartitionAndPath>();
        this.store.scanKeys(new byte[0], (key, value) -> {
            String keyString = StringUtils.bytesToString((byte[])key);
            if (!PartitionIndexBase.isHiddenKey(keyString)) {
                PartitionAndPath partitionAndPath = PartitionIndexBase.splitKey(keyString);
                List list2 = list;
                synchronized (list2) {
                    list.add(partitionAndPath);
                }
            }
        });
        return list;
    }
}

