/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.collections;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.collections.DurableCollectionHelper;
import org.conqat.engine.persistence.index.collections.EDurableCollectionOperation;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.io.ByteArrayUtils;

public class DurableCounterSet<T extends Serializable> {
    private static final Logger LOGGER = LogManager.getLogger();
    private CounterSet<T> delegate = new CounterSet();
    private final DurableCollectionHelper helper;

    DurableCounterSet(IStore store, byte[] keyPrefix) throws StorageException {
        this.helper = new DurableCollectionHelper(this, store, keyPrefix){
            final /* synthetic */ DurableCounterSet this$0;
            {
                DurableCounterSet durableCounterSet = this$0;
                Objects.requireNonNull(durableCounterSet);
                this.this$0 = durableCounterSet;
                super(store, keyPrefix);
            }

            @Override
            protected int getCollectionSize() {
                return this.this$0.delegate.getKeys().size();
            }

            @Override
            protected byte[] serializeFullCollection() throws StorageException {
                return StorageUtils.serialize(this.this$0.delegate);
            }

            @Override
            protected void replayOperation(EDurableCollectionOperation operation, byte[] parameter) throws StorageException {
                this.this$0.replayOperation(operation, parameter);
            }
        };
    }

    private void replayOperation(EDurableCollectionOperation operation, byte[] parameter) throws StorageException {
        switch (operation) {
            case SNAPSHOT: {
                this.delegate = (CounterSet)StorageUtils.deserialize(parameter);
                break;
            }
            case REMOVE: {
                this.delegate.remove(StorageUtils.deserialize(parameter));
                break;
            }
            case CLEAR: {
                this.delegate.clear();
                break;
            }
            case ADD: {
                int amount = ByteArrayUtils.byteArrayToInt((byte[])Arrays.copyOfRange(parameter, parameter.length - 4, parameter.length));
                Object key = StorageUtils.deserialize(Arrays.copyOf(parameter, parameter.length - 4));
                this.delegate.inc(key, amount);
                break;
            }
            default: {
                throw new StorageException("Unsupported operation: " + String.valueOf((Object)operation));
            }
        }
    }

    public UnmodifiableSet<T> getKeys() {
        return this.delegate.getKeys();
    }

    public int getValue(T key) {
        return this.delegate.getValue(key);
    }

    public int getTotal() {
        return this.delegate.getTotal();
    }

    public void inc(T key, int amount) {
        if (amount == 0) {
            return;
        }
        this.delegate.inc(key, amount);
        try {
            this.helper.storeOperation(EDurableCollectionOperation.ADD, ByteArrayUtils.concat((byte[][])new byte[][]{StorageUtils.serialize(key), ByteArrayUtils.intToByteArray((int)amount)}));
        }
        catch (StorageException e) {
            LOGGER.error("Failed to persist collection change! Stored data might be inconsistent until next snapshot!", (Throwable)((Object)e));
        }
    }

    public void remove(T key) {
        if (!this.delegate.contains(key)) {
            return;
        }
        this.delegate.remove(key);
        try {
            this.helper.storeOperation(EDurableCollectionOperation.REMOVE, StorageUtils.serialize(key));
        }
        catch (StorageException e) {
            LOGGER.error("Failed to persist collection change! Stored data might be inconsistent until next snapshot!", (Throwable)((Object)e));
        }
    }

    public void clear() {
        if (this.delegate.isEmpty()) {
            return;
        }
        this.delegate.clear();
        try {
            this.helper.storeOperation(EDurableCollectionOperation.CLEAR, null);
        }
        catch (StorageException e) {
            LOGGER.error("Failed to persist collection change! Stored data might be inconsistent until next snapshot!", (Throwable)((Object)e));
        }
    }
}

