/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed.query.autocomplete;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.keyed.EKeyedObjectType;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectIndex;
import org.conqat.engine.persistence.index.keyed.query.autocomplete.QueryAutocompleterBase;
import org.conqat.engine.persistence.index.keyed.query.error.QueryCompilationException;
import org.conqat.engine.persistence.index.keyed.query.lexer.EQueryTokenType;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CaseInsensitiveStringSet;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.function.SupplierWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

public class IndexAutocompleter
extends QueryAutocompleterBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IKeyedObjectIndex<?> index;
    private final CaseInsensitiveStringSet attributeNames = new CaseInsensitiveStringSet();
    private final Map<String, List<String>> staticSuggestions;
    private final Map<Pair<EQueryTokenType, Integer>, SupplierWithException<List<String>, ?>> suggestionsForFunctionKeywords;
    private final PairList<String, EKeyedObjectType> knownColumns;

    public IndexAutocompleter(IKeyedObjectIndex<?> index, Map<String, List<String>> staticSuggestions, Map<Pair<EQueryTokenType, Integer>, SupplierWithException<List<String>, ?>> suggestionsForFunctionKeywords, int maxSuggestions) throws StorageException {
        super(maxSuggestions);
        this.index = index;
        this.staticSuggestions = staticSuggestions;
        this.suggestionsForFunctionKeywords = suggestionsForFunctionKeywords;
        this.knownColumns = index.getKnownColumns();
        this.attributeNames.addAll((Collection)this.knownColumns.extractFirstList());
    }

    @Override
    protected List<String> getAttributesStartingWith(String prefix) {
        String lowerCasePrefix = prefix.toLowerCase();
        return this.knownColumns.stream().filter(column -> ((String)column.getFirst()).toLowerCase().startsWith(lowerCasePrefix)).map(IndexAutocompleter::getStringRepresentation).collect(Collectors.toList());
    }

    private static String getStringRepresentation(Pair<String, EKeyedObjectType> columnNameAndType) {
        if (columnNameAndType.getSecond() == EKeyedObjectType.NUMBER_MAP || columnNameAndType.getSecond() == EKeyedObjectType.STRING_MAP) {
            return (String)columnNameAndType.getFirst() + "()";
        }
        return (String)columnNameAndType.getFirst();
    }

    @Override
    protected List<String> getFunctionArgumentsStartingWith(EQueryTokenType functionKeyword, int argumentIndex, String prefix) {
        Pair key = new Pair((Object)functionKeyword, (Object)argumentIndex);
        if (this.suggestionsForFunctionKeywords.containsKey(key)) {
            List suggestions;
            try {
                suggestions = (List)this.suggestionsForFunctionKeywords.get(key).get();
            }
            catch (Exception e) {
                LOGGER.error("Failed to load suggestions for function keyword {} and argument index {}", (Object)functionKeyword, (Object)argumentIndex, (Object)e);
                return Collections.emptyList();
            }
            return CollectionUtils.filter((Collection)suggestions, suggestion -> suggestion.startsWith(prefix));
        }
        return this.getAttributesStartingWith(prefix);
    }

    @Override
    protected List<String> getValuesStartingWith(String attributeName, String prefix) {
        if ((attributeName = this.attributeNames.get(attributeName)) == null) {
            return Collections.emptyList();
        }
        String lowerCasePrefix = prefix.toLowerCase();
        try {
            List<String> values = this.index.getKnownValues(attributeName);
            EKeyedObjectType attributeType = IKeyedObjectIndex.getColumnType(attributeName, this.knownColumns);
            if (this.staticSuggestions.containsKey(attributeName)) {
                values.addAll((Collection<String>)this.staticSuggestions.get(attributeName));
            }
            return IndexAutocompleter.collectSuggestions(lowerCasePrefix, values, attributeType);
        }
        catch (QueryCompilationException | StorageException e) {
            return Collections.emptyList();
        }
    }

    private static @NonNull List<String> collectSuggestions(String lowerCasePrefix, List<String> values, EKeyedObjectType attributeType) throws QueryCompilationException {
        CaseInsensitiveStringSet suggestions = new CaseInsensitiveStringSet();
        switch (attributeType) {
            case NUMBER: 
            case STRING: 
            case STRING_MAP: 
            case DATE: {
                suggestions.addAll(values);
                break;
            }
            case STRING_LIST: {
                for (String value : values) {
                    suggestions.addAll((Collection)StringUtils.splitToList((String)value, (String)","));
                }
                break;
            }
            default: {
                throw new QueryCompilationException("Unknown type: " + String.valueOf((Object)attributeType), attributeType.name());
            }
        }
        return CollectionUtils.filter((Collection)suggestions, suggestion -> suggestion.toLowerCase().startsWith(lowerCasePrefix) && !StringUtils.isEmpty((String)suggestion));
    }
}

