/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed.query.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.conqat.engine.persistence.index.keyed.EKeyedObjectType;
import org.conqat.engine.persistence.index.keyed.query.engine.DelegatingCompilationContext;
import org.conqat.engine.persistence.index.keyed.query.error.QueryCompilationException;
import org.conqat.engine.persistence.index.keyed.query.tree.ICompilationContext;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;

public class AttributeCollectingDescriberCompilationContext<T>
extends DelegatingCompilationContext<T> {
    private final SetMap<String, String> accessedAttributesAndValues = new SetMap();

    public AttributeCollectingDescriberCompilationContext(ICompilationContext<T> delegate) {
        super(delegate);
    }

    @Override
    public Predicate<T> getAttributeEqualsIgnoreCasePredicate(String attribute, String comparisonValue, boolean lenient) throws QueryCompilationException {
        this.accessedAttributesAndValues.add((Object)attribute, (Object)comparisonValue);
        return super.getAttributeEqualsIgnoreCasePredicate(attribute, comparisonValue, lenient);
    }

    @Override
    public Function<T, String> getAttributeAccessor(String attribute) throws QueryCompilationException {
        this.accessedAttributesAndValues.add((Object)attribute, null);
        return super.getAttributeAccessor(attribute);
    }

    public List<String> getMultiAccessedAttributes(Map<String, EKeyedObjectType> attributeTypes) {
        ArrayList<String> attributes = new ArrayList<String>();
        for (String attributeName : this.accessedAttributesAndValues.getKeys()) {
            Set values = (Set)this.accessedAttributesAndValues.getCollection((Object)attributeName);
            if (AttributeCollectingDescriberCompilationContext.canBeUsedAsExactValueAttribute(values, attributeTypes.get(attributeName))) continue;
            attributes.add(attributeName);
        }
        return attributes;
    }

    public PairList<String, String> getExactValueAttributes(Map<String, EKeyedObjectType> attributeTypes) {
        PairList attributesAndValues = new PairList();
        for (String attributeName : this.accessedAttributesAndValues.getKeys()) {
            Set values = (Set)this.accessedAttributesAndValues.getCollection((Object)attributeName);
            if (!AttributeCollectingDescriberCompilationContext.canBeUsedAsExactValueAttribute(values, attributeTypes.get(attributeName))) continue;
            attributesAndValues.add((Object)attributeName, (Object)((String)CollectionUtils.getAny((Iterable)values)));
        }
        return attributesAndValues;
    }

    private static boolean canBeUsedAsExactValueAttribute(Set<String> values, EKeyedObjectType type) {
        return values.size() == 1 && !values.contains(null) && type != EKeyedObjectType.STRING_LIST;
    }
}

