/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed.query.tree;

import java.util.function.Function;
import java.util.function.Predicate;
import org.conqat.engine.persistence.index.keyed.EKeyedObjectType;
import org.conqat.engine.persistence.index.keyed.query.error.QueryCompilationException;
import org.conqat.engine.persistence.index.keyed.query.tree.ICompilationContext;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;

public interface IAttributeOperand {
    public <T> EKeyedObjectType getType(ICompilationContext<T> var1) throws QueryCompilationException;

    public <T> Function<T, Object> getValueAccessor(ICompilationContext<T> var1) throws QueryCompilationException;

    public <T> Predicate<T> getValueEqualsIgnoreCasePredicate(ICompilationContext<T> var1, Object var2, boolean var3) throws QueryCompilationException;

    public static Predicate<String> stringComparer(String comparisonValue, boolean lenient) {
        CCSMAssert.isNotNull((Object)comparisonValue, () -> String.format("Expected \"%s\" to be not null", "comparisonValue"));
        if (lenient) {
            return value -> {
                if (StringUtils.isEmpty((String)value)) {
                    return StringUtils.isEmpty((String)comparisonValue);
                }
                return StringUtils.containsIgnoreCase((String)comparisonValue, (String)value);
            };
        }
        return comparisonValue::equalsIgnoreCase;
    }
}

