/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.branched;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.BranchCommitInsertingStore;
import org.conqat.engine.persistence.store.branched.ECommitStatus;
import org.conqat.engine.persistence.store.branched.IBranchCommitInfo;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;
import org.conqat.engine.persistence.store.branched.ICommitLayeringDataLayout;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.engine.persistence.store.util.ExceptionHandlingKeyValueCallbackBase;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public abstract class BranchCommitInfoBasedBranchingLayerBase
implements IBranchingLayer {
    protected final IStore store;
    protected final ICommitLayeringDataLayout dataLayout;

    protected BranchCommitInfoBasedBranchingLayerBase(IStore store, ICommitLayeringDataLayout dataLayout) {
        this.store = store;
        this.dataLayout = dataLayout;
    }

    @Override
    public IStore openStore(HistoryAccessOption historyAccessOption) throws StorageException {
        switch (historyAccessOption.getAccessMode()) {
            case READ_HEAD: {
                IBranchCommitInfo headCommit = this.getHeadCommit(historyAccessOption);
                if (headCommit == null) {
                    return new InMemoryStore();
                }
                return this.createReadingStore(headCommit.getCommitName());
            }
            case READ_TIMESTAMP: {
                IBranchCommitInfo bestCommit = this.getNewestCommitBeforeOrAt(historyAccessOption.getBranchName(), historyAccessOption.getTimestamp());
                if (bestCommit == null) {
                    return new InMemoryStore();
                }
                return this.createReadingStore(bestCommit.getCommitName());
            }
            case WRITE_TIMESTAMP: {
                return this.createWritableBranchingStore(historyAccessOption);
            }
        }
        throw new AssertionError((Object)("Unknown access mode: " + String.valueOf((Object)historyAccessOption.getAccessMode())));
    }

    protected abstract IStore createReadingStore(byte[] var1) throws StorageException;

    protected abstract IStore createWritingStore(byte[] var1, byte @Nullable [] var2) throws StorageException;

    private IStore createWritableBranchingStore(HistoryAccessOption historyAccessOption) throws StorageException {
        byte[] commitName = BranchCommitInfoBasedBranchingLayerBase.createCommitName(historyAccessOption.getBranchName(), historyAccessOption.getTimestamp());
        IBranchCommitInfo targetCommit = this.readCommit(commitName);
        if (targetCommit != null) {
            CCSMAssert.isTrue((targetCommit.getStatus() != ECommitStatus.SEALED ? 1 : 0) != 0, (String)("Cannot open sealed commit for writing: " + historyAccessOption.getTimestamp() + "@" + historyAccessOption.getBranchName()));
            return this.createWritingStore(targetCommit.getCommitName(), targetCommit.getParentCommitName());
        }
        if (historyAccessOption.getParentBranch() != null) {
            return this.createCommitWithParent(historyAccessOption, commitName);
        }
        IBranchCommitInfo headCommit = this.getHeadCommit(historyAccessOption);
        if (headCommit == null) {
            return this.createWritingStore(commitName, null);
        }
        Pair<String, Long> headCommitInfo = BranchCommitInfoBasedBranchingLayerBase.parseCommitName(headCommit.getCommitName());
        BranchCommitInfoBasedBranchingLayerBase.checkForOlderInsertionTimestamp(historyAccessOption, headCommitInfo);
        if (historyAccessOption.getTimestamp() == ((Long)headCommitInfo.getSecond()).longValue()) {
            return this.createWritingStore(headCommit.getCommitName(), headCommit.getParentCommitName());
        }
        return this.createWritingStore(commitName, headCommit.getCommitName());
    }

    private IStore createCommitWithParent(HistoryAccessOption historyAccessOption, byte[] commitName) throws StorageException, AssertionError {
        byte[] parentCommitName = BranchCommitInfoBasedBranchingLayerBase.createCommitName(historyAccessOption.getParentBranch(), historyAccessOption.getParentTimestamp());
        IBranchCommitInfo parentCommit = this.readCommit(parentCommitName);
        CCSMAssert.isTrue((parentCommit != null ? 1 : 0) != 0, (String)("Parent commit may never be null if given: " + historyAccessOption.getParentTimestamp() + "@" + historyAccessOption.getParentBranch()));
        return this.createWritingStore(commitName, parentCommitName);
    }

    private static void checkForOlderInsertionTimestamp(HistoryAccessOption historyAccessOption, Pair<String, Long> headCommitInfo) throws StorageException {
        if (historyAccessOption.getTimestamp() < (Long)headCommitInfo.getSecond()) {
            throw new StorageException("Trying to insert older data at timestamp " + historyAccessOption.getTimestamp() + ", which is older than current head (timestamp " + String.valueOf(headCommitInfo.getSecond()) + ")");
        }
    }

    @Override
    public void performRollback(Map<String, Long> timestampByBranch) throws StorageException {
        for (Map.Entry<String, Long> entry : timestampByBranch.entrySet()) {
            String branchName = entry.getKey();
            Long cutOffTimestamp = timestampByBranch.get(branchName);
            if (cutOffTimestamp == null) continue;
            List<IBranchCommitInfo> commitKeysForBranch = this.getCommitInfosForBranch(branchName);
            RollbackResultData rollbackData = BranchCommitInfoBasedBranchingLayerBase.collectRollbackData(commitKeysForBranch, cutOffTimestamp);
            this.deleteCommits(rollbackData.commitsToDelete());
            this.unsealCommit(rollbackData.commitToUnseal());
            this.setHeadCommitPointer(rollbackData.newHeadCommit(), branchName);
        }
    }

    @VisibleForTesting
    static RollbackResultData collectRollbackData(List<IBranchCommitInfo> commitKeysForBranch, long cutOffTimestamp) {
        commitKeysForBranch.sort(Comparator.comparing(IBranchCommitInfo::getTimestamp).reversed());
        ArrayList<IBranchCommitInfo> commitsToDelete = new ArrayList<IBranchCommitInfo>();
        for (IBranchCommitInfo commit : commitKeysForBranch) {
            long commitTimestamp = commit.getTimestamp();
            if (commitTimestamp > cutOffTimestamp) {
                commitsToDelete.add(commit);
                continue;
            }
            if (commitTimestamp == cutOffTimestamp) {
                return new RollbackResultData(commit, commit, commitsToDelete);
            }
            return new RollbackResultData(commit, null, commitsToDelete);
        }
        return new RollbackResultData(null, null, commitsToDelete);
    }

    protected abstract void deleteCommits(List<IBranchCommitInfo> var1) throws StorageException;

    protected abstract void deleteCommit(byte[] var1) throws StorageException;

    public void unsealCommit(byte[] commitInfoKey) throws StorageException {
        IBranchCommitInfo commitInfo = this.dataLayout.deserializeCommitInfo(this.store.get(commitInfoKey));
        if (commitInfo == null) {
            throw new StorageException("Tried to unseal commit " + String.valueOf(this.parseCommitKey(commitInfoKey)) + " but could not find it. Should never happen!");
        }
        this.unsealCommit(commitInfo);
    }

    private void unsealCommit(@Nullable IBranchCommitInfo commitInfo) throws StorageException {
        if (commitInfo == null) {
            return;
        }
        IBranchCommitInfo writableCommitInfo = commitInfo.cloneWithNewStatus(ECommitStatus.WRITEABLE);
        BranchCommitInsertingStore.writeCommit(writableCommitInfo, this.store, this.dataLayout);
    }

    public void recalculateHeadCommitPointer(String branchName) throws StorageException {
        IBranchCommitInfo newest = this.getNewestCommitBeforeOrAtBasedOnCommitKeysForBranch(branchName, Long.MAX_VALUE);
        byte[] headKey = this.createHeadKey(branchName);
        if (newest != null) {
            this.store.put(headKey, newest.serializeToBytes());
        } else {
            this.store.remove(headKey);
        }
    }

    private void setHeadCommitPointer(@Nullable IBranchCommitInfo headCommitInfo, String branchName) throws StorageException {
        byte[] headKey = this.createHeadKey(branchName);
        if (headCommitInfo == null) {
            this.store.remove(headKey);
        } else {
            this.store.put(headKey, headCommitInfo.serializeToBytes());
        }
    }

    @Override
    public @Nullable IBranchCommitInfo getNewestCommitBeforeOrAt(String branchName, long timestamp) throws StorageException {
        IBranchCommitInfo exactCommit = this.readCommit(branchName, timestamp);
        if (exactCommit != null) {
            return exactCommit;
        }
        IBranchCommitInfo headCommit = this.readHeadCommit(branchName);
        if (headCommit != null && headCommit.getTimestamp() <= timestamp) {
            return headCommit;
        }
        return this.getNewestCommitBeforeOrAtBasedOnCommitKeysForBranch(branchName, timestamp);
    }

    public @Nullable IBranchCommitInfo getNewestCommitBeforeOrAtBasedOnCommitKeysForBranch(String branchName, long timestamp) throws StorageException {
        byte[] bestKey = null;
        long bestTimestamp = Long.MAX_VALUE;
        for (byte[] commitKey : this.getCommitKeysForBranch(branchName)) {
            Pair<String, Long> commitInfo = this.parseCommitKey(commitKey);
            long commitTimestamp = (Long)commitInfo.getSecond();
            if (commitTimestamp > timestamp || bestKey != null && commitTimestamp <= bestTimestamp) continue;
            bestKey = commitKey;
            bestTimestamp = commitTimestamp;
        }
        if (bestKey == null) {
            return null;
        }
        return this.dataLayout.deserializeCommitInfo(this.store.get(bestKey));
    }

    @Override
    public List<Long> getAllTimestampsForBranch(String branchName) throws StorageException {
        return CollectionUtils.map(this.getCommitKeysForBranch(branchName), key -> (Long)this.parseCommitKey((byte[])key).getSecond());
    }

    private List<byte[]> getCommitKeysForBranch(String branchName) throws StorageException {
        byte[] commonPrefix = this.dataLayout.createCommitInfoKey(StringUtils.stringToBytes((String)branchName));
        return CollectionUtils.filter(StorageUtils.listKeysStartingWith(commonPrefix, this.store), key -> ((byte[])key).length == 8 + commonPrefix.length);
    }

    public static byte[] createCommitName(String branchName, long timestamp) {
        return ByteArrayUtils.concat((byte[][])new byte[][]{StringUtils.stringToBytes((String)branchName), ByteArrayUtils.longToByteArray((long)timestamp)});
    }

    public Pair<String, Long> parseCommitKey(byte[] commitKey) {
        return BranchCommitInfoBasedBranchingLayerBase.parseCommitName(this.dataLayout.extractCommitNameFromCommitInfoKey(commitKey));
    }

    static Pair<String, Long> parseCommitName(byte[] commitName) {
        String branchName = StringUtils.bytesToString((byte[])Arrays.copyOfRange(commitName, 0, commitName.length - 8));
        long timestamp = ByteArrayUtils.byteArrayToLong((byte[])Arrays.copyOfRange(commitName, commitName.length - 8, commitName.length));
        return new Pair((Object)branchName, (Object)timestamp);
    }

    @Override
    public @Nullable IBranchCommitInfo readCommit(String branchName, long timestamp) throws StorageException {
        return this.readCommit(BranchCommitInfoBasedBranchingLayerBase.createCommitName(branchName, timestamp));
    }

    public @Nullable IBranchCommitInfo readCommit(byte[] commitName) throws StorageException {
        return this.dataLayout.deserializeCommitInfo(this.store.get(this.dataLayout.createCommitInfoKey(commitName)));
    }

    private byte[] createHeadKey(String branchName) {
        return this.dataLayout.createBranchHeadKey(branchName);
    }

    public List<byte[]> getHeadKeys(IStore store) throws StorageException {
        return StorageUtils.listKeysStartingWith(this.dataLayout.createBranchHeadKey(""), store);
    }

    private @Nullable IBranchCommitInfo getHeadCommit(HistoryAccessOption historyAccessOption) throws StorageException {
        return this.getNewestCommitBeforeOrAt(historyAccessOption.getBranchName(), Long.MAX_VALUE);
    }

    @Override
    public @Nullable IBranchCommitInfo readHeadCommit(String branchName) throws StorageException {
        return this.readHeadCommit(branchName, this.store);
    }

    private @Nullable IBranchCommitInfo readHeadCommit(String branchName, IStore store) throws StorageException {
        return this.dataLayout.deserializeCommitInfo(store.get(this.dataLayout.createBranchHeadKey(branchName)));
    }

    @Override
    public boolean commitExists(String branchName, long timestamp) throws StorageException {
        return this.store.get(this.dataLayout.createCommitInfoKey(BranchCommitInfoBasedBranchingLayerBase.createCommitName(branchName, timestamp))) != null;
    }

    @Override
    public PairList<String, Long> getAllBranchNamesAndTimestamps() throws StorageException {
        List<byte[]> keys = StorageUtils.listKeysStartingWith(this.dataLayout.createCommitInfoKey(new byte[0]), this.store);
        PairList result = new PairList(keys.size());
        keys.forEach(key -> result.add(this.parseCommitKey((byte[])key)));
        return result;
    }

    @Override
    public List<IBranchCommitInfo> getCommitInfos() throws StorageException {
        return this.getCommitInfosForPrefix(this.dataLayout.createCommitInfoKey(new byte[0]), -1);
    }

    @Override
    public List<IBranchCommitInfo> getCommitInfosForBranch(String branchName) throws StorageException {
        byte[] commonPrefix = this.dataLayout.createCommitInfoKey(StringUtils.stringToBytes((String)branchName));
        return this.getCommitInfosForPrefix(commonPrefix, 8 + commonPrefix.length);
    }

    private List<IBranchCommitInfo> getCommitInfosForPrefix(byte[] commonPrefix, final int expectedLength) throws StorageException {
        final ArrayList<IBranchCommitInfo> commitInfos = new ArrayList<IBranchCommitInfo>();
        ExceptionHandlingKeyValueCallbackBase valueCallback = new ExceptionHandlingKeyValueCallbackBase(this){
            final /* synthetic */ BranchCommitInfoBasedBranchingLayerBase this$0;
            {
                BranchCommitInfoBasedBranchingLayerBase branchCommitInfoBasedBranchingLayerBase = this$0;
                Objects.requireNonNull(branchCommitInfoBasedBranchingLayerBase);
                this.this$0 = branchCommitInfoBasedBranchingLayerBase;
            }

            @Override
            protected void callbackWithException(byte[] key, byte[] value) throws StorageException {
                if (expectedLength < 0 || key.length == expectedLength) {
                    commitInfos.add(this.this$0.dataLayout.deserializeCommitInfo(value));
                }
            }
        };
        this.store.scan(commonPrefix, (IKeyValueCallback)valueCallback);
        valueCallback.throwCaughtException();
        return commitInfos;
    }

    @Override
    public boolean isEmpty() throws StorageException {
        return this.getHeadKeys(this.store).isEmpty();
    }

    @VisibleForTesting
    record RollbackResultData(@Nullable IBranchCommitInfo newHeadCommit, @Nullable IBranchCommitInfo commitToUnseal, List<IBranchCommitInfo> commitsToDelete) {
    }
}

