/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.branched;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.BranchCommitInfoBasedBranchingLayerBase;
import org.conqat.engine.persistence.store.branched.BranchCommitReadingStore;
import org.conqat.engine.persistence.store.branched.CommitLayeringBranchingLayer;
import org.conqat.engine.persistence.store.branched.ECommitStatus;
import org.conqat.engine.persistence.store.branched.IBranchCommitInfo;
import org.conqat.engine.persistence.store.branched.ICommitLayeringDataLayout;
import org.conqat.engine.persistence.store.transaction.TransactionalStore;
import org.conqat.engine.persistence.store.util.ExceptionHandlingKeyValueCallbackBase;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class BranchCommitInsertingStore
extends BranchCommitReadingStore {
    private static final int COMMIT_COPY_BATCH_SIZE = 10000;
    private final byte[] commitNameForDataKeys;

    public BranchCommitInsertingStore(IStore delegate, ICommitLayeringDataLayout dataLayout, byte[] commitName, byte[] parentCommitName) throws StorageException {
        super(delegate, dataLayout);
        this.commitNameForDataKeys = this.createCommitInfo(commitName, parentCommitName);
        if (this.commitNameForDataKeys == null) {
            throw new AssertionError((Object)"foo");
        }
        this.commitNamesForDataKeys = this.determineDeltaHierarchyCommitNames(commitName);
    }

    private byte[] createCommitInfo(byte[] commitName, byte[] parentCommitName) throws StorageException {
        Lock lock = this.store.obtainLock("commit-creation-" + StringUtils.encodeAsHex((byte[])commitName));
        lock.lock();
        try {
            IBranchCommitInfo commit = this.readCommit(commitName);
            if (commit == null) {
                byte[] byArray = this.createCommit(commitName, parentCommitName);
                return byArray;
            }
            switch (commit.getStatus()) {
                case SEALED: {
                    throw new StorageException("Can not write to commit " + BranchCommitInsertingStore.formatCommitName(commitName) + " as it is already sealed!");
                }
                case WRITEABLE: {
                    byte[] byArray = BranchCommitInsertingStore.checkForConsistentParent(parentCommitName, commit);
                    return byArray;
                }
            }
            throw new AssertionError((Object)("Unknown status: " + String.valueOf((Object)commit.getStatus())));
        }
        finally {
            lock.unlock();
        }
    }

    private static byte[] checkForConsistentParent(byte[] parentCommitName, IBranchCommitInfo commit) throws StorageException {
        if (!Arrays.equals(parentCommitName, commit.getParentCommitName())) {
            throw new StorageException("Inconsistent parent for writing commit " + BranchCommitInsertingStore.formatCommitName(commit.getCommitName()) + ". Tried to write " + BranchCommitInsertingStore.formatCommitName(parentCommitName) + " but stored is " + BranchCommitInsertingStore.formatCommitName(commit.getParentCommitName()));
        }
        return commit.getCommitNameForDataKeys();
    }

    private byte[] createCommit(byte[] commitName, byte[] parentCommitName) throws StorageException {
        if (parentCommitName == null) {
            IBranchCommitInfo commitInfo = this.dataLayout.createInitialBranchCommitInfo(commitName, this.store);
            BranchCommitInsertingStore.writeCommit(commitInfo, this.store, this.dataLayout);
            return commitInfo.getCommitNameForDataKeys();
        }
        IBranchCommitInfo parentCommit = this.readCommit(parentCommitName);
        if (parentCommit == null) {
            Pair<String, Long> parentCommitBranchAndTimestamp = CommitLayeringBranchingLayer.parseCommitName(parentCommitName);
            throw new StorageException("Parent commit " + (String)parentCommitBranchAndTimestamp.getFirst() + "(timestamp: " + String.valueOf(parentCommitBranchAndTimestamp.getSecond()) + "),  (hex: " + StringUtils.encodeAsHex((byte[])parentCommitName) + ") was not found! Is the parent commit correct?");
        }
        if (parentCommit.getStatus() != ECommitStatus.SEALED) {
            BranchCommitInsertingStore.writeCommit(parentCommit.cloneWithNewStatus(ECommitStatus.SEALED), this.store, this.dataLayout);
        }
        ArrayList<byte[]> mergeCommitNames = new ArrayList<byte[]>();
        byte[] deltaPredecessorCommitName = this.fillMergeCommitNamesAndDetermineDeltaPredecessor(parentCommit, mergeCommitNames);
        IBranchCommitInfo commitInfo = this.dataLayout.createParentedBranchCommitInfo(commitName, parentCommit, deltaPredecessorCommitName, this.determineDeltaHierarchyCommitNames(deltaPredecessorCommitName), this.store);
        this.copyMergeCommitValues(mergeCommitNames, deltaPredecessorCommitName == null, commitInfo);
        BranchCommitInsertingStore.writeCommit(commitInfo, this.store, this.dataLayout);
        return commitInfo.getCommitNameForDataKeys();
    }

    private void copyMergeCommitValues(List<byte[]> mergeCommitNames, final boolean persistTombStones, IBranchCommitInfo commitInfo) throws StorageException {
        final TransactionalStore transactionalStore = new TransactionalStore(this.store);
        for (byte[] mergeCommitName : CollectionUtils.reverse(mergeCommitNames)) {
            final int offset = this.dataLayout.determineKeyOffset(mergeCommitName);
            final byte[] commitBinaryName = commitInfo.getCommitNameForDataKeys();
            ExceptionHandlingKeyValueCallbackBase callback = new ExceptionHandlingKeyValueCallbackBase(this){
                final /* synthetic */ BranchCommitInsertingStore this$0;
                {
                    BranchCommitInsertingStore branchCommitInsertingStore = this$0;
                    Objects.requireNonNull(branchCommitInsertingStore);
                    this.this$0 = branchCommitInsertingStore;
                }

                @Override
                protected void callbackWithException(byte[] key, byte[] value) throws StorageException {
                    byte[] originalKey = Arrays.copyOfRange(key, offset, key.length);
                    if (persistTombStones && BranchCommitReadingStore.isTombStone(value)) {
                        transactionalStore.remove(this.this$0.dataLayout.createCommitEntryKey(commitBinaryName, originalKey));
                    } else {
                        transactionalStore.put(this.this$0.dataLayout.createCommitEntryKey(commitBinaryName, originalKey), value);
                    }
                    if (transactionalStore.getPendingWriteCount() >= 10000) {
                        transactionalStore.commit();
                    }
                }
            };
            this.store.scan(this.dataLayout.createCommitEntryKey(mergeCommitName, null), (IKeyValueCallback)callback);
            callback.throwCaughtException();
            transactionalStore.commit();
        }
    }

    private byte @Nullable [] fillMergeCommitNamesAndDetermineDeltaPredecessor(@Nullable IBranchCommitInfo commitInfo, List<byte[]> mergeCommitNames) throws StorageException {
        if (commitInfo == null) {
            return null;
        }
        int commitDepth = commitInfo.getDepth() + 1;
        while ((commitDepth & 1) == 0 && commitInfo != null) {
            commitDepth >>= 1;
            mergeCommitNames.add(commitInfo.getCommitNameForDataKeys());
            commitInfo = this.readCommit(commitInfo.getDeltaPredecessorCommitName());
        }
        if (commitInfo == null) {
            return null;
        }
        return commitInfo.getCommitName();
    }

    static void writeCommit(IBranchCommitInfo commit, IStore store, ICommitLayeringDataLayout dataLayout) throws StorageException {
        PairList data = new PairList(2);
        byte[] serializedCommit = commit.serializeToBytes();
        byte[] commitName = commit.getCommitName();
        String branchName = (String)BranchCommitInfoBasedBranchingLayerBase.parseCommitName(commitName).getFirst();
        data.add((Object)dataLayout.createCommitInfoKey(commitName), (Object)serializedCommit);
        data.add((Object)dataLayout.createBranchHeadKey(branchName), (Object)serializedCommit);
        store.put((PairList<byte[], byte[]>)data);
    }

    @Override
    public void put(byte @NonNull [] key, byte @NonNull [] value) throws StorageException {
        if (BranchCommitInsertingStore.isActualValueOrTombStone(value)) {
            this.store.put(this.commitEntryKey(key), value);
        } else {
            PairList keysValues = new PairList();
            this.insertWithDeduplication(key, value, (PairList<byte[], byte[]>)keysValues);
            this.store.put((PairList<byte[], byte[]>)keysValues);
        }
    }

    @Override
    public void put(PairList<byte @NonNull [], byte @NonNull []> keysValues) throws StorageException {
        PairList adjustedKeysValues = new PairList();
        for (int i = 0; i < keysValues.size(); ++i) {
            byte[] key = (byte[])keysValues.getFirst(i);
            byte[] value = (byte[])keysValues.getSecond(i);
            if (BranchCommitInsertingStore.isActualValueOrTombStone(value)) {
                adjustedKeysValues.add((Object)this.commitEntryKey(key), (Object)value);
                continue;
            }
            this.insertWithDeduplication(key, value, (PairList<byte[], byte[]>)adjustedKeysValues);
        }
        this.store.put((PairList<byte[], byte[]>)adjustedKeysValues);
    }

    private void insertWithDeduplication(byte[] key, byte[] value, PairList<byte[], byte[]> keysValues) {
        byte[] referenceKey = CommitLayeringBranchingLayer.createReferenceKey(value);
        keysValues.add((Object)this.dataLayout.createDataKey(referenceKey), (Object)value);
        keysValues.add((Object)this.commitEntryKey(key), (Object)referenceKey);
    }

    @Override
    public void remove(byte @NonNull [] key) throws StorageException {
        this.store.put(this.commitEntryKey(key), TOMB_STONE_MARKER);
    }

    @Override
    public void remove(List<byte @NonNull []> keys) throws StorageException {
        PairList tombStones = new PairList();
        for (byte[] key : keys) {
            tombStones.add((Object)this.commitEntryKey(key), (Object)TOMB_STONE_MARKER);
        }
        this.store.put((PairList<byte[], byte[]>)tombStones);
    }

    private byte[] commitEntryKey(byte[] key) {
        return this.dataLayout.createCommitEntryKey(this.commitNameForDataKeys, key);
    }
}

