/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.branched;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.conqat.engine.core.cancel.ExecutionCanceledException;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.index.schema.SchemaEntry;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.CommitLayeringBranchingLayer;
import org.conqat.engine.persistence.store.branched.CompactCommitLayeringDataLayout;
import org.conqat.engine.persistence.store.branched.IBranchCommitInfo;
import org.conqat.engine.persistence.store.branched.PlainCommitLayeringDataLayout;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.PairList;
import org.jspecify.annotations.Nullable;

public interface IBranchingLayer {
    public IStore openStore(HistoryAccessOption var1) throws StorageException;

    public void performRollback(Map<String, Long> var1) throws StorageException;

    public @Nullable IBranchCommitInfo getNewestCommitBeforeOrAt(String var1, long var2) throws StorageException;

    public List<Long> getAllTimestampsForBranch(String var1) throws StorageException;

    public IBranchCommitInfo readHeadCommit(String var1) throws StorageException;

    public PairList<String, Long> getAllBranchNamesAndTimestamps() throws StorageException;

    public List<IBranchCommitInfo> getCommitInfos() throws StorageException;

    public List<IBranchCommitInfo> getCommitInfosForBranch(String var1) throws StorageException;

    public IBranchCommitInfo readCommit(String var1, long var2) throws StorageException;

    public static IBranchingLayer create(IStore store, SchemaEntry schemaEntry) {
        if (schemaEntry.usesOption(EStorageOption.BACKUP)) {
            return new CommitLayeringBranchingLayer(store, new PlainCommitLayeringDataLayout());
        }
        return new CommitLayeringBranchingLayer(store, new CompactCommitLayeringDataLayout());
    }

    public List<byte[]> getValues(PairList<String, Long> var1, byte[] var2) throws StorageException;

    public long removeOrphanedDataEntries(ICancelable var1) throws StorageException, ExecutionCanceledException;

    public boolean commitExists(String var1, long var2) throws StorageException;

    public boolean isEmpty() throws StorageException;

    public void scanAllKeysInAllCommits(Consumer<byte[]> var1) throws StorageException;
}

