/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.crypto;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.index.schema.SchemaEntry;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.jetbrains.annotations.TestOnly;

public class EncryptedStorageHandler {
    private static final boolean ENCRYPT_ALL_STORES = Boolean.getBoolean("com.teamscale.crypto.encrypt-all");
    private static final String CIPHER_TRANSFORMATION = "AES/CBC/PKCS5PADDING";
    private static final int INITIALIZATION_VECTOR_BYTES = 16;
    private static final String SALT = "imah2aiFchup8Da8";
    private static SecretKeySpec primaryKey = null;
    private static final List<SecretKeySpec> ALTERNATIVE_KEYS = new ArrayList<SecretKeySpec>();
    private static final ThreadLocal<Cipher> CIPHER_CACHE = new ThreadLocal();
    private static final ThreadLocal<SecureRandom> RANDOM = ThreadLocal.withInitial(SecureRandom::new);

    public static boolean isEncrypted(SchemaEntry entry) {
        return ENCRYPT_ALL_STORES || entry.usesOption(EStorageOption.ENCRYPTED);
    }

    public static SecretKeySpec getDefaultKey() throws NoSuchAlgorithmException, InvalidKeySpecException {
        return EncryptedStorageHandler.createKey("la2Riopo veel4Eke xeoSu6xu Eighuun8 Ehie2luR ohqu6Ohh");
    }

    public static byte[] encrypt(byte[] data, SecretKeySpec key) throws StorageException {
        if (data == null) {
            return null;
        }
        Cipher cipher = EncryptedStorageHandler.getCipher();
        byte[] initializationVector = new byte[16];
        RANDOM.get().nextBytes(initializationVector);
        try {
            cipher.init(1, (Key)key, new IvParameterSpec(initializationVector));
            return ByteArrayUtils.concat((byte[][])new byte[][]{initializationVector, cipher.doFinal(data)});
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new StorageException("Failed to apply encryption: " + e.getMessage(), e);
        }
    }

    public static byte[] decrypt(byte[] data, SecretKeySpec key) throws StorageException {
        if (data == null) {
            return null;
        }
        Cipher cipher = EncryptedStorageHandler.getCipher();
        try {
            cipher.init(2, (Key)key, new IvParameterSpec(Arrays.copyOf(data, 16)));
            return cipher.doFinal(Arrays.copyOfRange(data, 16, data.length));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            throw new StorageException("Failed to apply decryption: " + e.getMessage(), e);
        }
    }

    private static Cipher getCipher() throws StorageException {
        Cipher cipher = CIPHER_CACHE.get();
        if (cipher == null) {
            try {
                cipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
                throw new StorageException("Could not initialize crypto backend: " + e.getMessage(), e);
            }
            CIPHER_CACHE.set(cipher);
        }
        return cipher;
    }

    public static SecretKeySpec createKey(String key) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec spec = new PBEKeySpec(key.toCharArray(), SALT.getBytes(StandardCharsets.UTF_8), 65536, 256);
        return new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
    }

    public static SecretKeySpec createKey(File file) throws NoSuchAlgorithmException, InvalidKeySpecException, IOException {
        return EncryptedStorageHandler.createKey(FileSystemUtils.readFileUTF8((File)file).trim());
    }

    public static SecretKeySpec getPrimaryKey() {
        CCSMAssert.isNotNull((Object)primaryKey, (String)"Must configure primary key first!");
        return primaryKey;
    }

    public static void setPrimaryKey(SecretKeySpec key) {
        CCSMAssert.isTrue((primaryKey == null || primaryKey.equals(key) ? 1 : 0) != 0, (String)"May not set primary key more than once!");
        primaryKey = key;
    }

    public static boolean isPrimaryKeySet() {
        return primaryKey != null;
    }

    public static void setTestPrimaryKey(SecretKeySpec key) {
        primaryKey = key;
    }

    @TestOnly
    public static void setTestMode() {
        try {
            primaryKey = EncryptedStorageHandler.createKey("testing");
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new AssertionError("Failed to setup key during testing!", e);
        }
    }

    public static void addAlternativeKey(SecretKeySpec key) {
        ALTERNATIVE_KEYS.add(key);
    }

    public static List<SecretKeySpec> getAllKeys() {
        ArrayList<SecretKeySpec> keys = new ArrayList<SecretKeySpec>();
        keys.add(primaryKey);
        keys.addAll(ALTERNATIVE_KEYS);
        return keys;
    }
}

