/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.hist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.ByteArrayComparator;
import org.conqat.engine.persistence.store.hist.HeadReadOnlyHistorizingStore;
import org.conqat.engine.persistence.store.hist.HistorizingStoreBase;
import org.conqat.engine.persistence.store.hist.TimestampReadOnlyHistorizingStore;
import org.conqat.engine.persistence.store.util.ExceptionHandlingKeyValueCallbackBase;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.test.ThreadSafe;

public class RollbackableHistorizingStore
extends HeadReadOnlyHistorizingStore
implements IRollbackableIndex {
    private static final int HEAD_RECOVERY_BATCH_SIZE = 100;
    private static final int DELETE_CACHE_SIZE = 1000;

    public RollbackableHistorizingStore(IStore delegate) {
        super(delegate);
    }

    @Override
    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) throws StorageException {
        Long timestamp = IRollbackableIndex.getNonBranchedRollbackTimestamp(timestampByBranch);
        if (timestamp == null) {
            return;
        }
        RollbackCallback callback = new RollbackCallback(this, timestamp);
        this.store.scanKeys(new byte[0], (IKeyValueCallback)callback);
        callback.persistResults();
    }

    private static long getKeyTimestamp(byte[] key) {
        return ByteArrayUtils.byteArrayToLong((byte[])Arrays.copyOfRange(key, key.length - 8, key.length));
    }

    @ThreadSafe
    private class RollbackCallback
    extends ExceptionHandlingKeyValueCallbackBase {
        private final long timestamp;
        private final List<byte[]> toDeleteCache;
        private final Set<byte[]> headChangeKeys;
        final /* synthetic */ RollbackableHistorizingStore this$0;

        public RollbackCallback(RollbackableHistorizingStore rollbackableHistorizingStore, long timestamp) {
            RollbackableHistorizingStore rollbackableHistorizingStore2 = rollbackableHistorizingStore;
            Objects.requireNonNull(rollbackableHistorizingStore2);
            this.this$0 = rollbackableHistorizingStore2;
            this.toDeleteCache = new ArrayList<byte[]>();
            this.headChangeKeys = new TreeSet<byte[]>(ByteArrayComparator.INSTANCE);
            this.timestamp = timestamp;
        }

        @Override
        protected void callbackWithException(byte[] key, byte[] value) throws StorageException {
            if (ByteArrayUtils.isPrefix((byte[])HistorizingStoreBase.HEAD_PREFIX, (byte[])key)) {
                return;
            }
            long keyTimestamp = RollbackableHistorizingStore.getKeyTimestamp(key);
            if (keyTimestamp <= this.timestamp) {
                return;
            }
            this.toDeleteCache.add(key);
            this.checkDeleteCache(false);
            this.headChangeKeys.add(Arrays.copyOf(key, key.length - 1 - 8));
        }

        private void checkDeleteCache(boolean force) throws StorageException {
            if (force || this.toDeleteCache.size() >= 1000) {
                this.this$0.store.remove(this.toDeleteCache);
                this.toDeleteCache.clear();
            }
        }

        public void persistResults() throws StorageException {
            this.throwCaughtException();
            this.checkDeleteCache(true);
            ArrayList<byte[]> headChangeKeysList = new ArrayList<byte[]>(this.headChangeKeys);
            TimestampReadOnlyHistorizingStore timestampStore = new TimestampReadOnlyHistorizingStore(this.this$0.store, this.timestamp);
            for (int i = 0; i < headChangeKeysList.size(); i += 100) {
                int end = Math.min(i + 100, headChangeKeysList.size());
                this.refreshHead(headChangeKeysList.subList(i, end), timestampStore);
            }
        }

        private void refreshHead(List<byte[]> headKeys, TimestampReadOnlyHistorizingStore timestampStore) throws StorageException {
            List<byte[]> values = timestampStore.get(headKeys);
            PairList toUpdate = new PairList();
            ArrayList<byte[]> toDelete = new ArrayList<byte[]>();
            for (int i = 0; i < headKeys.size(); ++i) {
                if (values.get(i) == null) {
                    toDelete.add(HistorizingStoreBase.headKey(headKeys.get(i)));
                    continue;
                }
                toUpdate.add((Object)HistorizingStoreBase.headKey(headKeys.get(i)), (Object)values.get(i));
            }
            if (!toDelete.isEmpty()) {
                this.this$0.store.remove(toDelete);
            }
            if (!toUpdate.isEmpty()) {
                this.this$0.store.put((PairList<byte[], byte[]>)toUpdate);
            }
        }
    }
}

