/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.hist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.hist.HistorizingStoreBase;
import org.conqat.lib.commons.collections.ByteArrayWrapper;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
abstract class TimestampAwareKeyCollectorCallbackBase
implements IKeyValueCallback {
    private final byte[] timestampSuffix;
    private final Map<ByteArrayWrapper, byte[]> keys = new HashMap<ByteArrayWrapper, byte[]>();

    protected TimestampAwareKeyCollectorCallbackBase(byte[] timestampSuffix) {
        this.timestampSuffix = timestampSuffix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(byte[] key, byte[] value) {
        if (ByteArrayUtils.isPrefix((byte[])HistorizingStoreBase.HEAD_PREFIX, (byte[])key)) {
            return;
        }
        byte[] originalKey = HistorizingStoreBase.stripTimestampSuffix(key);
        if (!this.isIncludedKey(originalKey)) {
            return;
        }
        ByteArrayWrapper mapKey = new ByteArrayWrapper(originalKey);
        if (TimestampAwareKeyCollectorCallbackBase.isTimestampLessOrEqual(key, this.timestampSuffix)) {
            Map<ByteArrayWrapper, byte[]> map = this.keys;
            synchronized (map) {
                if (this.noBetterValueExists(key, mapKey)) {
                    this.keys.put(mapKey, key);
                }
            }
        }
    }

    private boolean noBetterValueExists(byte[] key, ByteArrayWrapper mapKey) {
        byte[] currentKey = this.keys.get(mapKey);
        return currentKey == null || TimestampAwareKeyCollectorCallbackBase.isTimestampLessOrEqual(currentKey, key);
    }

    private static boolean isTimestampLessOrEqual(byte[] key, byte[] otherKey) {
        for (int i = 8; i > 0; --i) {
            if (ByteArrayUtils.unsignedByte((byte)key[key.length - i]) > ByteArrayUtils.unsignedByte((byte)otherKey[otherKey.length - i])) {
                return false;
            }
            if (ByteArrayUtils.unsignedByte((byte)key[key.length - i]) >= ByteArrayUtils.unsignedByte((byte)otherKey[otherKey.length - i])) continue;
            return true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<byte[]> getRawKeys() {
        Map<ByteArrayWrapper, byte[]> map = this.keys;
        synchronized (map) {
            return new ArrayList<byte[]>(this.keys.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getRawKey(byte[] key) {
        ByteArrayWrapper wrapper = new ByteArrayWrapper(key);
        Map<ByteArrayWrapper, byte[]> map = this.keys;
        synchronized (map) {
            return this.keys.get(wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasResult(byte[] key) {
        ByteArrayWrapper wrapper = new ByteArrayWrapper(key);
        Map<ByteArrayWrapper, byte[]> map = this.keys;
        synchronized (map) {
            return this.keys.containsKey(wrapper);
        }
    }

    protected abstract boolean isIncludedKey(byte[] var1);
}

