/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.rocksdb;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.SingleStoreStorageSystemProviderBase;
import org.conqat.engine.persistence.store.base.StorageSystemBase;
import org.conqat.engine.persistence.store.capability.ISnapshotBackupCapability;
import org.conqat.engine.persistence.store.capability.IStorageSystemCapability;
import org.conqat.engine.persistence.store.rocksdb.RocksDBStore;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.filesystem.ByteUnit;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.rocksdb.AbstractSlice;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.Cache;
import org.rocksdb.CompactionOptionsUniversal;
import org.rocksdb.CompactionPriority;
import org.rocksdb.CompactionStyle;
import org.rocksdb.CompressionType;
import org.rocksdb.Filter;
import org.rocksdb.HistogramType;
import org.rocksdb.LRUCache;
import org.rocksdb.Options;
import org.rocksdb.PrepopulateBlobCache;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.Slice;
import org.rocksdb.Snapshot;
import org.rocksdb.Statistics;
import org.rocksdb.StatsLevel;
import org.rocksdb.TableFormatConfig;

public class RocksDBStorageSystemProvider
extends SingleStoreStorageSystemProviderBase
implements ISnapshotBackupCapability {
    private static final String MAX_OPEN_FILES_PROPERTY = "com.teamscale.storage.rocksdb.max-open-files";
    private static final int MAX_OPEN_FILES_NOT_SET = -42;
    private static final int MAX_OPEN_FILES = Integer.parseInt(System.getProperty("com.teamscale.storage.rocksdb.max-open-files", Integer.toString(-42)));
    private final Options options = new Options();
    private final Cache cache;
    private final RocksDB db;

    public RocksDBStorageSystemProvider(File dir, int cacheSizeMB, Map<String, String> detailSettings) throws StorageException {
        StorageSystemBase.ensureStorageDirectoryExists(dir);
        detailSettings = new HashMap<String, String>(detailSettings);
        BlockBasedTableConfig tableConfig = new BlockBasedTableConfig();
        this.applyRecommendedSettings(tableConfig, detailSettings);
        this.applyFurtherSettings(tableConfig, detailSettings);
        if (!detailSettings.isEmpty()) {
            throw new StorageException("Unknown/unsupported detail settings: " + StringUtils.concat(detailSettings.keySet(), (String)", "));
        }
        this.cache = new LRUCache(ByteUnit.MEBIBYTES.toBytes((long)cacheSizeMB));
        tableConfig.setBlockCache(this.cache);
        this.options.setTableFormatConfig((TableFormatConfig)tableConfig);
        try {
            this.db = RocksDB.open((Options)this.options, (String)dir.getAbsolutePath());
            this.db.enableFileDeletions(false);
        }
        catch (RocksDBException e) {
            throw new StorageException(e);
        }
        this.init(new RocksDBStore(this.db, this));
    }

    private void applyFurtherSettings(BlockBasedTableConfig tableConfig, Map<String, String> detailSettings) {
        this.options.setCreateIfMissing(true);
        if (MAX_OPEN_FILES != -42) {
            this.options.setMaxOpenFiles(MAX_OPEN_FILES);
        }
        RocksDBStorageSystemProvider.applyOptionalIntOption("max-open-files", arg_0 -> ((Options)this.options).setMaxOpenFiles(arg_0), detailSettings);
        tableConfig.setFilterPolicy((Filter)new BloomFilter(10.0, true));
        this.options.setCompactionStyle(CompactionStyle.LEVEL);
        RocksDBStorageSystemProvider.applyIntOption("write-buffer-size", (int)ByteUnit.MEBIBYTES.toBytes(256L), arg_0 -> ((Options)this.options).setWriteBufferSize(arg_0), detailSettings);
        RocksDBStorageSystemProvider.applyIntOption("max-num-write-buffer", 6, arg_0 -> ((Options)this.options).setMaxWriteBufferNumber(arg_0), detailSettings);
        RocksDBStorageSystemProvider.applyIntOption("target-file-size-base", (int)ByteUnit.MEBIBYTES.toBytes(32L), arg_0 -> ((Options)this.options).setTargetFileSizeBase(arg_0), detailSettings);
        RocksDBStorageSystemProvider.applyIntOption("level0-file-num-compaction-trigger", 8, arg_0 -> ((Options)this.options).setLevel0FileNumCompactionTrigger(arg_0), detailSettings);
        RocksDBStorageSystemProvider.applyIntOption("level0-slowdown-writes-trigger", 17, arg_0 -> ((Options)this.options).setLevel0SlowdownWritesTrigger(arg_0), detailSettings);
        RocksDBStorageSystemProvider.applyIntOption("level0-stop-writes-trigger", 24, arg_0 -> ((Options)this.options).setLevel0StopWritesTrigger(arg_0), detailSettings);
        RocksDBStorageSystemProvider.applyIntOption("num-levels", 4, arg_0 -> ((Options)this.options).setNumLevels(arg_0), detailSettings);
        RocksDBStorageSystemProvider.applyIntOption("max-bytes-for-level-base", (int)ByteUnit.MEBIBYTES.toBytes(512L), arg_0 -> ((Options)this.options).setMaxBytesForLevelBase(arg_0), detailSettings);
        RocksDBStorageSystemProvider.applyIntOption("max-bytes-for-level-multiplier", 8, arg_0 -> ((Options)this.options).setMaxBytesForLevelMultiplier(arg_0), detailSettings);
        RocksDBStorageSystemProvider.applyBooleanOption("prefix-table", true, value -> {
            if (value.booleanValue()) {
                this.options.useFixedLengthPrefixExtractor(8);
                this.options.setMemtablePrefixBloomSizeRatio(0.01);
            }
        }, detailSettings);
        RocksDBStorageSystemProvider.applyCompressionTypeOption("compression-type", CompressionType.NO_COMPRESSION, arg_0 -> ((Options)this.options).setCompressionType(arg_0), detailSettings);
        RocksDBStorageSystemProvider.applyCompressionTypeOption("set-bottommost-compression-type", CompressionType.ZSTD_COMPRESSION, arg_0 -> ((Options)this.options).setBottommostCompressionType(arg_0), detailSettings);
        this.applyBlobDbOptions(detailSettings);
    }

    private void applyBlobDbOptions(Map<String, String> detailSettings) {
        RocksDBStorageSystemProvider.applyBooleanOption("enable_blob_files", true, arg_0 -> ((Options)this.options).setEnableBlobFiles(arg_0), detailSettings);
        RocksDBStorageSystemProvider.applyBooleanOption("enable_blob_garbage_collection", true, arg_0 -> ((Options)this.options).setEnableBlobGarbageCollection(arg_0), detailSettings);
        RocksDBStorageSystemProvider.applyIntOption("min_blob_size", (int)ByteUnit.KIBIBYTES.toBytes(4L), arg_0 -> ((Options)this.options).setMinBlobSize(arg_0), detailSettings);
        RocksDBStorageSystemProvider.applyIntOption("blob_file_size", (int)ByteUnit.GIBIBYTES.toBytes(1L), arg_0 -> ((Options)this.options).setBlobFileSize(arg_0), detailSettings);
        RocksDBStorageSystemProvider.applyCompressionTypeOption("blob-compression-type", CompressionType.ZSTD_COMPRESSION, arg_0 -> ((Options)this.options).setBlobCompressionType(arg_0), detailSettings);
        RocksDBStorageSystemProvider.applyDoubleOption("blob_garbage_collection_age_cutoff", 0.5, arg_0 -> ((Options)this.options).setBlobGarbageCollectionAgeCutoff(arg_0), detailSettings);
        RocksDBStorageSystemProvider.applyDoubleOption("blob_garbage_collection_force_threshold", 0.2, arg_0 -> ((Options)this.options).setBlobGarbageCollectionForceThreshold(arg_0), detailSettings);
        this.options.setPrepopulateBlobCache(PrepopulateBlobCache.PREPOPULATE_BLOB_FLUSH_ONLY);
    }

    private void applyRecommendedSettings(BlockBasedTableConfig tableConfig, Map<String, String> detailSettings) {
        RocksDBStorageSystemProvider.applyOptionalIntOption("stats-dump-period-sec", arg_0 -> ((Options)this.options).setStatsDumpPeriodSec(arg_0), detailSettings);
        RocksDBStorageSystemProvider.applyBooleanOption("details-statistics", true, value -> {
            if (value.booleanValue()) {
                this.options.setStatistics(new Statistics(EnumSet.allOf(HistogramType.class)));
                this.options.statistics().setStatsLevel(StatsLevel.ALL);
            }
        }, detailSettings);
        this.applyCompactionSettings(detailSettings);
        RocksDBStorageSystemProvider.applyLongOption("block-size", ByteUnit.KIBIBYTES.toBytes(4L), arg_0 -> ((BlockBasedTableConfig)tableConfig).setBlockSize(arg_0), detailSettings);
        RocksDBStorageSystemProvider.applyBooleanOption("cache-index-and-filter-blocks", true, arg_0 -> ((BlockBasedTableConfig)tableConfig).setCacheIndexAndFilterBlocks(arg_0), detailSettings);
        RocksDBStorageSystemProvider.applyBooleanOption("pin-l0-filter-and-index-blocks-in-cache", true, arg_0 -> ((BlockBasedTableConfig)tableConfig).setPinL0FilterAndIndexBlocksInCache(arg_0), detailSettings);
        RocksDBStorageSystemProvider.applyLongOption("delayed-write-rate", ByteUnit.MEBIBYTES.toBytes(32L), arg_0 -> ((Options)this.options).setDelayedWriteRate(arg_0), detailSettings);
    }

    private void applyCompactionSettings(Map<String, String> detailSettings) {
        this.options.setCompactionOptionsUniversal(new CompactionOptionsUniversal());
        this.options.compactionOptionsUniversal().setMaxSizeAmplificationPercent(120);
        RocksDBStorageSystemProvider.applyBooleanOption("level-compaction-dynamic-bytes", false, arg_0 -> ((Options)this.options).setLevelCompactionDynamicLevelBytes(arg_0), detailSettings);
        RocksDBStorageSystemProvider.applyIntOption("max-background-compactions", 4, arg_0 -> ((Options)this.options).setMaxBackgroundCompactions(arg_0), detailSettings);
        RocksDBStorageSystemProvider.applyIntOption("max-background-flushes", 8, arg_0 -> ((Options)this.options).setMaxBackgroundFlushes(arg_0), detailSettings);
        RocksDBStorageSystemProvider.applyIntOption("bytes-per-sync", (int)ByteUnit.MEBIBYTES.toBytes(1L), arg_0 -> ((Options)this.options).setBytesPerSync(arg_0), detailSettings);
        RocksDBStorageSystemProvider.applyCompactionPriorityOption("compaction-priority", CompactionPriority.MinOverlappingRatio, arg_0 -> ((Options)this.options).setCompactionPriority(arg_0), detailSettings);
    }

    private static void applyBooleanOption(String key, boolean defaultValue, Consumer<Boolean> setter, Map<String, String> detailSettings) {
        RocksDBStorageSystemProvider.applyOptionWithDefault(key, defaultValue, setter, Boolean::valueOf, detailSettings);
    }

    private static void applyIntOption(String key, int defaultValue, Consumer<Integer> setter, Map<String, String> detailSettings) {
        RocksDBStorageSystemProvider.applyOptionWithDefault(key, defaultValue, setter, Integer::parseInt, detailSettings);
    }

    private static void applyOptionalIntOption(String key, Consumer<Integer> setter, Map<String, String> detailSettings) {
        RocksDBStorageSystemProvider.applyOptionWithDefault(key, null, setter, Integer::parseInt, detailSettings);
    }

    private static void applyLongOption(String key, long defaultValue, Consumer<Long> setter, Map<String, String> detailSettings) {
        RocksDBStorageSystemProvider.applyOptionWithDefault(key, defaultValue, setter, Long::parseLong, detailSettings);
    }

    private static void applyDoubleOption(String key, double defaultValue, Consumer<Double> setter, Map<String, String> detailSettings) {
        RocksDBStorageSystemProvider.applyOptionWithDefault(key, defaultValue, setter, Double::parseDouble, detailSettings);
    }

    private static void applyCompactionPriorityOption(String key, CompactionPriority defaultValue, Consumer<CompactionPriority> setter, Map<String, String> detailSettings) {
        RocksDBStorageSystemProvider.applyOptionWithDefault(key, defaultValue, setter, value -> (CompactionPriority)EnumUtils.valueOfIgnoreCase(CompactionPriority.class, (String)value), detailSettings);
    }

    private static void applyCompressionTypeOption(String key, CompressionType defaultValue, Consumer<CompressionType> setter, Map<String, String> detailSettings) {
        RocksDBStorageSystemProvider.applyOptionWithDefault(key, defaultValue, setter, value -> (CompressionType)EnumUtils.valueOfIgnoreCase(CompressionType.class, (String)value), detailSettings);
    }

    private static <T> void applyOptionWithDefault(String key, T defaultValue, Consumer<T> setter, Function<String, T> parser, Map<String, String> detailSettings) {
        String value = detailSettings.remove(key);
        if (value != null) {
            setter.accept(parser.apply(value));
        } else if (defaultValue != null) {
            setter.accept(defaultValue);
        }
    }

    @Override
    public void runFullCompaction() throws StorageException {
        try {
            this.db.compactRange();
        }
        catch (RocksDBException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public void close() {
        super.close();
        this.db.close();
        this.options.close();
        this.cache.close();
    }

    @Override
    public String getStorageInfo() throws StorageException {
        return super.getStorageInfo() + "\n\n" + String.valueOf(this.options.statistics());
    }

    @Override
    protected String getStorageSystemName() {
        return "RocksDB";
    }

    @Override
    public <T extends IStorageSystemCapability> Optional<T> getCapability(Class<T> capability) {
        if (capability == ISnapshotBackupCapability.class) {
            return Optional.of(this);
        }
        return super.getCapability(capability);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createSnapshotBackup(ISnapshotBackupCapability.ISnapshotConsumer snapshotConsumer) throws StorageException, IOException {
        Snapshot snapshot = this.db.getSnapshot();
        try {
            PairList<SingleStoreStorageSystemProviderBase.PartitionKey, Pair<String, String>> idToStorageSystemAndStoreName = this.loadMetaDataFromSnapshot(snapshot);
            for (int i = 0; i < idToStorageSystemAndStoreName.size(); ++i) {
                snapshotConsumer.startStore((String)((Pair)idToStorageSystemAndStoreName.getSecond(i)).getFirst(), (String)((Pair)idToStorageSystemAndStoreName.getSecond(i)).getSecond());
                this.scanAndWriteSingleStoreSnapshot((SingleStoreStorageSystemProviderBase.PartitionKey)idToStorageSystemAndStoreName.getFirst(i), snapshot, snapshotConsumer);
                snapshotConsumer.endStore();
            }
        }
        finally {
            this.db.releaseSnapshot(snapshot);
        }
    }

    private PairList<SingleStoreStorageSystemProviderBase.PartitionKey, Pair<String, String>> loadMetaDataFromSnapshot(Snapshot snapshot) {
        PairList idToStorageSystemAndStoreName = new PairList();
        try (ReadOptions options = new ReadOptions();
             Slice slice = new Slice(StorageUtils.generatePrefixEndKey(META_DATA_STORE_PREFIX));){
            options.setSnapshot(snapshot);
            options.setIterateUpperBound((AbstractSlice)slice);
            this.readMetaDataFromSnapshot((PairList<SingleStoreStorageSystemProviderBase.PartitionKey, Pair<String, String>>)idToStorageSystemAndStoreName, options);
        }
        return idToStorageSystemAndStoreName;
    }

    private void readMetaDataFromSnapshot(PairList<SingleStoreStorageSystemProviderBase.PartitionKey, Pair<String, String>> idToStorageSystemAndStoreName, ReadOptions options) {
        try (RocksIterator iterator = this.db.newIterator(options);){
            iterator.seek(META_DATA_STORE_PREFIX);
            while (iterator.isValid()) {
                byte[] key = iterator.key();
                if (!ByteArrayUtils.isPrefix((byte[])DELETION_ENTRY_PREFIX, (byte[])key)) {
                    SingleStoreStorageSystemProviderBase.PartitionKey partition = SingleStoreStorageSystemProviderBase.PartitionKey.deserialize(iterator.value());
                    idToStorageSystemAndStoreName.add((Object)partition, RocksDBStorageSystemProvider.getStorageSystemAndStoreFromMetaDataKey(key));
                }
                iterator.next();
            }
        }
    }

    private void scanAndWriteSingleStoreSnapshot(SingleStoreStorageSystemProviderBase.PartitionKey storePartition, Snapshot snapshot, ISnapshotBackupCapability.ISnapshotConsumer snapshotConsumer) throws StorageException, IOException {
        try (ReadOptions options = new ReadOptions();){
            options.setSnapshot(snapshot);
            byte[] prefix = storePartition.serialize();
            try (Slice slice = new Slice(StorageUtils.generatePrefixEndKey(prefix));){
                options.setIterateUpperBound((AbstractSlice)slice);
                try (RocksIterator iterator = this.db.newIterator(options);){
                    iterator.seek(prefix);
                    while (iterator.isValid()) {
                        byte[] key = iterator.key();
                        byte[] underlyingKey = Arrays.copyOfRange(key, prefix.length, key.length);
                        snapshotConsumer.writeKeyValue(underlyingKey, iterator.value());
                        iterator.next();
                    }
                }
            }
        }
    }
}

