/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.util;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.StoreBase;
import org.conqat.engine.persistence.store.capability.IStoreCapability;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class DelegatingPartitionStore
extends StoreBase {
    private static final String NAME_SEPARATOR = "$%$";
    private final IStore baseStore;
    private byte[] namePrefix;
    private String namePrefixString;

    public DelegatingPartitionStore(IStore baseStore) {
        this(baseStore, "");
    }

    public DelegatingPartitionStore(IStore baseStore, String name) {
        this(baseStore, DelegatingPartitionStore.buildStoragePathPrefix(name), name + NAME_SEPARATOR);
    }

    public static byte @NonNull [] buildStoragePathPrefix(String name) {
        return StringUtils.stringToBytes((String)(name + NAME_SEPARATOR));
    }

    public DelegatingPartitionStore(IStore baseStore, byte[] namePrefix, String namePrefixString) {
        this.baseStore = baseStore;
        this.namePrefixString = namePrefixString;
        this.namePrefix = namePrefix;
        CCSMAssert.isNotNull((Object)namePrefix, (String)"Cannot use a null namePrefix");
    }

    public void setPartition(String partitionName) {
        this.namePrefixString = partitionName + NAME_SEPARATOR;
        this.namePrefix = StringUtils.stringToBytes((String)this.namePrefixString);
        CCSMAssert.isNotNull((Object)this.namePrefix, (String)"Cannot use a null namePrefix");
    }

    @Override
    public byte[] get(byte @NonNull [] key) throws StorageException {
        return this.baseStore.get(this.extendKey(key, false));
    }

    @Override
    public List<byte[]> get(List<byte @NonNull []> keys) throws StorageException {
        return this.baseStore.get(this.extendKeys(keys));
    }

    @Override
    public void put(PairList<byte @NonNull [], byte @NonNull []> keysValues) throws StorageException {
        this.baseStore.put((PairList<byte[], byte[]>)keysValues.mapFirst(key -> this.extendKey((byte[])key, false)));
    }

    @Override
    public void put(byte @NonNull [] key, byte @NonNull [] value) throws StorageException {
        this.baseStore.put(this.extendKey(key, false), value);
    }

    @Override
    public void remove(byte @NonNull [] key) throws StorageException {
        this.baseStore.remove(this.extendKey(key, false));
    }

    @Override
    public void remove(List<byte @NonNull []> keys) throws StorageException {
        this.baseStore.remove(this.extendKeys(keys));
    }

    @Override
    public void removeByPrefix(byte @NonNull [] prefix) throws StorageException {
        this.baseStore.removeByPrefix(this.extendKey(prefix, false));
    }

    @Override
    public void scan(byte @NonNull [] beginKey, byte @Nullable [] endKey, IKeyValueCallback callback) throws StorageException {
        this.baseStore.scan(this.extendKey(beginKey, true), this.extendEndKey(endKey), new ForwardingCallbackWrapper(this, callback));
    }

    @Override
    public void scanKeys(byte @Nullable [] beginKey, byte @Nullable [] endKey, IKeyValueCallback callback) throws StorageException {
        this.baseStore.scanKeys(this.extendKey(beginKey, true), this.extendEndKey(endKey), new ForwardingCallbackWrapper(this, callback));
    }

    @Override
    public <T extends IStoreCapability> Optional<T> getCapability(Class<T> capability) {
        return this.baseStore.getCapability(capability);
    }

    @Override
    public void scan(List<byte @NonNull []> prefixes, IKeyValueCallback callback) throws StorageException {
        this.baseStore.scan(this.extendKeys(prefixes), (IKeyValueCallback)new ForwardingCallbackWrapper(this, callback));
    }

    @Override
    public void scanKeys(List<byte @NonNull []> prefixes, IKeyValueCallback callback) throws StorageException {
        this.baseStore.scanKeys(this.extendKeys(prefixes), (IKeyValueCallback)new ForwardingCallbackWrapper(this, callback));
    }

    @Override
    public void scan(List<byte @NonNull []> prefixes, List<? extends IKeyValueCallback> callbacks) throws StorageException {
        this.baseStore.scan(this.extendKeys(prefixes), CollectionUtils.map(callbacks, x$0 -> new ForwardingCallbackWrapper(this, (IKeyValueCallback)x$0)));
    }

    @Override
    public void scanKeys(List<byte @NonNull []> prefixes, List<? extends IKeyValueCallback> callbacks) throws StorageException {
        this.baseStore.scanKeys(this.extendKeys(prefixes), CollectionUtils.map(callbacks, x$0 -> new ForwardingCallbackWrapper(this, (IKeyValueCallback)x$0)));
    }

    private byte[] extendKey(byte[] key, boolean allowNullKeys) throws StorageException {
        if (key == null && allowNullKeys) {
            return this.namePrefix;
        }
        DelegatingPartitionStore.throwIfKeyIsNull(key);
        return ByteArrayUtils.concat((byte[][])new byte[][]{this.namePrefix, key});
    }

    private List<byte[]> extendKeys(List<byte[]> keys) throws StorageException {
        return CollectionUtils.mapWithException(keys, key -> this.extendKey((byte[])key, false));
    }

    private byte[] extendEndKey(byte[] endKey) throws StorageException {
        if (endKey != null) {
            endKey = this.extendKey(endKey, true);
        } else {
            CCSMAssert.isTrue((this.namePrefix.length > 0 ? 1 : 0) != 0, (String)"Non empty prefix expected");
            endKey = StorageUtils.generatePrefixEndKey(this.namePrefix);
        }
        return endKey;
    }

    public final byte[] getOriginalKey(byte[] extendedKey) {
        if (!this.isFromThisPartition(extendedKey)) {
            throw new IllegalArgumentException("The given key is not in this partition");
        }
        return Arrays.copyOfRange(extendedKey, this.namePrefix.length, extendedKey.length);
    }

    public final boolean isFromThisPartition(byte[] extendedKey) {
        return ByteArrayUtils.isPrefix((byte[])this.namePrefix, (byte[])extendedKey);
    }

    @Override
    public Lock obtainLock(String suffix) {
        return this.baseStore.obtainLock(this.namePrefixString + suffix);
    }

    public IStore getBaseStore() {
        return this.baseStore;
    }

    @ThreadSafe
    private final class ForwardingCallbackWrapper
    implements IKeyValueCallback {
        private final IKeyValueCallback callback;
        final /* synthetic */ DelegatingPartitionStore this$0;

        private ForwardingCallbackWrapper(DelegatingPartitionStore delegatingPartitionStore, IKeyValueCallback callback) {
            DelegatingPartitionStore delegatingPartitionStore2 = delegatingPartitionStore;
            Objects.requireNonNull(delegatingPartitionStore2);
            this.this$0 = delegatingPartitionStore2;
            this.callback = callback;
        }

        @Override
        public void callback(byte[] key, byte[] value) {
            this.callback.callback(this.this$0.getOriginalKey(key), value);
        }
    }
}

