/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class StorageSystemIdManager {
    private static final StorageSystemIdManager INSTANCE = new StorageSystemIdManager();
    private final AtomicInteger nextId = new AtomicInteger();
    private final Map<String, Integer> nameToId = new ConcurrentHashMap<String, Integer>();

    private StorageSystemIdManager() {
    }

    public static StorageSystemIdManager getInstance() {
        return INSTANCE;
    }

    public int getOrCreateId(String storageSystemName) {
        return this.nameToId.computeIfAbsent(storageSystemName, x -> this.nextId.incrementAndGet());
    }

    public void removeStorageSystem(String storageSystemName) {
        this.nameToId.remove(storageSystemName);
    }

    public void clear() {
        this.nameToId.clear();
    }
}

