/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.sourcecode.coverage.volume;

import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.Objects;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class CodeBranch {
    private ShallowEntity entity;
    private String decision;
    private int startLine;
    private int endLine;
    private CodeBranch counterBranch;
    private boolean branchNotPresent;

    public CodeBranch(ShallowEntity entity) {
        this(entity, null);
    }

    public CodeBranch(ShallowEntity entity, boolean conditional) {
        this(entity, Boolean.toString(conditional));
    }

    public CodeBranch(ShallowEntity entity, String decision) {
        CCSMAssert.isNotNull((Object)entity);
        this.entity = entity;
        this.decision = decision;
        this.startLine = entity.getStartLine();
        this.endLine = entity.getEndLine();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        UnmodifiableList includedTokens = this.entity.includedTokens();
        if (!includedTokens.isEmpty()) {
            builder.append(((IToken)includedTokens.get(0)).getOriginId() + ": ");
        }
        builder.append(this.entity.getSubtype());
        builder.append("(");
        builder.append(this.startLine);
        builder.append("-");
        builder.append(this.endLine);
        builder.append(")");
        if (this.decision != null) {
            builder.append(" - ");
            builder.append(this.decision);
        }
        return builder.toString();
    }

    public int getStartLine() {
        return this.startLine;
    }

    public void setStartLine(int startLine) {
        this.startLine = startLine;
    }

    public void setEndLine(int endLine) {
        this.endLine = endLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public CodeBranch getCounterBranch() {
        return this.counterBranch;
    }

    public void setCounterBranch(CodeBranch counterBranch) {
        this.counterBranch = counterBranch;
    }

    public boolean isBranchNotPresent() {
        return this.branchNotPresent;
    }

    public void markBranchAsNotPresent() {
        this.branchNotPresent = true;
    }

    public ShallowEntity getEntity() {
        return this.entity;
    }

    public String getDecision() {
        return this.decision;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodeBranch that = (CodeBranch)o;
        return this.startLine == that.startLine && this.endLine == that.endLine && this.branchNotPresent == that.branchNotPresent && Objects.equals(this.entity, that.entity) && Objects.equals(this.decision, that.decision) && Objects.equals(this.counterBranch, that.counterBranch);
    }

    public int hashCode() {
        return Objects.hash(this.entity, this.decision, this.startLine, this.endLine, this.counterBranch, this.branchNotPresent);
    }
}

