/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.base;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.java.StaticMethodCallRecognizer;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.markup.MarkupUtils;

public abstract class UnwantedMethodCallsCheckBase
extends CheckImplementationBase {
    private final Logger logger = LogManager.getLogger(this.getClass());

    protected abstract Set<String> getUnwantedMethods();

    protected boolean shouldIgnoreMethod(List<IToken> tokens, int callIndex, String methodName) {
        return false;
    }

    @Override
    public void execute() throws CheckException {
        if (this.getUnwantedMethods().isEmpty() || this.getUnwantedMethods().size() == 1 && this.getUnwantedMethods().contains("")) {
            this.logger.info("An option needs to be configured for {} to produce findings", (Object)this.getClass().getSimpleName());
            return;
        }
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType(this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            this.processTokens((List<IToken>)statement.ownStartTokens());
            this.processTokens((List<IToken>)statement.ownEndTokens());
        }
    }

    protected void processTokens(List<IToken> tokens) throws CheckException {
        for (String unwantedMethod : this.getUnwantedMethods()) {
            this.createFindingForIndices(new StaticMethodCallRecognizer(unwantedMethod), tokens);
        }
    }

    private void createFindingForIndices(StaticMethodCallRecognizer recognizer, List<IToken> tokens) {
        for (int callIndex : recognizer.findCallsInTokens(tokens)) {
            if (this.shouldIgnoreMethod(tokens, callIndex, recognizer.getFullQualifiedMethodName())) continue;
            this.buildFinding("Method " + MarkupUtils.formatAsSourceCode((String)recognizer.getFullQualifiedMethodName()) + " should not be called", this.buildLocation().betweenTokens(tokens.get(callIndex), tokens.get(callIndex + recognizer.getTokenLength()))).createAndStore();
        }
    }
}

