/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.core;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.CheckInfo;
import eu.cqse.check.framework.core.ICheckContext;
import eu.cqse.check.framework.core.option.ICheckOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.reflect.ReflectionUtils;

public class CheckInstance {
    private final CheckImplementationBase checkImplementation;
    private final CheckInfo checkInfo;

    public CheckInstance(CheckInfo checkInfo) throws CheckException {
        CCSMAssert.isNotNull((Object)checkInfo);
        this.checkInfo = checkInfo;
        this.checkImplementation = checkInfo.instantiateCheckImplementation();
    }

    public void initialize() throws CheckException {
        this.checkImplementation.initialize();
    }

    public void execute() throws CheckException {
        this.checkImplementation.execute();
    }

    public CheckImplementationBase getCheckImplementation() {
        return this.checkImplementation;
    }

    public CheckInfo getCheckInfo() {
        return this.checkInfo;
    }

    public void initializeAndSetContext(ICheckContext context) throws CheckException {
        CCSMAssert.isNotNull((Object)context);
        this.checkImplementation.setContext(null);
        this.initialize();
        this.checkImplementation.setContext(context);
    }

    public <T> void setOption(String name, T value) {
        ICheckOption option = (ICheckOption)this.checkInfo.getOptions().get((Object)name);
        if (option != null) {
            CCSMAssert.isTrue((boolean)ReflectionUtils.isAssignable(value.getClass(), option.getType()), (String)"The given value must have the same type as the option to set.");
            ICheckOption castedOption = option;
            castedOption.setOption(this.checkImplementation, value);
        }
    }
}

