/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.core.option;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.core.option.EToolCheckOptionType;
import eu.cqse.check.framework.core.option.ToolCheckOption;
import eu.cqse.check.framework.core.registry.CheckMapping;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class CheckMappingAndCheckOptionTSVUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final char ENABLEMENT_FEATURE_TOGGLE_SEPARATOR = '?';
    private static final char ENABLEMENT_AUTO_SEPARATOR = '!';

    public static void writeCheckOptionsToFile(Path path, List<ToolCheckOption> options) throws IOException {
        ArrayList<String> sortedTSTEntries = new ArrayList<String>();
        sortedTSTEntries.add("Check ID\tOption ID\tReadable Name\tDescription\tType\tDefault Value");
        sortedTSTEntries.addAll(options.stream().sorted(ToolCheckOption::compareTo).map(CheckMappingAndCheckOptionTSVUtils::buildCheckOptionTSVEntry).toList());
        FileSystemUtils.writeLines((Path)path, sortedTSTEntries, (Charset)StandardCharsets.UTF_8);
    }

    private static String buildCheckOptionTSVEntry(ToolCheckOption option) {
        String defaultValue = "";
        if (option.getDefaultValue() != null) {
            defaultValue = option.getDefaultValue();
        }
        return option.checkId + "\t" + option.optionId + "\t" + option.getReadableName() + "\t" + option.getDescription() + "\t" + String.valueOf((Object)option.type) + "\t" + defaultValue;
    }

    public static Set<ToolCheckOption> readCheckOptionsFromTsv(Resource resource) {
        TreeSet<ToolCheckOption> checkOptions = new TreeSet<ToolCheckOption>();
        List lines = resource.getLines();
        CCSMAssert.isTrue((lines.isEmpty() || ((String)lines.getFirst()).equals("Check ID\tOption ID\tReadable Name\tDescription\tType\tDefault Value") ? 1 : 0) != 0, (String)"TSV file header of check mappings file is not as expected");
        lines.removeFirst();
        for (String line : lines) {
            if (StringUtils.isEmpty((String)line)) continue;
            ToolCheckOption toolCheckOption = CheckMappingAndCheckOptionTSVUtils.buildCheckOptionFromLine(resource, line);
            checkOptions.add(toolCheckOption);
        }
        return checkOptions;
    }

    public static @NonNull Multimap<String, ToolCheckOption> readCheckOptionsFromTsvByFullID(Resource resource) throws IllegalArgumentException {
        Set<ToolCheckOption> options = CheckMappingAndCheckOptionTSVUtils.readCheckOptionsFromTsv(resource);
        return Multimaps.index(options, o -> o.checkId);
    }

    private static @NonNull ToolCheckOption buildCheckOptionFromLine(Resource resource, String line) throws IllegalArgumentException {
        String[] parts = line.split("\t");
        CCSMAssert.isTrue((parts.length == 5 || parts.length == 6 ? 1 : 0) != 0, () -> "Line starting with \"" + Arrays.stream(parts).findFirst().orElse("") + "\" in " + resource.getPath() + " is not formatted correctly.\nIt must have 5 or 6 elements separated by tabs: Check ID\tOption ID\tReadable Name\tDescription\tType\tDefault Value\nDefault Value can be empty.");
        String checkId = parts[0].strip();
        CCSMAssert.isNotEmpty((String)checkId, (String)"Check ID must not be empty");
        String optionId = parts[1].strip();
        CCSMAssert.isNotEmpty((String)optionId, (String)"Option ID must not be empty");
        String readableName = parts[2].strip();
        String description = parts[3].strip();
        EToolCheckOptionType type = (EToolCheckOptionType)EnumUtils.valueOfIgnoreCase(EToolCheckOptionType.class, (String)parts[4].strip());
        CCSMAssert.isNotNull((Object)((Object)type), (String)(resource.getPath() + " contains an unsupported option type " + parts[4].strip() + "."));
        String defaultValue = null;
        if (parts.length == 6) {
            defaultValue = parts[5].strip();
            if (type == EToolCheckOptionType.MULTILINE_STRING) {
                defaultValue = StringUtils.unescapeChars((String)defaultValue, (Map)StringUtils.ESCAPE_NEWLINE);
            }
        }
        return new ToolCheckOption(checkId, optionId, readableName, description, type, defaultValue);
    }

    public static void writeCheckMappingsToFile(Path path, Collection<CheckMapping> mappings) throws IOException {
        ArrayList<String> sortedTSVEntries = new ArrayList<String>();
        sortedTSVEntries.add("ID in Tool\tReadable Name\tCategory\tGroup\tDefault Enablement\tComments\tUpstream URL");
        Comparator<CheckMapping> mappingComparator = Comparator.comparing(c -> c.checkId);
        sortedTSVEntries.addAll(mappings.stream().sorted(mappingComparator).map(CheckMappingAndCheckOptionTSVUtils::buildCheckMappingTSVEntry).toList());
        if (!((String)sortedTSVEntries.getLast()).isEmpty()) {
            sortedTSVEntries.add("");
        }
        FileSystemUtils.writeLines((Path)path, sortedTSVEntries, (Charset)StandardCharsets.UTF_8);
    }

    private static String buildCheckMappingTSVEntry(CheckMapping mapping) {
        boolean hasUpstreamURL;
        Object defaultEnablement = "IGNORED";
        if (mapping.defaultEnablement != null) {
            defaultEnablement = String.valueOf((Object)mapping.defaultEnablement);
            if (mapping.autoAllowed) {
                defaultEnablement = (String)defaultEnablement + "!" + EFindingEnablement.AUTO.name();
            }
        }
        StringJoiner joiner = new StringJoiner("\t");
        joiner.add(mapping.checkId).add(mapping.getReadableCheckName()).add(mapping.category).add(mapping.group).add((CharSequence)defaultEnablement);
        boolean hasComments = !StringUtils.isEmpty((String)mapping.comments);
        boolean bl = hasUpstreamURL = !StringUtils.isEmpty((String)mapping.upstreamURL);
        if (hasComments || hasUpstreamURL) {
            joiner.add(hasComments ? mapping.comments : "");
            if (hasUpstreamURL) {
                joiner.add(mapping.upstreamURL);
            }
        }
        return joiner.toString();
    }

    public static Map<String, CheckMapping> readCheckMappingsFromTsv(Resource resource) {
        return CheckMappingAndCheckOptionTSVUtils.readCheckMappingsFromTsv(resource.getPath(), resource.getLines(), false, false);
    }

    public static Map<String, CheckMapping> readCheckMappingsFromTsv(Resource resource, boolean includeComments, boolean includeUpstreamUrl) {
        return CheckMappingAndCheckOptionTSVUtils.readCheckMappingsFromTsv(resource.getPath(), resource.getLines(), includeComments, includeUpstreamUrl);
    }

    public static Map<String, CheckMapping> readCheckMappingsFromTsv(Path path) throws IOException {
        return CheckMappingAndCheckOptionTSVUtils.readCheckMappingsFromTsv(path, false, false);
    }

    public static Map<String, CheckMapping> readCheckMappingsFromTsv(Path path, boolean includeComments, boolean includeUpstreamUrl) throws IOException {
        return CheckMappingAndCheckOptionTSVUtils.readCheckMappingsFromTsv(path.toString(), FileSystemUtils.readLinesUTF8((Path)path), includeComments, includeUpstreamUrl);
    }

    public static Map<String, CheckMapping> readCheckMappingsFromTsv(String path, List<String> lines, boolean includeComments, boolean includeUpstreamUrl) {
        HashMap<String, CheckMapping> configuredChecks = new HashMap<String, CheckMapping>();
        HashMap<String, String> groupToCategory = new HashMap<String, String>();
        CCSMAssert.isTrue((lines.isEmpty() || lines.getFirst().equals("ID in Tool\tReadable Name\tCategory\tGroup\tDefault Enablement") || lines.getFirst().equals("ID in Tool\tReadable Name\tCategory\tGroup\tDefault Enablement\tComments\tUpstream URL") ? 1 : 0) != 0, (String)"TSV file header of check mappings file is not as expected");
        lines.removeFirst();
        for (String line : lines) {
            if (StringUtils.isEmpty((String)line)) continue;
            CheckMapping checkMapping = CheckMappingAndCheckOptionTSVUtils.buildCheckMappingFromLine(path, line, includeComments, includeUpstreamUrl);
            configuredChecks.put(checkMapping.checkId, checkMapping);
            CheckMappingAndCheckOptionTSVUtils.validateGroupToCategoryMapping(checkMapping.group, checkMapping.category, groupToCategory);
            groupToCategory.put(checkMapping.group, checkMapping.category);
        }
        return configuredChecks;
    }

    private static @NonNull CheckMapping buildCheckMappingFromLine(String path, String line, boolean includeComments, boolean includeUpstreamUrl) {
        String[] parts = line.split("\t");
        CCSMAssert.isTrue((parts.length >= 5 && parts.length <= 7 ? 1 : 0) != 0, () -> "Line starting with \"" + Arrays.stream(parts).findFirst().orElse("") + "\" in " + path + " is not formatted correctly.\nIt must have 5 or 7 elements separated by tabs: ID in Tool\tReadable Name\tCategory\tGroup\tDefault Enablement\nReadable name can be empty if the Id in tool is readable.");
        String checkId = parts[0].strip();
        String readableName = parts[1].strip();
        if (StringUtils.isEmpty((String)readableName)) {
            readableName = checkId;
        }
        String category = parts[2].strip();
        String group = parts[3].strip();
        EFindingEnablement enablement = CheckMappingAndCheckOptionTSVUtils.parseEnablement(parts[4].strip());
        boolean autoSupport = CheckMappingAndCheckOptionTSVUtils.parseAutoSupportFromEnablement(parts[4].strip());
        String comment = "";
        String upstreamURL = "";
        if (includeComments && parts.length >= 6) {
            comment = parts[5].strip();
        }
        if (includeUpstreamUrl && parts.length == 7) {
            upstreamURL = parts[6].strip();
        }
        return new CheckMapping(checkId, readableName, category, group, enablement, comment, upstreamURL, autoSupport);
    }

    private static @Nullable EFindingEnablement parseEnablement(String enablementString) {
        if (enablementString.indexOf(63) != -1) {
            Pair enablementFeatureToggle = StringUtils.splitAtLast((String)enablementString, (char)'?');
            String toggleId = (String)enablementFeatureToggle.getSecond();
            boolean featureEnabled = EFeatureToggle.findById((String)toggleId).map(EFeatureToggle::isEnabled).orElseGet(() -> Boolean.getBoolean(toggleId));
            if (!featureEnabled) {
                return null;
            }
            enablementString = (String)enablementFeatureToggle.getFirst();
        }
        if ("IGNORED".equals(enablementString = (String)StringUtils.splitAtLast((String)enablementString, (char)'!').getFirst())) {
            return null;
        }
        return (EFindingEnablement)EnumUtils.valueOf(EFindingEnablement.class, (String)enablementString);
    }

    private static boolean parseAutoSupportFromEnablement(String enablementString) {
        if (enablementString.indexOf(33) != -1) {
            Pair enablementAutoSupport = StringUtils.splitAtLast((String)enablementString, (char)'!');
            return EFindingEnablement.AUTO.name().equals(enablementAutoSupport.getSecond());
        }
        return false;
    }

    public static void validateGroupToCategoryMapping(String group, String category, Map<String, String> groupToCategory) {
        CCSMAssert.isTrue((!groupToCategory.containsKey(group) || groupToCategory.get(group).equals(category) ? 1 : 0) != 0, (String)("Contradicting group to category assignment for group " + group + ": " + category + " vs. " + groupToCategory.get(group)));
    }

    public static void updateCheckMapping(Map<String, CheckMapping> oldCheckMappings, Map<String, CheckMapping> newCheckMappings) {
        Map<String, CheckMapping> deletedChecks = CheckMappingAndCheckOptionTSVUtils.determineRemovedChecks(oldCheckMappings, newCheckMappings);
        oldCheckMappings.keySet().removeAll(deletedChecks.keySet());
        Map<String, CheckMapping> renamedChecks = CheckMappingAndCheckOptionTSVUtils.determineRenamedChecks(oldCheckMappings, newCheckMappings);
        oldCheckMappings.putAll(renamedChecks);
        Map<String, CheckMapping> missingCheckMappings = CheckMappingAndCheckOptionTSVUtils.determineUncategorizedChecks(oldCheckMappings, newCheckMappings);
        oldCheckMappings.putAll(missingCheckMappings);
    }

    private static Map<String, CheckMapping> determineUncategorizedChecks(Map<String, CheckMapping> oldCheckMappings, Map<String, CheckMapping> newCheckMappings) {
        TreeMap<String, CheckMapping> uncategorizedChecks = new TreeMap<String, CheckMapping>();
        for (CheckMapping check : newCheckMappings.values()) {
            CheckMapping mapping = oldCheckMappings.get(check.checkId);
            if (mapping != null) continue;
            CheckMapping newMapping = new CheckMapping(check.checkId, check.getReadableCheckName(), "TODO", "TODO", null);
            uncategorizedChecks.put(check.checkId, newMapping);
        }
        return uncategorizedChecks;
    }

    private static Map<String, CheckMapping> determineRemovedChecks(Map<String, CheckMapping> oldCheckMappings, Map<String, CheckMapping> newCheckMappings) {
        TreeMap<String, CheckMapping> removedChecks = new TreeMap<String, CheckMapping>();
        for (Map.Entry<String, CheckMapping> oldCheckMappingEntry : oldCheckMappings.entrySet()) {
            String checkId = oldCheckMappingEntry.getKey();
            if (newCheckMappings.get(checkId) != null) continue;
            removedChecks.put(checkId, oldCheckMappingEntry.getValue());
            LOGGER.warn("Check {} is no longer supported. Please verify this manually and write a migration.", (Object)checkId);
        }
        return removedChecks;
    }

    private static Map<String, CheckMapping> determineRenamedChecks(Map<String, CheckMapping> oldCheckMappings, Map<String, CheckMapping> newCheckMappings) {
        TreeMap<String, CheckMapping> renamedChecks = new TreeMap<String, CheckMapping>();
        for (CheckMapping newCheck : newCheckMappings.values()) {
            if (oldCheckMappings.get(newCheck.checkId) == null) continue;
            CheckMapping oldMapping = oldCheckMappings.get(newCheck.checkId);
            String newName = newCheck.getReadableCheckName();
            if (oldMapping.getReadableCheckName().equals(newName)) continue;
            CheckMapping renamedCheck = new CheckMapping(newCheck.checkId, newName, oldMapping.category, oldMapping.group, oldMapping.defaultEnablement, oldMapping.comments, oldMapping.upstreamURL, oldMapping.autoAllowed);
            renamedChecks.put(newCheck.checkId, renamedCheck);
        }
        return renamedChecks;
    }

    private CheckMappingAndCheckOptionTSVUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

