/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.core.option;

import com.fasterxml.jackson.databind.JsonNode;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import org.conqat.lib.commons.assertion.CCSMAssert;

public enum EToolCheckOptionType {
    BOOLEAN(Boolean.class),
    STRING_LIST(List.class),
    STRING(String.class),
    INTEGER(Integer.class),
    MULTILINE_STRING(String.class),
    JSON(JsonNode.class),
    DOUBLE_LIST(List.class);

    private final String typeName;

    private EToolCheckOptionType(Class<?> clazz) {
        this.typeName = clazz.getSimpleName();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public static EToolCheckOptionType fromType(Object value) {
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, Integer.class, String.class, JsonNode.class, List.class}, (Object)object2, n)) {
            case 0 -> {
                Boolean ignored = (Boolean)object2;
                yield BOOLEAN;
            }
            case 1 -> {
                Integer ignored = (Integer)object2;
                yield INTEGER;
            }
            case 2 -> {
                String ignored = (String)object2;
                yield STRING;
            }
            case 3 -> {
                JsonNode ignored = (JsonNode)object2;
                yield JSON;
            }
            case 4 -> {
                List list = (List)object2;
                yield EToolCheckOptionType.fromList(list);
            }
            default -> (EToolCheckOptionType)((Object)CCSMAssert.fail((String)("Unsupported type " + value.getClass().getSimpleName())));
        };
    }

    private static EToolCheckOptionType fromList(List<?> listValue) {
        return listValue.stream().filter(Objects::nonNull).findFirst().map(element -> {
            if (element instanceof Double) {
                return DOUBLE_LIST;
            }
            return STRING_LIST;
        }).orElse(STRING_LIST);
    }
}

