/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.core.xpath.functions;

import eu.cqse.check.framework.core.xpath.functions.FunctionBase;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jaxen.FunctionCallException;

public class NameMatchesFunction
extends FunctionBase<Pattern> {
    public static final String NAME = "name-matches";

    @Override
    protected Pattern parseArguments(List<?> args) throws FunctionCallException {
        if (args.size() != 1) {
            throw new FunctionCallException("name-matches(<regex>) expects exactly one argument.");
        }
        String regex = args.get(0).toString();
        try {
            return Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new FunctionCallException("'" + regex + "' is not a valid regular expression.");
        }
    }

    @Override
    protected boolean checkNode(ShallowEntity node, Pattern arguments) {
        return node.getName() != null && arguments.matcher(node.getName()).matches();
    }
}

