/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.postprocessor.cobol;

import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.tokens.TokenUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class SectionParagraphToMethodProcessor {
    private final List<IToken> tokens;

    public SectionParagraphToMethodProcessor(List<IToken> tokens) {
        this.tokens = CollectionUtils.filter(tokens, token -> !TokenUtils.isCommentToken(token));
    }

    public List<ShallowEntity> postProcess(List<ShallowEntity> entities) {
        ArrayList<ShallowEntity> result = new ArrayList<ShallowEntity>();
        EnumSet<EShallowEntityType> cobolProgramTypes = EnumSet.of(EShallowEntityType.MODULE, EShallowEntityType.TYPE);
        for (ShallowEntity entity : entities) {
            ShallowEntity child = cobolProgramTypes.contains(entity.getType()) ? this.processProgramTypeAndChildren(entity) : SectionParagraphToMethodProcessor.createCopy(entity, this.tokens);
            child.setComplete();
            result.add(child);
        }
        this.fixEndTokenIndex(result);
        return result;
    }

    private void fixEndTokenIndex(List<ShallowEntity> entities) {
        for (ShallowEntity entity : entities) {
            if (!entity.hasChildren()) continue;
            UnmodifiableList children = entity.getChildren();
            this.fixEndTokenIndex((List<ShallowEntity>)children);
            entity.setEndTokenIndex(Math.max(entity.getEndTokenIndex(), ((ShallowEntity)CollectionUtils.getLast((List)children)).getEndTokenIndex()));
        }
    }

    private ShallowEntity processProgramTypeAndChildren(ShallowEntity programTypeEntity) {
        UnmodifiableList children = programTypeEntity.getChildren();
        List<Integer> indices = SectionParagraphToMethodProcessor.getIndicesForEntitiesToBecomeMethods((List<ShallowEntity>)children, "section");
        if (!indices.isEmpty()) {
            return this.makeSectionsParagraphsIntoMethods(programTypeEntity, indices);
        }
        indices = SectionParagraphToMethodProcessor.getIndicesForEntitiesToBecomeMethods((List<ShallowEntity>)children, "paragraph");
        if (!indices.isEmpty()) {
            return this.makeSectionsParagraphsIntoMethods(programTypeEntity, indices);
        }
        return this.makeProgramTypeIntoMethod(programTypeEntity);
    }

    private static List<Integer> getIndicesForEntitiesToBecomeMethods(List<ShallowEntity> entities, String subType) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < entities.size(); ++i) {
            if (!SectionParagraphToMethodProcessor.isStatementWithSubTypeAs(entities.get(i), subType)) continue;
            indices.add(i);
        }
        return indices;
    }

    private ShallowEntity makeSectionsParagraphsIntoMethods(ShallowEntity programTypeEntity, List<Integer> indices) {
        UnmodifiableList children = programTypeEntity.getChildren();
        int entityToBecomeMethodIndex = 0;
        int firstChildIndex = 0;
        int lastChildIndex = indices.get(0) - 1;
        ShallowEntity newModuleOrTypeEntity = this.transformProgramType(programTypeEntity, (List<ShallowEntity>)children, firstChildIndex, lastChildIndex);
        while (entityToBecomeMethodIndex <= indices.size() - 1) {
            int index = indices.get(entityToBecomeMethodIndex);
            ShallowEntity entityToBecomeMethod = (ShallowEntity)children.get(index);
            firstChildIndex = index + 1;
            lastChildIndex = ++entityToBecomeMethodIndex == indices.size() ? children.size() - 1 : indices.get(entityToBecomeMethodIndex) - 1;
            ShallowEntity transformedEntity = this.transformEntityAndAddChildren(entityToBecomeMethod, (List<ShallowEntity>)children, firstChildIndex, lastChildIndex, true);
            transformedEntity.setComplete();
            newModuleOrTypeEntity.addChild(transformedEntity);
        }
        newModuleOrTypeEntity.setComplete();
        return newModuleOrTypeEntity;
    }

    private ShallowEntity makeProgramTypeIntoMethod(ShallowEntity programTypeEntity) {
        ShallowEntity changedProgramTypeEntity = SectionParagraphToMethodProcessor.createCopy(programTypeEntity, this.tokens);
        if (programTypeEntity.getType() != EShallowEntityType.METHOD) {
            changedProgramTypeEntity = SectionParagraphToMethodProcessor.changeToMethodEntity(programTypeEntity, this.tokens);
        }
        for (ShallowEntity entity : programTypeEntity.getChildren()) {
            changedProgramTypeEntity.addChild(this.transformChild(entity));
        }
        return changedProgramTypeEntity;
    }

    private ShallowEntity transformChild(ShallowEntity parent) {
        ShallowEntity newParent = SectionParagraphToMethodProcessor.createCopy(parent, this.tokens);
        newParent.setComplete();
        parent.getChildren().forEach(child -> newParent.addChild(this.transformChild((ShallowEntity)child)));
        return newParent;
    }

    private ShallowEntity transformProgramType(ShallowEntity parent, List<ShallowEntity> programTypeChildren, int firstChildIndex, int lastChildIndex) {
        int i;
        ShallowEntity newParent = SectionParagraphToMethodProcessor.createCopy(parent, this.tokens);
        for (i = firstChildIndex; i <= lastChildIndex; ++i) {
            ShallowEntity entity = programTypeChildren.get(i);
            newParent.addChild(this.transformChild(entity));
            if (SectionParagraphToMethodProcessor.isProcedureDivisionEntity(entity)) break;
        }
        if (i == lastChildIndex) {
            return newParent;
        }
        ShallowEntity result = new ShallowEntity(EShallowEntityType.METHOD, "anonymous method", "#artificial#", this.tokens, programTypeChildren.get(++i).getStartTokenIndex());
        result.setEndTokenIndex(programTypeChildren.get(lastChildIndex).getEndTokenIndex());
        ShallowEntity artificialMethod = result;
        while (i <= lastChildIndex) {
            artificialMethod.addChild(this.transformChild(programTypeChildren.get(i)));
            ++i;
        }
        artificialMethod.setComplete();
        newParent.addChild(artificialMethod);
        return newParent;
    }

    private static boolean isProcedureDivisionEntity(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.META && entity.getSubtype().equals("division") && "procedure".equals(entity.getName());
    }

    private ShallowEntity transformEntityAndAddChildren(ShallowEntity parent, List<ShallowEntity> programTypeChildren, int firstChildIndex, int lastChildIndex, boolean transformParentToMethod) {
        ShallowEntity newParent = SectionParagraphToMethodProcessor.createCopy(parent, this.tokens);
        if (transformParentToMethod) {
            newParent = SectionParagraphToMethodProcessor.changeToMethodEntity(parent, this.tokens);
        }
        for (int i = firstChildIndex; i <= lastChildIndex; ++i) {
            newParent.addChild(this.transformChild(programTypeChildren.get(i)));
        }
        if (transformParentToMethod) {
            newParent.setComplete();
        }
        return newParent;
    }

    private static ShallowEntity createCopy(ShallowEntity entity, List<IToken> tokens) {
        ShallowEntity result = new ShallowEntity(entity.getType(), entity.getSubtype(), entity.getName(), tokens, entity.getStartTokenIndex());
        result.setEndTokenIndex(entity.getEndTokenIndex());
        return result;
    }

    private static ShallowEntity changeToMethodEntity(ShallowEntity entity, List<IToken> tokens) {
        ShallowEntity result = new ShallowEntity(EShallowEntityType.METHOD, entity.getSubtype(), entity.getName(), tokens, entity.getStartTokenIndex());
        result.setEndTokenIndex(entity.getEndTokenIndex());
        return result;
    }

    private static boolean isStatementWithSubTypeAs(ShallowEntity entity, String subType) {
        return entity.getSubtype() != null && entity.getSubtype().equals(subType) && entity.getType() == EShallowEntityType.STATEMENT;
    }
}

