/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor;

import com.google.common.primitives.Ints;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.PreprocessedTokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class PreprocessorUtils {
    public static final String PREPROCESSED_TOKENS_LIMIT_VM_OPTION_NAME = "TEAMSCALE_PREPROCESSED_TOKENS_PER_FILE_LIMIT";

    public static boolean hasPreprocessor(ELanguage language) {
        return ELanguage.LANGUAGES_WITH_PREPROCESSOR.contains(language);
    }

    private static int getPreprocessedTokensPerFileLimit() {
        Integer tokensLimit = Ints.tryParse((String)System.getProperty(PREPROCESSED_TOKENS_LIMIT_VM_OPTION_NAME, "10000000"));
        CCSMAssert.isNotNull((Object)tokensLimit, () -> "The VM Option TEAMSCALE_PREPROCESSED_TOKENS_PER_FILE_LIMIT can't be parsed. Value: " + System.getenv().getOrDefault(PREPROCESSED_TOKENS_LIMIT_VM_OPTION_NAME, "none"));
        CCSMAssert.isTrue((tokensLimit >= 0 ? 1 : 0) != 0, () -> "The VM Option TEAMSCALE_PREPROCESSED_TOKENS_PER_FILE_LIMIT must be a positive, non-zero integer. It is " + tokensLimit);
        return tokensLimit;
    }

    public static boolean clearIfTokenNumberLimitExceeded(List<IToken> preprocessedTokens, String uniformPath) {
        int tokensLimit = PreprocessorUtils.getPreprocessedTokensPerFileLimit();
        if (preprocessedTokens.size() > tokensLimit) {
            preprocessedTokens.clear();
            LogManager.getLogger().warn("Preprocessing generated " + preprocessedTokens.size() + " tokens in " + uniformPath + ". The limit is configured at " + tokensLimit + ". Ignoring content in this file.");
            return true;
        }
        return false;
    }

    public static boolean isEntityMacroExpanded(ShallowEntity entity) {
        IToken startToken = (IToken)entity.getAllTokensOfFile().get(entity.getStartTokenIndex());
        return PreprocessedTokenStreamUtils.isTokenMacroExpanded(startToken);
    }

    private PreprocessorUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

