/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor.c;

import eu.cqse.check.framework.preprocessor.c.CPreprocessingUtils;
import eu.cqse.check.framework.preprocessor.c.CPreprocessor;
import eu.cqse.check.framework.preprocessor.c.IncludeDirectiveMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class IncludeDirective {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IncludeDirectiveType type;
    private final @NonNull String includedFilePath;
    private final boolean usesQuotes;
    private final boolean ignoreIncludeNext;

    public static Optional<IncludeDirective> createFromToken(IToken token) {
        return IncludeDirective.createIncludeDirectiveFromIncludeDirectiveMatcher(new IncludeDirectiveMatcher(token), token, true);
    }

    public static Optional<IncludeDirective> createIncludeDirectiveFromIncludeDirectiveMatcher(IncludeDirectiveMatcher matcher, IToken token, boolean logWarningOnParsingFailure) {
        if (!matcher.match()) {
            return Optional.empty();
        }
        IncludeDirectiveType includeDirectiveType = IncludeDirective.parseIncludeType(matcher.getIncludeDirectiveType()).orElse(null);
        if (includeDirectiveType == null) {
            return Optional.empty();
        }
        String includedFilePath = IncludeDirective.cleanupIncludeDirectiveFilePath(matcher.getIncludedFileExpression());
        if (includedFilePath == null) {
            if (logWarningOnParsingFailure) {
                LOGGER.warn("Could not process include directive `{}` in {}:{}. Ignoring this include.", (Object)token.getText(), (Object)token.getOriginId(), (Object)token.getLineNumber());
            }
            return Optional.empty();
        }
        boolean usesQuotes = matcher.getIncludedFileExpression().contains("\"");
        return Optional.of(new IncludeDirective(includeDirectiveType, includedFilePath, usesQuotes, false));
    }

    public static Optional<IncludeDirective> createFromTokenWithFilePath(IToken token, String includedFilePath) {
        IncludeDirectiveMatcher matcher = new IncludeDirectiveMatcher(token);
        if (!matcher.match()) {
            return Optional.empty();
        }
        IncludeDirectiveType includeDirectiveType = IncludeDirective.parseIncludeType(matcher.getIncludeDirectiveType()).orElse(null);
        if (includeDirectiveType == null) {
            return Optional.empty();
        }
        boolean usesQuotes = matcher.getIncludedFileExpression().contains("\"");
        return Optional.of(new IncludeDirective(includeDirectiveType, includedFilePath, usesQuotes, false));
    }

    public static IncludeDirective createIncludeNextDirective(@NonNull String includedFilePath) {
        return new IncludeDirective(IncludeDirectiveType.INCLUDE_NEXT, includedFilePath, IncludeDirective.containsQuotes(includedFilePath), false);
    }

    public static IncludeDirective createIncludeDirective(@NonNull String includedFilePath) {
        return new IncludeDirective(IncludeDirectiveType.INCLUDE, includedFilePath, IncludeDirective.containsQuotes(includedFilePath), false);
    }

    public static List<IncludeDirective> createFromTokens(List<IToken> tokens) {
        ArrayList<IncludeDirective> list = new ArrayList<IncludeDirective>();
        for (IToken token : tokens) {
            Optional<IncludeDirective> includeDirective = IncludeDirective.createFromToken(token);
            if (!includeDirective.isPresent()) continue;
            list.add(includeDirective.get());
        }
        return list;
    }

    public boolean isInclude() {
        return this.type == IncludeDirectiveType.INCLUDE || this.type == IncludeDirectiveType.INCLUDE_NEXT && this.ignoreIncludeNext;
    }

    public boolean isImport() {
        return this.type == IncludeDirectiveType.IMPORT;
    }

    public boolean isIncludeNext() {
        return this.type == IncludeDirectiveType.INCLUDE_NEXT && !this.ignoreIncludeNext;
    }

    public @NonNull String getIncludedFilePath() {
        return this.includedFilePath;
    }

    public boolean isUsingQuotes() {
        return this.usesQuotes;
    }

    public IncludeDirective createCopyIgnoringIncludeNext() {
        return new IncludeDirective(this.type, this.includedFilePath, this.usesQuotes, true);
    }

    private IncludeDirective(IncludeDirectiveType includeDirectiveType, @NonNull String includedFilePath, boolean usesQuotes, boolean ignoreIncludeNext) {
        this.type = includeDirectiveType;
        this.includedFilePath = includedFilePath;
        this.usesQuotes = usesQuotes;
        this.ignoreIncludeNext = ignoreIncludeNext;
    }

    private static @Nullable String cleanupIncludeDirectiveFilePath(String includeDirectiveNamePart) {
        List<IToken> includedNameTokens = CPreprocessingUtils.scanMacroContent(includeDirectiveNamePart, ELanguage.CPP);
        if (includedNameTokens.isEmpty()) {
            return null;
        }
        return CPreprocessor.extractIncludedNameWithoutMacroExpansion(includedNameTokens).orElse(null);
    }

    private static Optional<IncludeDirectiveType> parseIncludeType(String directive) {
        switch (directive) {
            case "include": {
                return Optional.of(IncludeDirectiveType.INCLUDE);
            }
            case "import": {
                return Optional.of(IncludeDirectiveType.IMPORT);
            }
            case "include_next": {
                return Optional.of(IncludeDirectiveType.INCLUDE_NEXT);
            }
        }
        return Optional.empty();
    }

    private static boolean containsQuotes(String includedFilePath) {
        return includedFilePath.contains("\"");
    }

    public static enum IncludeDirectiveType {
        INCLUDE,
        IMPORT,
        INCLUDE_NEXT;

    }
}

