/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.preprocessor.c;

import eu.cqse.check.framework.preprocessor.c.EmptyMacroProvider;
import eu.cqse.check.framework.preprocessor.c.IMacroProvider;
import eu.cqse.check.framework.preprocessor.c.MacroDefinition;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class ParsedMacroProvider {
    private final IMacroProvider innerProvider;
    private final Map<String, MacroDefinition> macros = new HashMap<String, MacroDefinition>();
    private final Set<String> undefinedMacros = new HashSet<String>();

    public ParsedMacroProvider(IMacroProvider innerProvider) {
        CCSMAssert.isNotNull((Object)innerProvider);
        this.innerProvider = innerProvider;
    }

    public ParsedMacroProvider() {
        this.innerProvider = new EmptyMacroProvider();
    }

    public ParsedMacroProvider(List<MacroDefinition> initialMacros) {
        this.innerProvider = new EmptyMacroProvider();
        for (MacroDefinition definition : initialMacros) {
            this.macros.put(definition.macroName, definition);
        }
    }

    public boolean isDefined(String name) {
        if (this.undefinedMacros.contains(name)) {
            return false;
        }
        return this.macros.containsKey(name) || this.innerProvider.isDefined(name);
    }

    public boolean isExplicitlyUndefined(String name) {
        return this.undefinedMacros.contains(name) || this.innerProvider.isExplicitylUndefined(name);
    }

    public MacroDefinition getDefinition(String name) {
        MacroDefinition definition = this.macros.get(name);
        if (definition != null) {
            return definition;
        }
        IMacroProvider.RawMacroDefinition macro = this.innerProvider.getDefinition(name);
        if (macro != null) {
            String macroText = macro.macroText();
            TextRegionLocation definitionLocation = macro.location();
            definition = MacroDefinition.parseMacroDefinition(macroText, definitionLocation, macro.language());
            this.macros.put(definition.macroName, definition);
            return definition;
        }
        return null;
    }

    public void define(String definitionText, TextRegionLocation location, ELanguage language, boolean isImmutable) {
        MacroDefinition definition = MacroDefinition.parseMacroDefinition(definitionText, location, language, isImmutable);
        if (this.existsImmutableMacro(definition.macroName)) {
            return;
        }
        this.define(definition);
    }

    public void define(String definitionText, TextRegionLocation location, ELanguage language) {
        this.define(definitionText, location, language, false);
    }

    public void define(MacroDefinition definition) {
        this.macros.put(definition.macroName, definition);
        this.undefinedMacros.remove(definition.macroName);
    }

    public void undefine(String name) {
        if (this.existsImmutableMacro(name)) {
            return;
        }
        this.undefinedMacros.add(name);
        this.macros.remove(name);
    }

    private boolean existsImmutableMacro(String macroName) {
        return this.macros.containsKey(macroName) && this.macros.get((Object)macroName).isImmutable;
    }

    public List<MacroDefinition> getAllDefines() {
        return new ArrayList<MacroDefinition>(this.macros.values());
    }
}

