/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.scanner;

import java.io.EOFException;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class UnicodeEscapes
extends FilterReader {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 512;
    public static final int YYINITIAL = 0;
    public static final int DIGITS = 2;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1};
    private static final int[] ZZ_CMAP_TOP = UnicodeEscapes.zzUnpackcmap_top();
    private static final String ZZ_CMAP_TOP_PACKED_0 = "\u0001\u0000\u10ff\u0100";
    private static final int[] ZZ_CMAP_BLOCKS = UnicodeEscapes.zzUnpackcmap_blocks();
    private static final String ZZ_CMAP_BLOCKS_PACKED_0 = "0\u0000\n\u0001\u0007\u0000\u0006\u0001\u0015\u0000\u0001\u0002\u0004\u0000\u0006\u0001\u000e\u0000\u0001\u0003\u018a\u0000";
    private static final int[] ZZ_ACTION = UnicodeEscapes.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0002\u0000\u0001\u0001\u0001\u0002\u0001\u0000\u0001\u0003\u0007\u0000\u0001\u0004\u0001\u0005";
    private static final int[] ZZ_ROWMAP = UnicodeEscapes.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\u0004\u0000\b\u0000\f\u0000\u0010\u0000\b\u0000\u0014\u0000\u0018\u0000\u001c\u0000 \u0000$\u0000(\u0000,\u0000\b\u0000\b";
    private static final int[] ZZ_TRANS = UnicodeEscapes.zzUnpacktrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0002\u0003\u0001\u0004\u0001\u0003\u0003\u0000\u0001\u0005\u0006\u0000\u0001\u0006\u0001\u0007\u0001\u0000\u0001\b\u0001\u0000\u0001\u0005\u0001\u0000\u0001\t\u0001\u0000\u0001\u0007\u0001\u0000\u0001\n\u0003\u0000\u0001\u000b\u0003\u0000\u0001\f\u0003\u0000\u0001\r\u0003\u0000\u0001\u000e\u0003\u0000\u0001\u000f\u0002\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = UnicodeEscapes.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0002\u0000\u0001\t\u0001\u0001\u0001\u0000\u0001\t\u0007\u0000\u0002\t";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[Math.min(512, this.zzMaxBufferLen())];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private boolean zzAtEOF;
    private int zzFinalHighSurrogate = 0;
    private int yyline;
    private int yycolumn;
    private long yychar;
    private boolean zzAtBOL = true;
    private boolean zzEOFDone;
    private boolean even;
    private final List<Long> fatCharacterOffsets = new ArrayList<Long>();
    private final Map<Long, String> fatCharacters = new HashMap<Long, String>();

    private static int[] zzUnpackcmap_top() {
        int[] result = new int[4352];
        int offset = 0;
        offset = UnicodeEscapes.zzUnpackcmap_top(ZZ_CMAP_TOP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackcmap_top(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackcmap_blocks() {
        int[] result = new int[512];
        int offset = 0;
        offset = UnicodeEscapes.zzUnpackcmap_blocks(ZZ_CMAP_BLOCKS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackcmap_blocks(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAction() {
        int[] result = new int[15];
        int offset = 0;
        offset = UnicodeEscapes.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[15];
        int offset = 0;
        offset = UnicodeEscapes.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length() - 1;
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpacktrans() {
        int[] result = new int[48];
        int offset = 0;
        offset = UnicodeEscapes.zzUnpacktrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpacktrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[15];
        int offset = 0;
        offset = UnicodeEscapes.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private void markUnicodeEscape() {
        long offset = this.yychar - (long)(5 * this.fatCharacterOffsets.size());
        this.fatCharacterOffsets.add(offset);
        this.fatCharacters.put(offset, new String(this.zzBuffer, this.zzCurrentPos, 6));
    }

    long correctOffset(long offset) {
        if (this.fatCharacterOffsets.isEmpty()) {
            return offset;
        }
        int index = Collections.binarySearch(this.fatCharacterOffsets, offset);
        if (index < 0) {
            index = -index - 1;
        }
        return offset + (long)(5 * index);
    }

    String correctText(String text, long offset) {
        int last;
        if (this.fatCharacterOffsets.isEmpty()) {
            return text;
        }
        int first = Collections.binarySearch(this.fatCharacterOffsets, offset);
        if (first < 0) {
            first = -first - 1;
        }
        if ((last = Collections.binarySearch(this.fatCharacterOffsets, offset + (long)text.length() - 1L)) < 0) {
            last = -last - 2;
        }
        for (int i = last; i >= first; --i) {
            StringBuffer newString = new StringBuffer(text);
            long unicodeOffset = this.fatCharacterOffsets.get(i);
            newString.insert((int)(unicodeOffset - offset + 1L), this.fatCharacters.get(unicodeOffset));
            newString.deleteCharAt((int)(unicodeOffset - offset));
            text = newString.toString();
        }
        return text;
    }

    void resetOffsets() {
        this.fatCharacterOffsets.clear();
    }

    private int value() {
        int r = 0;
        for (int k = this.zzMarkedPos - 4; k < this.zzMarkedPos; ++k) {
            int c = this.zzBuffer[k];
            c = c >= 97 ? (c -= 87) : (c >= 65 ? (c -= 55) : (c -= 48));
            r <<= 4;
            r += c;
        }
        if (r == 10 || r == 11 || r == 12 || r == 133 || r == 8232 || r == 8233) {
            r = 32;
        }
        return r;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        for (int i = off; i < len + off; ++i) {
            int c = this.read();
            if (c < 0) {
                if (i - off == 0) {
                    return -1;
                }
                return i - off;
            }
            cbuf[i] = (char)c;
        }
        return len;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public boolean ready() throws IOException {
        return this.zzReader.ready();
    }

    public UnicodeEscapes(Reader in) {
        super(in);
        this.zzReader = in;
    }

    private int zzMaxBufferLen() {
        return Integer.MAX_VALUE;
    }

    private boolean zzCanGrow() {
        return true;
    }

    private static int zzCMap(int input) {
        int offset = input & 0xFF;
        return offset == input ? ZZ_CMAP_BLOCKS[offset] : ZZ_CMAP_BLOCKS[ZZ_CMAP_TOP[input >> 8] | offset];
    }

    private boolean zzRefill() throws IOException {
        int requested;
        int numRead;
        if (this.zzStartRead > 0) {
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length - this.zzFinalHighSurrogate && this.zzCanGrow()) {
            char[] newBuffer = new char[Math.min(this.zzBuffer.length * 2, this.zzMaxBufferLen())];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, requested = this.zzBuffer.length - this.zzEndRead)) == 0) {
            if (requested == 0) {
                throw new EOFException("Scan buffer limit reached [" + this.zzBuffer.length + "]");
            }
            throw new IOException("Reader returned 0 characters. See JFlex examples/zero-reader for a workaround.");
        }
        if (numRead > 0) {
            this.zzEndRead += numRead;
            if (Character.isHighSurrogate(this.zzBuffer[this.zzEndRead - 1])) {
                if (numRead == requested) {
                    --this.zzEndRead;
                    this.zzFinalHighSurrogate = 1;
                } else {
                    int c = this.zzReader.read();
                    if (c == -1) {
                        return true;
                    }
                    this.zzBuffer[this.zzEndRead++] = (char)c;
                }
            }
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzEOFDone = false;
        this.yyResetPosition();
        this.zzLexicalState = 0;
        int initBufferSize = Math.min(512, this.zzMaxBufferLen());
        if (this.zzBuffer.length > initBufferSize) {
            this.zzBuffer = new char[initBufferSize];
        }
    }

    private final void yyResetPosition() {
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzCurrentPos = 0;
        this.zzMarkedPos = 0;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzFinalHighSurrogate = 0;
        this.yyline = 0;
        this.yycolumn = 0;
        this.yychar = 0L;
    }

    public final boolean yyatEOF() {
        return this.zzAtEOF;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int position) {
        return this.zzBuffer[this.zzStartRead + position];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private static void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            UnicodeEscapes.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    @Override
    public int read() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block16: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            this.yychar += (long)(zzMarkedPosL - this.zzStartRead);
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + UnicodeEscapes.zzCMap(zzInput)];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                switch (this.zzLexicalState) {
                    case 0: {
                        return -1;
                    }
                    case 16: {
                        continue block16;
                    }
                }
                return -1;
            }
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    return this.zzBuffer[this.zzStartRead];
                }
                case 6: {
                    continue block16;
                }
                case 2: {
                    this.even = false;
                    return 92;
                }
                case 7: {
                    continue block16;
                }
                case 3: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzStartRead, this.zzEndRead - this.zzStartRead, this.zzStartRead, 1);
                    this.even = !this.even;
                    return 92;
                }
                case 8: {
                    continue block16;
                }
                case 4: {
                    this.yybegin(0);
                    return this.value();
                }
                case 9: {
                    continue block16;
                }
                case 5: {
                    this.zzMarkedPos = Character.offsetByCodePoints(zzBufferL, this.zzStartRead, this.zzEndRead - this.zzStartRead, this.zzStartRead, 1);
                    if (this.even) {
                        this.even = false;
                        return 92;
                    }
                    this.markUnicodeEscape();
                    this.yybegin(2);
                }
                case 10: {
                    continue block16;
                }
            }
            UnicodeEscapes.zzScanError(1);
        }
    }
}

