/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser;

import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.ShallowParserException;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;

public interface IShallowParser {
    public List<ShallowEntity> parseTopLevelWithErrors(List<IToken> var1) throws ShallowParserException;

    public List<ShallowEntity> parseFragmentWithErrors(List<IToken> var1) throws ShallowParserException;

    default public List<ShallowEntity> parseTopLevel(List<IToken> tokens) {
        try {
            return this.parseTopLevelWithErrors(tokens);
        }
        catch (ShallowParserException e) {
            LogManager.getLogger().atError().withThrowable((Throwable)e).log("Error while parsing tokens for origin: {}", (Object)TokenStreamUtils.determineMostSpecificOrigin(tokens));
            return Collections.emptyList();
        }
    }

    default public List<ShallowEntity> parseFragment(List<IToken> tokens) {
        try {
            return this.parseFragmentWithErrors(tokens);
        }
        catch (ShallowParserException e) {
            LogManager.getLogger().atError().withThrowable((Throwable)e).log("Error while parsing tokens for origin: {}", (Object)TokenStreamUtils.determineMostSpecificOrigin(tokens));
            return Collections.emptyList();
        }
    }
}

