/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.framework;

import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.ParserState;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableMap;

class IndexNameResolver
implements INameResolver {
    private static final UnmodifiableMap<Integer, IndexNameResolver> DEFAULT_INDICES = CollectionUtils.asUnmodifiable(IntStream.rangeClosed(-5, 5).mapToObj(IndexNameResolver::new).collect(Collectors.toMap(e -> e.index, Function.identity())));
    private final int index;
    public static final String UNKNOWN_ENTITY_NAME = "<unknown>";

    private IndexNameResolver(int index) {
        this.index = index;
    }

    public static IndexNameResolver of(int index) {
        IndexNameResolver cached = (IndexNameResolver)DEFAULT_INDICES.get((Object)index);
        if (cached != null) {
            return cached;
        }
        return new IndexNameResolver(index);
    }

    @Override
    public String resolveName(ParserState<?> state, List<IToken> tokens, int startOffset, boolean extractStringContent) {
        int resolvedIndex = IndexNameResolver.resolveIndex(state, startOffset, this.index);
        if (resolvedIndex >= tokens.size()) {
            return UNKNOWN_ENTITY_NAME;
        }
        return tokens.get(resolvedIndex).getNormalizedText(extractStringContent);
    }

    public static int resolveIndex(ParserState<?> parserState, int startOffset, int index) {
        index = index >= 0 ? parserState.getCurrentReferencePosition() + index : startOffset + index;
        return index;
    }

    public String toString() {
        return String.valueOf(this.index);
    }
}

