/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.go;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.INameResolver;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.framework.ShallowParserBase;
import eu.cqse.check.framework.shallowparser.languages.base.EGenericParserStates;
import eu.cqse.check.framework.shallowparser.languages.go.GoBraceSkipRecognizer;
import eu.cqse.check.framework.shallowparser.languages.go.GoForStatementRecognizer;
import eu.cqse.check.framework.shallowparser.languages.go.GoSkipToEndOfStatementRecognizer;

public class GoShallowParser
extends ShallowParserBase<EGenericParserStates> {
    public GoShallowParser() {
        super(EGenericParserStates.class, EGenericParserStates.TOP_LEVEL);
        this.createMetaRules();
        this.createStatementRules();
        this.createSubExpressionRules();
    }

    private void createMetaRules() {
        this.createPackageRule();
        this.createImportRule();
        this.createLabelRule();
    }

    private void createPackageRule() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.PACKAGE}).markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).createNode(EShallowEntityType.META, "package", INameResolver.ofRange(0, -1)).endNode();
    }

    private void createImportRule() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.IMPORT}).markStart().sequence(new ITokenMatcher[]{ETokenType.STRING_LITERAL}).createNode(EShallowEntityType.META, "import", INameResolver.ofRange(0, -1)).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.IMPORT}).markStart().skipNested(ETokenType.LPAREN, ETokenType.RPAREN).createNode(EShallowEntityType.META, "import").endNode();
    }

    private void createLabelRule() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER, ETokenType.COLON}).createNode(EShallowEntityType.META, "label", INameResolver.ofIndex(-2)).endNode();
    }

    private void createStatementRules() {
        this.createDeclarationRules();
        this.createIfStatementRules();
        this.createSwitchStatementRules();
        this.createSelectStatementRules();
        this.createForStatementRules();
        this.createAnonymousBlockRule();
        this.createSimpleStatementRules();
    }

    private void createDeclarationRules() {
        this.createConstantDeclarationRules();
        this.createTypeDeclarationRules();
        this.createVariableDeclarationRules();
        this.createFunctionDeclarationRules();
        this.createMethodDeclarationRules();
    }

    private void createConstantDeclarationRules() {
        RecognizerBase<EGenericParserStates> constBase = this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD, EGenericParserStates.TOP_LEVEL}).sequenceBefore(new ITokenMatcher[]{ETokenType.CONST}).createNode(EShallowEntityType.ATTRIBUTE, "constant");
        GoShallowParser.skipToEndOfStatement(constBase, true);
    }

    private void createTypeDeclarationRules() {
        RecognizerBase<EGenericParserStates> typeBase = this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD, EGenericParserStates.TOP_LEVEL}).sequenceBefore(new ITokenMatcher[]{ETokenType.TYPE}).createNode(EShallowEntityType.TYPE, "declaration");
        GoShallowParser.skipToEndOfStatement(typeBase, true);
    }

    private void createVariableDeclarationRules() {
        RecognizerBase<EGenericParserStates> typeBase = this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD, EGenericParserStates.TOP_LEVEL}).sequenceBefore(new ITokenMatcher[]{ETokenType.VAR}).createNode(EShallowEntityType.ATTRIBUTE, "variable", INameResolver.secondMatchedTokenText());
        GoShallowParser.skipToEndOfStatement(typeBase, true);
    }

    private void createFunctionDeclarationRules() {
        RecognizerBase<EGenericParserStates> functionPrefix = this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.FUNC});
        GoShallowParser.createGeneralFunctionRules(functionPrefix, "function");
    }

    private void createMethodDeclarationRules() {
        RecognizerBase<EGenericParserStates> methodPrefix = this.inState(new EGenericParserStates[]{EGenericParserStates.TOP_LEVEL}).sequence(new ITokenMatcher[]{ETokenType.FUNC}).sequence(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN);
        GoShallowParser.createGeneralFunctionRules(methodPrefix, "method");
    }

    private static void createGeneralFunctionRules(RecognizerBase<EGenericParserStates> base, String subtype) {
        RecognizerBase<EGenericParserStates> functionDef = base.markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).skipNested(ETokenType.LBRACK, ETokenType.RBRACK).sequence(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN);
        functionDef.sequence(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.METHOD, subtype, INameResolver.firstMatchedTokenText()).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        functionDef.sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.METHOD, subtype, INameResolver.firstMatchedTokenText()).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        functionDef.subRecognizer(new GoBraceSkipRecognizer(), 1, 1).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.METHOD, subtype, INameResolver.firstMatchedTokenText()).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        functionDef.subRecognizer(new GoSkipToEndOfStatementRecognizer(false, false), 0, 1).createNode(EShallowEntityType.METHOD, subtype, INameResolver.firstMatchedTokenText()).endNode();
    }

    private void createAnonymousBlockRule() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.STATEMENT, "anonymous block").parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private void createIfStatementRules() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.IF}).markStart().skipBeforeWithNesting((ITokenMatcher)ETokenType.LBRACE, ETokenType.LPAREN, ETokenType.RPAREN).createNode(EShallowEntityType.STATEMENT, "if", INameResolver.ofRange(0, -1)).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.IF}).parseUntil(EGenericParserStates.IN_METHOD).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).skipBefore(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.STATEMENT, "if", INameResolver.ofRange(0, -1)).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.ELSE, ETokenType.IF}).markStart().skipBefore(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.STATEMENT, "else if", INameResolver.ofRange(0, -1)).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.ELSE, ETokenType.IF}).parseUntil(EGenericParserStates.IN_METHOD).skipAfter(new ITokenMatcher[]{ETokenType.SEMICOLON}).markStart().sequence(new ITokenMatcher[]{ETokenType.IDENTIFIER}).skipBefore(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.STATEMENT, "if", INameResolver.ofRange(0, -1)).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.ELSE}).createNode(EShallowEntityType.STATEMENT, "else").sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private void createSwitchStatementRules() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.SWITCH}).createNode(EShallowEntityType.STATEMENT, "switch").skipAfter(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD}).markStart().sequence(new ITokenMatcher[]{ETokenType.CASE}).skipBefore(new ITokenMatcher[]{ETokenType.COLON}).createNode(EShallowEntityType.META, "case").sequence(new ITokenMatcher[]{ETokenType.COLON}).endNode();
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD}).markStart().sequence(new ITokenMatcher[]{ETokenType.DEFAULT}).sequence(new ITokenMatcher[]{ETokenType.COLON}).createNode(EShallowEntityType.META, "default").endNode();
    }

    private void createSelectStatementRules() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.SELECT}).markStart().skipBefore(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.STATEMENT, "select").sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private void createForStatementRules() {
        RecognizerBase<EGenericParserStates> startSequence = this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD}).sequence(new ITokenMatcher[]{ETokenType.FOR}).markStart();
        GoShallowParser.createForStatementNode(GoShallowParser.skipToForBrace(startSequence));
    }

    private void createSimpleStatementRules() {
        ITokenMatcher statementStartTokens = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.MULT, ETokenType.GO, ETokenType.GOTO, ETokenType.FALLTHROUGH, ETokenType.DEFER, ETokenType.RETURN, ETokenType.BREAK, ETokenType.CONTINUE});
        RecognizerBase<EGenericParserStates> simpleStatementBase = this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD, EGenericParserStates.TOP_LEVEL}).sequenceBefore(statementStartTokens).createNode(EShallowEntityType.STATEMENT, "simple statement", INameResolver.firstMatchedTokenText());
        GoShallowParser.skipToEndOfStatement(simpleStatementBase, true);
        RecognizerBase<EGenericParserStates> inParenthesis = this.inState(new EGenericParserStates[]{EGenericParserStates.IN_METHOD, EGenericParserStates.TOP_LEVEL}).sequenceBefore(new ITokenMatcher[]{ETokenType.LPAREN}).skipNested(ETokenType.LPAREN, ETokenType.RPAREN).createNode(EShallowEntityType.STATEMENT, "simple statement", INameResolver.ofRange(0, -1));
        GoShallowParser.skipToEndOfStatement(inParenthesis);
    }

    private static void skipToEndOfStatement(RecognizerBase<EGenericParserStates> base) {
        GoShallowParser.skipToEndOfStatement(base, false);
    }

    private static void skipToEndOfStatement(RecognizerBase<EGenericParserStates> base, boolean forceMatch) {
        GoSkipToEndOfStatementRecognizer recognizer = new GoSkipToEndOfStatementRecognizer(forceMatch, true);
        base.subRecognizer(recognizer, 0, 1).endNode();
    }

    private static void createForStatementNode(RecognizerBase<EGenericParserStates> base) {
        base.createNode(EShallowEntityType.STATEMENT, "for", INameResolver.ofRange(0, -1)).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }

    private static RecognizerBase<EGenericParserStates> skipToForBrace(RecognizerBase<EGenericParserStates> base) {
        GoForStatementRecognizer recognizer = new GoForStatementRecognizer();
        return base.optionalSubRecognizer(recognizer);
    }

    protected void createSubExpressionRules() {
        this.inState(new EGenericParserStates[]{EGenericParserStates.IN_EXPRESSION}).sequence(new ITokenMatcher[]{ETokenType.FUNC}).markStart().sequence(new ITokenMatcher[]{ETokenType.LPAREN}).skipAfterWithNesting((ITokenMatcher)ETokenType.RPAREN, ETokenType.LPAREN, ETokenType.RPAREN).subRecognizer(new GoBraceSkipRecognizer(), 0, 1).createNode(EShallowEntityType.METHOD, "anonymous function", INameResolver.ofRange(0, -1)).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }
}

