/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.groovy;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ParserState;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.languages.groovy.EGroovyShallowParserStates;
import eu.cqse.check.framework.shallowparser.languages.groovy.GroovySubExpressionRecognizer;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

class GroovySkipToEndOfStatementRecognizer
extends RecognizerBase<EGroovyShallowParserStates> {
    private static final ITokenMatcher CONTINUE_TOKENS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.BACKSLASH, ETokenType.DOT, ETokenType.QUESTION, ETokenType.COLON, ETokenType.NOT});
    private static final ITokenMatcher NON_CONTINUATION_OPERATORS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.MINUSMINUS, ETokenType.PLUSPLUS});
    private static final Map<ETokenType, ETokenType> NESTING_MATCH = new EnumMap<ETokenType, ETokenType>(ETokenType.class);
    private boolean forceMatch = false;

    GroovySkipToEndOfStatementRecognizer() {
    }

    public void setForceMatch(boolean forceMatch) {
        this.forceMatch = forceMatch;
    }

    @Override
    protected int matchesLocally(ParserState<EGroovyShallowParserStates> parserState, List<IToken> tokens, int startOffset) {
        if (startOffset < 0) {
            return -1;
        }
        IToken lastToken = null;
        if (!this.forceMatch && startOffset > 0) {
            lastToken = tokens.get(startOffset - 1);
        }
        Stack<ETokenType> expectedClosing = new Stack<ETokenType>();
        while (startOffset < tokens.size()) {
            IToken token = tokens.get(startOffset);
            ETokenType tokenType = token.getType();
            if (!expectedClosing.isEmpty() && tokenType == expectedClosing.peek()) {
                expectedClosing.pop();
            } else {
                if (expectedClosing.isEmpty() && tokenType == ETokenType.SEMICOLON) {
                    return startOffset + 1;
                }
                if (expectedClosing.isEmpty() && TokenStreamUtils.startsNewStatement(token, lastToken, CONTINUE_TOKENS, NON_CONTINUATION_OPERATORS, (ITokenMatcher)ETokenType.RBRACE)) {
                    return startOffset;
                }
                if (NESTING_MATCH.containsKey(tokenType)) {
                    expectedClosing.push(NESTING_MATCH.get(tokenType));
                } else {
                    startOffset = GroovySkipToEndOfStatementRecognizer.startSubExpressionRecognizer(tokens, startOffset, parserState);
                    lastToken = tokens.get(startOffset - 1);
                    continue;
                }
            }
            lastToken = token;
            ++startOffset;
        }
        return startOffset;
    }

    private static int startSubExpressionRecognizer(List<IToken> tokens, int startOffset, ParserState<EGroovyShallowParserStates> parserState) {
        GroovySubExpressionRecognizer subExpressionRecognizer = new GroovySubExpressionRecognizer();
        int next = subExpressionRecognizer.matches(parserState, tokens, startOffset);
        if (next == -1) {
            return startOffset + 1;
        }
        return next;
    }

    static {
        NESTING_MATCH.put(ETokenType.LPAREN, ETokenType.RPAREN);
        NESTING_MATCH.put(ETokenType.LBRACK, ETokenType.RBRACK);
    }
}

