/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.languages.opencl;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.RecognizerBase;
import eu.cqse.check.framework.shallowparser.languages.base.EGenericParserStates;
import eu.cqse.check.framework.shallowparser.languages.cpp.CppShallowParser;
import eu.cqse.check.framework.shallowparser.languages.cpp.CppShallowParserAdditionalStatementRules;
import eu.cqse.check.framework.shallowparser.languages.opencl.OpenCLLambdaAndBlockLiteralRecognizer;

public class OpenCLShallowParser
extends CppShallowParser {
    private static final ITokenMatcher OPENCL_VALID_IDENTIFIERS = ETokenType.IDENTIFIER;
    private static final ITokenMatcher OPENCL_PRIMITIVE_TYPES = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.UCHAR, ETokenType.USHORT, ETokenType.UINT, ETokenType.ULONG, ETokenType.HALF, ETokenType.SIZE_T, ETokenType.PTRDIFF_T, ETokenType.INTPTR_T, ETokenType.UINTPTR_T}).or(new ITokenMatcher[]{CppShallowParser.PRIMITIVE_TYPES});
    private static final ITokenMatcher OPENCL_TYPE_OR_IDENTIFIER = CppShallowParser.BASE_TYPE_OR_IDENTIFIER.or(new ITokenMatcher[]{OPENCL_PRIMITIVE_TYPES});
    private static final ITokenMatcher OPENCL_METHOD_AND_TYPE_DECLARATION_MODIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.GLOBAL, ETokenType.LOCAL, ETokenType.CONSTANT, ETokenType.PRIVATE, ETokenType.KERNEL, ETokenType.READONLY, ETokenType.WRITEONLY, ETokenType.READWRITE}).or(new ITokenMatcher[]{CppShallowParser.METHOD_AND_TYPE_DECLARATION_MODIFIERS});

    @Override
    public ITokenMatcher getIdentifierMatcher() {
        return OPENCL_VALID_IDENTIFIERS;
    }

    @Override
    protected ITokenMatcher getPrimitiveTypes() {
        return OPENCL_PRIMITIVE_TYPES;
    }

    @Override
    protected ITokenMatcher getTypeOrIdentifier() {
        return OPENCL_TYPE_OR_IDENTIFIER;
    }

    @Override
    public ITokenMatcher getMethodAndTypeDeclarationModifiers() {
        return OPENCL_METHOD_AND_TYPE_DECLARATION_MODIFIERS;
    }

    @Override
    public RecognizerBase<EGenericParserStates> getSubExpressionRecognizer() {
        return new OpenCLLambdaAndBlockLiteralRecognizer(this.getTypeOrIdentifier());
    }

    @Override
    protected void createSubExpressionRules() {
        RecognizerBase<EGenericParserStates> blockStart = this.inState(new EGenericParserStates[]{EGenericParserStates.IN_EXPRESSION}).sequence(new ITokenMatcher[]{ETokenType.XOR});
        OpenCLShallowParser.finishBlockRecognizer(this.typePattern(blockStart));
        OpenCLShallowParser.finishBlockRecognizer(blockStart);
        super.createSubExpressionRules();
    }

    @Override
    protected void createSimpleStatementRule() {
        new CppShallowParserAdditionalStatementRules(this).contributeUnexpandedMacroRule();
        this.contributeSimpleStatementRules(this.getIdentifierMatcher(), this.getStatementStartTokens());
    }

    private static void finishBlockRecognizer(RecognizerBase<EGenericParserStates> currentState) {
        currentState.skipNested(ETokenType.LPAREN, ETokenType.RPAREN).sequence(new ITokenMatcher[]{ETokenType.LBRACE}).createNode(EShallowEntityType.METHOD, "block literal").parseUntil(EGenericParserStates.IN_METHOD).sequence(new ITokenMatcher[]{ETokenType.RBRACE}).endNode();
    }
}

