/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.shallowparser.util;

import eu.cqse.check.framework.shallowparser.ShallowParserException;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.util.EntitySelectionExpressionParsingException;
import eu.cqse.check.framework.shallowparser.util.EntitySelectionPredicates;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.string.StringUtils;

public class EntitySelectionExpressionParser {
    private static final Pattern PARAMETER_ESCAPING = Pattern.compile("['\"]");
    private static final Pattern DASH_OR_UNDERSCORE = Pattern.compile("[-_]");
    private static final UnmodifiableMap<String, Method> FACTORY_METHODS = EntitySelectionExpressionParser.loadFactoryMethods();
    private final String expression;
    private int position = 0;

    private static UnmodifiableMap<String, Method> loadFactoryMethods() {
        return CollectionUtils.asUnmodifiable(Arrays.stream(EntitySelectionPredicates.class.getDeclaredMethods()).filter(EntitySelectionExpressionParser::hasCorrectSignature).collect(Collectors.toMap(method -> EntitySelectionExpressionParser.normalizeName(method.getName()), Function.identity())));
    }

    private static boolean hasCorrectSignature(Method method) {
        if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        EntitySelectionExpressionParser.assertParameterTypes(method);
        EntitySelectionExpressionParser.assertReturnType(method);
        return true;
    }

    private static void assertParameterTypes(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        boolean noParameters = parameterTypes.length == 0;
        boolean oneStringParameter = parameterTypes.length == 1 && parameterTypes[0] == String.class;
        CCSMAssert.isTrue((noParameters || oneStringParameter ? 1 : 0) != 0, () -> "Factory methods in %s must have no parameters or one string parameter. Violating method: %s".formatted(EntitySelectionPredicates.class.getSimpleName(), method));
    }

    private static void assertReturnType(Method method) {
        ParameterizedType expectedReturnType = TypeUtils.parameterize(Predicate.class, (Type[])new Type[]{ShallowEntity.class});
        CCSMAssert.isTrue((boolean)expectedReturnType.equals(method.getGenericReturnType()), () -> "Factory methods in %s must have the return type %s. Violating method: %s".formatted(EntitySelectionPredicates.class, expectedReturnType, method));
    }

    private EntitySelectionExpressionParser(String expression) {
        this.expression = expression;
    }

    public static Predicate<ShallowEntity> parse(String expression) throws ShallowParserException {
        return new EntitySelectionExpressionParser(expression).parse();
    }

    private Predicate<ShallowEntity> parse() throws ShallowParserException {
        Predicate<ShallowEntity> predicate = this.parse(false, true);
        if (this.position < this.expression.length()) {
            this.error(EntitySelectionExpressionParsingException.EParsingExceptionMessage.MISPLACED_CLOSING_PARENTHESIS);
        }
        return predicate;
    }

    private Predicate<ShallowEntity> parse(boolean expectClosingParenthesis, boolean mayParseBinary) throws ShallowParserException {
        Predicate<ShallowEntity> result = null;
        block7: while (this.position < this.expression.length()) {
            char next;
            if (Character.isWhitespace(next = this.expression.charAt(this.position++))) continue;
            if (EntitySelectionExpressionParser.isIdentifierCharacter(next)) {
                this.assertNoResult(result);
                --this.position;
                result = this.parsePrimitiveExpression();
                if (mayParseBinary) continue;
                return result;
            }
            switch (next) {
                case '(': {
                    this.assertNoResult(result);
                    result = this.parse(true, true);
                    continue block7;
                }
                case ')': {
                    if (!expectClosingParenthesis) {
                        --this.position;
                    }
                    return this.assertResult(result);
                }
                case '&': {
                    if (!mayParseBinary) {
                        --this.position;
                        return this.assertResult(result);
                    }
                    result = this.assertResult(result).and(this.parse(false, true));
                    continue block7;
                }
                case '|': {
                    if (!mayParseBinary) {
                        --this.position;
                        return this.assertResult(result);
                    }
                    result = this.assertResult(result).or(this.parse(false, true));
                    continue block7;
                }
                case '!': {
                    this.assertNoResult(result);
                    result = this.parse(false, false).negate();
                    continue block7;
                }
            }
            this.error(EntitySelectionExpressionParsingException.EParsingExceptionMessage.UNEXPECTED_CHARACTER);
        }
        if (expectClosingParenthesis) {
            this.error(EntitySelectionExpressionParsingException.EParsingExceptionMessage.MISSING_CLOSING_PARENTHESIS);
        }
        return this.assertResult(result);
    }

    private Predicate<ShallowEntity> parsePrimitiveExpression() throws ShallowParserException {
        StringBuilder nameBuilder = new StringBuilder();
        while (this.position < this.expression.length() && EntitySelectionExpressionParser.isIdentifierCharacter(this.expression.charAt(this.position))) {
            nameBuilder.append(this.expression.charAt(this.position++));
        }
        return this.createPredicate(EntitySelectionExpressionParser.normalizeName(nameBuilder.toString()), this.extractParameter());
    }

    private String extractParameter() throws EntitySelectionExpressionParsingException {
        while (this.position < this.expression.length() && Character.isWhitespace(this.expression.charAt(this.position))) {
            ++this.position;
        }
        if (this.position >= this.expression.length() || this.expression.charAt(this.position) != '(') {
            return null;
        }
        StringBuilder parameterBuilder = new StringBuilder();
        ++this.position;
        int nestingCount = 0;
        while (this.position < this.expression.length() && (nestingCount > 0 || this.expression.charAt(this.position) != ')')) {
            char next = this.expression.charAt(this.position);
            if (next == '(') {
                ++nestingCount;
            } else if (next == ')') {
                --nestingCount;
            }
            parameterBuilder.append(next);
            ++this.position;
        }
        if (this.position >= this.expression.length()) {
            this.error(EntitySelectionExpressionParsingException.EParsingExceptionMessage.MISSING_CLOSING_PARENTHESIS);
        }
        ++this.position;
        if (parameterBuilder.isEmpty()) {
            return null;
        }
        return PARAMETER_ESCAPING.matcher(parameterBuilder.toString()).replaceAll("");
    }

    private static String normalizeName(String name) {
        name = name.toLowerCase();
        name = DASH_OR_UNDERSCORE.matcher(name).replaceAll("");
        name = StringUtils.stripPrefix((String)name, (String)"select");
        return name;
    }

    private static boolean isIdentifierCharacter(char character) {
        return Character.isJavaIdentifierPart(character) || character == '-';
    }

    private Predicate<ShallowEntity> createPredicate(String name, String parameter) throws ShallowParserException {
        Method method = (Method)FACTORY_METHODS.get((Object)name);
        try {
            if (method != null) {
                if (method.getParameterTypes().length == 0) {
                    if (parameter != null) {
                        this.error(EntitySelectionExpressionParsingException.EParsingExceptionMessage.UNSUPPORTED_PARAMETER);
                    }
                    return (Predicate)method.invoke(null, new Object[0]);
                }
                if (parameter == null) {
                    this.error(EntitySelectionExpressionParsingException.EParsingExceptionMessage.PARAMETER_MISSING);
                }
                return (Predicate)method.invoke(null, parameter);
            }
            this.error(EntitySelectionExpressionParsingException.EParsingExceptionMessage.PREDICATE_NOT_FOUND);
        }
        catch (IllegalAccessException e) {
            this.error(EntitySelectionExpressionParsingException.EParsingExceptionMessage.PREDICATE_CONSTRUCTION_FAILED, e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof ShallowParserException) {
                throw (ShallowParserException)e.getCause();
            }
            this.error(EntitySelectionExpressionParsingException.EParsingExceptionMessage.PREDICATE_CONSTRUCTION_FAILED, e.getCause());
        }
        throw new AssertionError((Object)"This line should not be reachable!");
    }

    private void assertNoResult(Predicate<ShallowEntity> result) throws EntitySelectionExpressionParsingException {
        if (result != null) {
            this.error(EntitySelectionExpressionParsingException.EParsingExceptionMessage.EXPECTED_BINARY_OPERATOR);
        }
    }

    private Predicate<ShallowEntity> assertResult(Predicate<ShallowEntity> result) throws EntitySelectionExpressionParsingException {
        if (result == null) {
            this.error(EntitySelectionExpressionParsingException.EParsingExceptionMessage.EXPECTED_EXPRESSION);
        }
        return result;
    }

    private void error(EntitySelectionExpressionParsingException.EParsingExceptionMessage messageIdentifier) throws EntitySelectionExpressionParsingException {
        throw new EntitySelectionExpressionParsingException(messageIdentifier, this.expression, this.position);
    }

    private void error(EntitySelectionExpressionParsingException.EParsingExceptionMessage messageIdentifier, Throwable cause) throws EntitySelectionExpressionParsingException {
        throw new EntitySelectionExpressionParsingException(messageIdentifier, this.expression, this.position, cause);
    }
}

