/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.typetracker.abap;

import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.TypeTrackerBase;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;

public class AbapTypeTracker
extends TypeTrackerBase {
    private List<ShallowEntity> rootEntities;

    public AbapTypeTracker() {
        super(ELanguage.ABAP);
    }

    @Override
    protected Set<String> getSeparateScopeSubtypes() {
        return CollectionUtils.emptySet();
    }

    @Override
    protected boolean needsOrderedScope(ShallowEntity entity) {
        return false;
    }

    @Override
    protected void initialize(List<ShallowEntity> rootEntities) {
        this.rootEntities = rootEntities;
    }

    @Override
    protected Optional<ShallowEntity> getAdditionalParent(ShallowEntity entity) {
        switch (entity.getSubtype()) {
            case "method implementation": {
                return Optional.ofNullable(LanguageFeatureParser.ABAP.getMethodDeclaration(this.rootEntities, entity));
            }
            case "class implementation": {
                return Optional.ofNullable(LanguageFeatureParser.ABAP.getClassDeclaration(this.rootEntities, entity));
            }
        }
        return Optional.empty();
    }
}

