/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.typetracker.java;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public final class ImportInformation {
    private final @Nullable String packageName;
    private final UnmodifiableMap<String, String> typeImports;
    private final UnmodifiableSet<String> wildcardImports;
    private final UnmodifiableSet<String> moduleImports;
    private final UnmodifiableSet<String> staticImports;

    @VisibleForTesting
    ImportInformation(@Nullable String packageName, Map<String, String> typeImports, Set<String> wildcardImports, Set<String> moduleImports, Set<String> staticImports) {
        this.packageName = packageName;
        this.typeImports = CollectionUtils.asUnmodifiable(Map.copyOf(typeImports));
        this.wildcardImports = CollectionUtils.asUnmodifiable(Set.copyOf(wildcardImports));
        this.moduleImports = CollectionUtils.asUnmodifiable(Set.copyOf(moduleImports));
        this.staticImports = CollectionUtils.asUnmodifiable(Set.copyOf(staticImports));
    }

    public ImportInformation(ShallowEntity root) {
        HashMap<String, String> typeImports = new HashMap<String, String>();
        HashSet<String> wildcardImports = new HashSet<String>();
        wildcardImports.add("java.lang");
        HashSet<String> moduleImports = new HashSet<String>();
        HashSet<String> staticImports = new HashSet<String>();
        String packageName = LanguageFeatureParser.JAVA.getPackageName((List<ShallowEntity>)root.getChildren()).orElse(null);
        List importEntities = ShallowEntityTraversalUtils.listEntitiesOfTypesWithSubtypes(List.of(root), EnumSet.of(EShallowEntityType.META), Set.of("import", "static import", "module import"));
        for (ShallowEntity entity : importEntities) {
            if (TokenStreamUtils.firstTokenMatching((List<IToken>)entity.ownStartTokens(), (ITokenMatcher)ETokenType.STATIC) != -1) {
                staticImports.add(entity.getName());
                continue;
            }
            if ("module import".equals(entity.getSubtype())) {
                moduleImports.add(entity.getName());
                continue;
            }
            String importIdentifier = entity.getName();
            Pair pPackageImported = StringUtils.splitAtLast((String)importIdentifier, (char)'.');
            if (((String)pPackageImported.getSecond()).equals("*")) {
                wildcardImports.add((String)pPackageImported.getFirst());
                continue;
            }
            typeImports.put((String)pPackageImported.getSecond(), importIdentifier);
        }
        this(packageName, typeImports, wildcardImports, moduleImports, staticImports);
    }

    public @Nullable String getPackageName() {
        return this.packageName;
    }

    public UnmodifiableMap<String, String> getTypeImports() {
        return this.typeImports;
    }

    public UnmodifiableSet<String> getWildcardImports() {
        return this.wildcardImports;
    }

    public UnmodifiableSet<String> getModuleImports() {
        return this.moduleImports;
    }

    public UnmodifiableSet<String> getStaticImports() {
        return this.staticImports;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof ImportInformation)) return false;
        ImportInformation that = (ImportInformation)o;
        if (!Objects.equals(this.packageName, that.packageName)) return false;
        if (!Objects.equals(this.typeImports, that.typeImports)) return false;
        if (!Objects.equals(this.wildcardImports, that.wildcardImports)) return false;
        if (!Objects.equals(this.moduleImports, that.moduleImports)) return false;
        if (!Objects.equals(this.staticImports, that.staticImports)) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.packageName, this.typeImports, this.wildcardImports, this.moduleImports, this.staticImports);
    }

    public String toString() {
        return "ImportInformation[packageName=" + this.packageName + ", typeImports=" + String.valueOf(this.typeImports) + ", wildcardImports=" + String.valueOf(this.wildcardImports) + ", moduleImports=" + String.valueOf(this.moduleImports) + ", staticImports=" + String.valueOf(this.staticImports) + "]";
    }
}

