/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.typetracker.java;

import com.google.common.collect.Iterables;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.typetracker.ScopedTypeLookup;
import eu.cqse.check.framework.typetracker.java.FullyQualifiedUsageResolver;
import eu.cqse.check.framework.typetracker.java.ImportInformation;
import eu.cqse.check.framework.typetracker.java.ModuleImportResolver;
import eu.cqse.check.framework.typetracker.java.SamePackageImportResolver;
import eu.cqse.check.framework.typetracker.java.SpecificImportResolver;
import eu.cqse.check.framework.typetracker.java.TypeUsageResolutionResult;
import eu.cqse.check.framework.typetracker.java.TypeUsageResolver;
import eu.cqse.check.framework.typetracker.java.WildcardImportResolver;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

public class JavaImportSensitiveTypeResolver {
    private final ImportInformation importInformation;
    private static final TokenPattern TYPE_REFERENCES_PATTERN = JavaImportSensitiveTypeResolver.buildTypeReferencesPattern();
    private static final List<TypeUsageResolver> RESOLVERS = List.of(new SpecificImportResolver(), new SamePackageImportResolver(), new WildcardImportResolver(), new ModuleImportResolver(), new FullyQualifiedUsageResolver());

    private static TokenPattern buildTypeReferencesPattern() {
        ITokenMatcher identifier = LanguageFeatureParser.JAVA.getValidIdentifierTokenTypes();
        TokenPattern unqualifiedUsage = TokenPattern.of().notPrecededBy(ETokenType.DOT).sequence(identifier).group(0).notFollowedBy(ETokenType.DOT);
        TokenPattern constructorCall = TokenPattern.of().sequence(ETokenType.NEW).sequence(identifier).group(0).repeated(ETokenType.DOT, identifier).group(0);
        TokenPattern qualifiedUsage = TokenPattern.of().notPrecededBy(ETokenType.DOT).sequence(identifier).group(0).repeated(ETokenType.DOT, identifier).group(0).sequence(ETokenType.DOT, identifier, ETokenType.LPAREN);
        TokenPattern typeReference = TokenPattern.of().notPrecededBy(ETokenType.DOT).sequence(identifier).group(0).repeated(ETokenType.DOT, identifier).group(0).notFollowedBy(ETokenType.LPAREN);
        TokenPattern classReference = TokenPattern.of().notPrecededBy(ETokenType.DOT).sequence(identifier).group(0).repeated(ETokenType.DOT, identifier).group(0).sequence(ETokenType.CLASS);
        return TokenPattern.of().alternative(unqualifiedUsage, constructorCall, qualifiedUsage, typeReference, classReference);
    }

    public JavaImportSensitiveTypeResolver(ShallowEntity root) {
        this.importInformation = new ImportInformation(root);
    }

    public Optional<String> getFullyQualifiedTypeOfIdentifier(String identifier, ScopedTypeLookup lookup) {
        return Optional.ofNullable(lookup.getTypeInfo(identifier)).map(typedVariable -> this.getFullyQualifiedTypeName(typedVariable.getTypeNameWithoutGenericTypeParameter()));
    }

    public String getFullyQualifiedTypeName(String simpleType) {
        return (String)this.importInformation.getTypeImports().getOrDefault((Object)simpleType, (Object)simpleType);
    }

    public UnmodifiableSet<String> getWildcardImports() {
        return this.importInformation.getWildcardImports();
    }

    public TypeUsageResolutionResult getPossibleFullyQualifiedTypeNames(@NonNull String typeName) {
        TypeUsageResolutionResult previous = new TypeUsageResolutionResult.NotFound();
        block5: for (TypeUsageResolver resolver : RESOLVERS) {
            TypeUsageResolutionResult typeUsageResolutionResult;
            TypeUsageResolutionResult result = resolver.resolve(this.importInformation, typeName);
            Objects.requireNonNull(result);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TypeUsageResolutionResult.NotFound.class, TypeUsageResolutionResult.Accurate.class, TypeUsageResolutionResult.Inaccurate.class}, (TypeUsageResolutionResult)typeUsageResolutionResult, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    TypeUsageResolutionResult.NotFound notFound = (TypeUsageResolutionResult.NotFound)typeUsageResolutionResult;
                    previous = previous.merge(notFound);
                    continue block5;
                }
                case 1: {
                    TypeUsageResolutionResult.Accurate accurate = (TypeUsageResolutionResult.Accurate)typeUsageResolutionResult;
                    return previous.merge(accurate);
                }
                case 2: 
            }
            TypeUsageResolutionResult.Inaccurate inaccurate = (TypeUsageResolutionResult.Inaccurate)typeUsageResolutionResult;
            previous = previous.merge(inaccurate);
        }
        return previous;
    }

    public Optional<Boolean> isOfType(List<IToken> tokens, Set<String> fullyQualifiedTypeNames, ScopedTypeLookup lookup) {
        return this.isOfType(tokens, fullyQualifiedTypeNames, lookup, Collections.emptySet());
    }

    public Optional<Boolean> isOfType(List<IToken> tokens, Set<String> fullyQualifiedTypeNames, ScopedTypeLookup lookup, Set<String> methods) {
        if (tokens.isEmpty()) {
            return Optional.empty();
        }
        IToken last = (IToken)Iterables.getLast(tokens);
        switch (last.getType()) {
            case IDENTIFIER: {
                return Optional.ofNullable(lookup.getTypeInfo(last.getText())).map(typedVariable -> this.typeIsOf(typedVariable.getTypeNameWithoutGenericTypeParameter(), fullyQualifiedTypeNames));
            }
            case RPAREN: {
                return this.callReturnsType(tokens, fullyQualifiedTypeNames, methods);
            }
        }
        return Optional.empty();
    }

    private Optional<Boolean> callReturnsType(List<IToken> tokens, Set<String> fullyQualifiedTypeNames, Set<String> methods) {
        int indexMatchingLparen = TokenStreamUtils.findMatchingOpeningToken(tokens, tokens.size() - 2, ETokenType.LPAREN, ETokenType.RPAREN);
        CCSMAssert.isFalse((indexMatchingLparen == -1 ? 1 : 0) != 0, (String)"tokens must include the opening parenthesis");
        if (indexMatchingLparen == 0) {
            return Optional.empty();
        }
        Optional<Boolean> constructor = this.checkConstructor(tokens, fullyQualifiedTypeNames, indexMatchingLparen);
        if (constructor.isPresent()) {
            return constructor;
        }
        if (tokens.get(indexMatchingLparen - 1).getType() == ETokenType.IDENTIFIER && methods.contains(tokens.get(indexMatchingLparen - 1).getText())) {
            return Optional.of(true);
        }
        return Optional.empty();
    }

    private Optional<Boolean> checkConstructor(List<IToken> tokens, Set<String> fullyQualifiedTypeNames, int indexMatchingLparen) {
        int qSequenceStart;
        int qSequenceEndNonInclusive = indexMatchingLparen;
        if (indexMatchingLparen - 2 >= 0 && tokens.get(indexMatchingLparen - 1).getType() == ETokenType.GT) {
            qSequenceEndNonInclusive = TokenStreamUtils.findMatchingOpeningToken(tokens, indexMatchingLparen - 2, ETokenType.LT, ETokenType.GT);
            CCSMAssert.isFalse((qSequenceEndNonInclusive == -1 ? 1 : 0) != 0, (String)"tokens must include opening generics delimiter");
        }
        if ((qSequenceStart = TokenStreamUtils.firstTokenOfAlternatingTypes(tokens, qSequenceEndNonInclusive - 1, ETokenType.IDENTIFIER, ETokenType.DOT)) != -1) {
            String qSequence = TokenStreamTextUtils.concatTokenTexts(tokens.subList(qSequenceStart, qSequenceEndNonInclusive));
            if (qSequenceStart - 1 >= 0 && tokens.get(qSequenceStart - 1).getType() == ETokenType.NEW) {
                return Optional.of(this.typeIsOf(qSequence, fullyQualifiedTypeNames));
            }
        }
        return Optional.empty();
    }

    public boolean typeIsOf(String type, Set<String> fullyQualifiedTypeNames) {
        if (fullyQualifiedTypeNames.contains(type)) {
            return true;
        }
        if (type.contains(".")) {
            return false;
        }
        String fullTypeName = (String)this.importInformation.getTypeImports().get((Object)type);
        if (fullTypeName != null) {
            return fullyQualifiedTypeNames.contains(fullTypeName);
        }
        return fullyQualifiedTypeNames.stream().filter(fqType -> fqType.endsWith(type)).anyMatch(this::isWildcardImported);
    }

    public boolean isImported(String fullyQualifiedName) {
        String simpleName = StringUtils.getLastPart((String)fullyQualifiedName, (char)'.');
        if (this.importInformation.getTypeImports().containsKey((Object)simpleName)) {
            return ((String)this.importInformation.getTypeImports().get((Object)simpleName)).equals(fullyQualifiedName);
        }
        return this.isWildcardImported(fullyQualifiedName);
    }

    private boolean isWildcardImported(String fullyQualifiedName) {
        return this.importInformation.getWildcardImports().contains((Object)StringUtils.removeLastPart((String)fullyQualifiedName, (char)'.'));
    }

    public UnmodifiableSet<String> getStaticImports() {
        return this.importInformation.getStaticImports();
    }

    public UnmodifiableSet<String> getSpecificImports() {
        return this.importInformation.getTypeImports().keySet();
    }

    public Stream<TypeUsageResolutionResult> getReferencedTypes(ShallowEntity entity) {
        return TYPE_REFERENCES_PATTERN.findNonOverlappingMatches((List<IToken>)entity.includedTokens()).stream().map(match -> match.groupString(0)).distinct().map(this::getPossibleFullyQualifiedTypeNames);
    }
}

