/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.typetracker.java;

import eu.cqse.check.framework.typetracker.java.ImportInformation;
import eu.cqse.check.framework.typetracker.java.JavaPlatformModules;
import eu.cqse.check.framework.typetracker.java.TypeUsageResolutionResult;
import eu.cqse.check.framework.typetracker.java.TypeUsageResolver;
import java.util.HashMap;
import java.util.Map;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

class ModuleImportResolver
implements TypeUsageResolver {
    private static final UnmodifiableMap<String, UnmodifiableMap<String, String>> MODULE_MAPPINGS = ModuleImportResolver.calculateModuleMappings();

    ModuleImportResolver() {
    }

    private static UnmodifiableMap<String, UnmodifiableMap<String, String>> calculateModuleMappings() {
        HashMap<String, UnmodifiableMap> moduleMappings = new HashMap<String, UnmodifiableMap>();
        for (Map.Entry module : JavaPlatformModules.MODULE_TO_IMPORTS.entrySet()) {
            HashMap<String, @Nullable String> mappings = new HashMap<String, String>();
            for (String someImport : (UnmodifiableSet)module.getValue()) {
                if (someImport.contains("$")) continue;
                Pair packageAndSimpleClassName = StringUtils.splitAtLast((String)someImport, (char)'.');
                if (mappings.containsKey(packageAndSimpleClassName.getSecond())) {
                    mappings.put((String)packageAndSimpleClassName.getSecond(), null);
                    continue;
                }
                mappings.put((String)packageAndSimpleClassName.getSecond(), someImport);
            }
            mappings.entrySet().removeIf(e -> e.getValue() == null);
            moduleMappings.put((String)module.getKey(), CollectionUtils.asUnmodifiable(mappings));
        }
        return CollectionUtils.asUnmodifiable(moduleMappings);
    }

    @Override
    public TypeUsageResolutionResult resolve(ImportInformation importInformation, String typeName) {
        String firstTypeNamePart = typeName;
        String restTypeNamePart = "";
        int index = typeName.indexOf(".");
        if (index != -1) {
            firstTypeNamePart = typeName.substring(0, index);
            restTypeNamePart = typeName.substring(index);
        }
        for (String importedModule : importInformation.getModuleImports()) {
            UnmodifiableMap moduleMapping = (UnmodifiableMap)MODULE_MAPPINGS.get((Object)importedModule);
            String possibleClass = (String)moduleMapping.get((Object)firstTypeNamePart);
            if (possibleClass == null) continue;
            return new TypeUsageResolutionResult.Accurate(possibleClass + restTypeNamePart);
        }
        return new TypeUsageResolutionResult.NotFound();
    }
}

