/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.typetracker.java;

import eu.cqse.check.framework.typetracker.java.ImportInformation;
import eu.cqse.check.framework.typetracker.java.JavaPlatformModules;
import eu.cqse.check.framework.typetracker.java.TypeUsageResolutionResult;
import eu.cqse.check.framework.typetracker.java.TypeUsageResolver;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.collections.UnmodifiableNavigableSet;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.collections.UnmodifiableSortedSet;
import org.conqat.lib.commons.string.StringUtils;

public class WildcardImportResolver
implements TypeUsageResolver {
    private static final UnmodifiableMap<String, UnmodifiableSet<String>> WILDCARD_IMPORT_TO_TYPES = WildcardImportResolver.calculateWildcardImportToTypes();
    private static final UnmodifiableNavigableSet<String> PACKAGES = WildcardImportResolver.calculatePackages();

    private static UnmodifiableMap<String, UnmodifiableSet<String>> calculateWildcardImportToTypes() {
        HashMap<String, Set> wildcardImportToTypes = new HashMap<String, Set>();
        for (String someImport : JavaPlatformModules.MODULE_TO_IMPORTS.values().stream().flatMap(Collection::stream).toList()) {
            Pair packageNameAndRest = StringUtils.splitAtLast((String)someImport, (char)'.');
            StringBuilder packageName = new StringBuilder((String)packageNameAndRest.getFirst());
            String typeNameWithInnerTypes = (String)packageNameAndRest.getSecond();
            wildcardImportToTypes.computeIfAbsent(packageName.toString(), string -> new HashSet()).add(typeNameWithInnerTypes);
            while (typeNameWithInnerTypes.contains("$")) {
                packageNameAndRest = StringUtils.splitAtFirst((String)typeNameWithInnerTypes, (char)'$');
                packageName.append('.');
                packageName.append((String)packageNameAndRest.getFirst());
                typeNameWithInnerTypes = (String)packageNameAndRest.getSecond();
                wildcardImportToTypes.computeIfAbsent(packageName.toString(), string -> new HashSet()).add(typeNameWithInnerTypes);
            }
        }
        return CollectionUtils.asUnmodifiable((Map)CollectionUtils.transformMapValues(wildcardImportToTypes, CollectionUtils::asUnmodifiable));
    }

    private static UnmodifiableNavigableSet<String> calculatePackages() {
        TreeSet<String> packages = new TreeSet<String>();
        for (Map.Entry module : JavaPlatformModules.MODULE_TO_IMPORTS.entrySet()) {
            for (String someImport : (UnmodifiableSet)module.getValue()) {
                Pair packageNameAndRest = StringUtils.splitAtLast((String)someImport, (char)'.');
                String packageName = (String)packageNameAndRest.getFirst();
                packages.add(packageName);
            }
        }
        return CollectionUtils.asUnmodifiable(packages);
    }

    @Override
    public TypeUsageResolutionResult resolve(ImportInformation importInformation, String typeName) {
        HashSet<String> possibleImports = new HashSet<String>();
        for (String wildcardImport : importInformation.getWildcardImports()) {
            Set wildcardImportedTypes = (Set)WILDCARD_IMPORT_TO_TYPES.get((Object)wildcardImport);
            if (wildcardImportedTypes == null) {
                possibleImports.add(wildcardImport + "." + typeName);
                continue;
            }
            for (String wildcardImportedType : wildcardImportedTypes) {
                if (!wildcardImportedType.replace('$', '.').equals(typeName)) continue;
                return new TypeUsageResolutionResult.Accurate(wildcardImport + "." + typeName);
            }
        }
        if (possibleImports.isEmpty()) {
            return new TypeUsageResolutionResult.NotFound();
        }
        return new TypeUsageResolutionResult.Inaccurate(possibleImports);
    }

    public static UnmodifiableSortedSet<String> getSubpackages(String packageName) {
        return CollectionUtils.asUnmodifiable((SortedSet)PACKAGES.subSet((Object)(packageName + "."), (Object)(packageName + "/")));
    }

    public static UnmodifiableSet<String> getTypesInPackage(String packageName) {
        return CollectionUtils.asUnmodifiable((Set)((Set)WILDCARD_IMPORT_TO_TYPES.get((Object)packageName)));
    }
}

