/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util;

import com.google.common.base.Preconditions;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.ILanguageFeatureParser;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.TypeNameTokenCollection;
import eu.cqse.check.framework.util.clike.CLikeCheckUtils;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import eu.cqse.check.framework.util.variable.CLikeVariableUseExtractor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.Nullable;

public abstract class CLikeLanguageFeatureParserBase
implements ILanguageFeatureParser {
    private static final ITokenMatcher CONDITIONAL_OPERATOR_TYPES = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EQEQ, ETokenType.LTEQ, ETokenType.GTEQ, ETokenType.LT, ETokenType.GT, ETokenType.NOTEQ});
    private static final ITokenMatcher POINTER_TYPES = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.MULT, ETokenType.AND, ETokenType.ANDAND});
    private static final ITokenMatcher VARIABLE_ASSIGNMENT_TYPES = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EQ, ETokenType.PLUSEQ, ETokenType.MINUSEQ, ETokenType.MULTEQ, ETokenType.DIVEQ, ETokenType.MODEQ, ETokenType.ANDEQ, ETokenType.OREQ, ETokenType.XOREQ, ETokenType.LSHIFTEQ, ETokenType.RSHIFTEQ});
    private static final ITokenMatcher INCREMENT_DECREMENT_UNARY_OPERATORS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PLUSPLUS, ETokenType.MINUSMINUS});
    private static final ITokenMatcher POINTER_TYPE_MODIFIERS = ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.CONST, ETokenType.VOLATILE, ETokenType.NONNULL, ETokenType.NULLABLE});
    private static final UnmodifiableSet<String> TYPE_MODIFICATIONS = CollectionUtils.asUnmodifiable(new HashSet<String>(Arrays.asList("*", "&", "[]")));
    protected static final String NAME_VOID = "void";
    private static final Logger LOGGER = LogManager.getLogger();
    private final ELanguage language;
    private final ITokenMatcher validIdentifiers;
    private final ITokenMatcher primitiveTypeTokens;
    private final ITokenMatcher additionalTypeTokens;
    private final CLikeVariableUseExtractor useExtractor;
    private final ETokenType packageSeparator;
    private final String packageSeparatorText;
    private final ETokenType variableSplitType;
    private static final Pair<List<IToken>, String> NO_MODIFIERS_AND_TYPE_RESULT = new Pair((Object)CollectionUtils.emptyList(), null);

    protected CLikeLanguageFeatureParserBase(ELanguage language, ITokenMatcher validIdentifiers, ITokenMatcher primitiveTypeTokens, ITokenMatcher additionalTypeTokens, ETokenType packageSeparator, String packageSeparatorText, CLikeVariableUseExtractor useExtractor, ETokenType variableSplitType) {
        this.language = language;
        this.validIdentifiers = validIdentifiers;
        this.primitiveTypeTokens = primitiveTypeTokens;
        this.additionalTypeTokens = additionalTypeTokens;
        this.packageSeparator = packageSeparator;
        this.packageSeparatorText = packageSeparatorText;
        this.useExtractor = useExtractor;
        this.variableSplitType = variableSplitType;
    }

    public static Optional<CLikeLanguageFeatureParserBase> getInstance(ELanguage language) {
        return LanguageFeatureParser.getInstance(language).filter(CLikeLanguageFeatureParserBase.class::isInstance).map(CLikeLanguageFeatureParserBase.class::cast);
    }

    public ITokenMatcher conditionalOperatorTypes() {
        return CONDITIONAL_OPERATOR_TYPES;
    }

    public ITokenMatcher variableAssignmentTypes() {
        return VARIABLE_ASSIGNMENT_TYPES;
    }

    public ITokenMatcher incrementDecrementUnaryOperators() {
        return INCREMENT_DECREMENT_UNARY_OPERATORS;
    }

    public final boolean isValidIdentifier(IToken token) {
        return this.validIdentifiers.matches(token);
    }

    public final ITokenMatcher validIdentifierMatcher() {
        return this.validIdentifiers;
    }

    public final ITokenMatcher typeTokenMatcher() {
        return this.primitiveTypeTokens.or(new ITokenMatcher[]{this.additionalTypeTokens});
    }

    public boolean isVariableDeclaration(List<IToken> variableTokens) {
        int equalIndex = TokenStreamUtils.firstTokenMatching(variableTokens, (ITokenMatcher)ETokenType.EQ);
        if (equalIndex == -1) {
            return TokenStreamUtils.lastTokenMatching(variableTokens, 0, variableTokens.size(), this.validIdentifiers) > 0;
        }
        if (TokenStreamUtils.startsWith(variableTokens, ETokenType.MULT)) {
            return equalIndex - 2 > 0;
        }
        return equalIndex - 1 > 0;
    }

    public boolean matchesFullQualifiedTypeName(String typeName, Collection<String> importedNamespaces, String fullQualifiedTypeName) {
        if (typeName == null) {
            return false;
        }
        if (typeName.equals(fullQualifiedTypeName)) {
            return true;
        }
        for (String namespace : importedNamespaces) {
            String potentialFullQualifiedTypeName = namespace + this.packageSeparatorText + typeName;
            if (!potentialFullQualifiedTypeName.equals(fullQualifiedTypeName)) continue;
            return true;
        }
        return false;
    }

    public List<IToken> extractConditionTokens(ShallowEntity statement) {
        String subtype = statement.getSubtype();
        if (subtype.equals("for")) {
            return TokenStreamUtils.tokensBetween((List<IToken>)statement.ownStartTokens(), ETokenType.SEMICOLON, ETokenType.SEMICOLON);
        }
        if (subtype.equals("do")) {
            UnmodifiableList tokens = statement.includedTokens();
            int whileOffset = TokenStreamUtils.lastTokenMatching((List<IToken>)tokens, (ITokenMatcher)ETokenType.WHILE);
            return TokenStreamUtils.tokensBetweenWithNesting((List<IToken>)tokens, whileOffset, ETokenType.LPAREN, ETokenType.RPAREN);
        }
        return TokenStreamUtils.tokensBetweenWithNesting((List<IToken>)statement.ownStartTokens(), ETokenType.LPAREN, ETokenType.RPAREN);
    }

    public boolean isStatic(ShallowEntity entity) {
        return TokenStreamUtils.firstTokenMatching((List<IToken>)entity.ownStartTokens(), (ITokenMatcher)ETokenType.STATIC) != -1;
    }

    public boolean isFinal(ShallowEntity entity) {
        return TokenStreamUtils.firstTokenMatching((List<IToken>)entity.ownStartTokens(), (ITokenMatcher)ETokenType.FINAL) != -1;
    }

    public boolean isAbstract(ShallowEntity entity) {
        return TokenStreamUtils.firstTokenMatching((List<IToken>)entity.ownStartTokens(), (ITokenMatcher)ETokenType.ABSTRACT) != -1;
    }

    public boolean hasExplicitVisibility(ShallowEntity entity, ETokenType visibility) {
        CCSMAssert.isTrue((boolean)Arrays.asList(ETokenType.PRIVATE, ETokenType.PUBLIC, ETokenType.PROTECTED, ETokenType.INTERNAL).contains(visibility), (String)("Invalid visibility: " + String.valueOf(visibility)));
        return TokenStreamUtils.firstTokenMatching((List<IToken>)entity.ownStartTokens(), (ITokenMatcher)visibility) != -1;
    }

    public boolean hasOnlyStaticMembers(ShallowEntity clazz) {
        CCSMAssert.isTrue((clazz.getType() == EShallowEntityType.TYPE ? 1 : 0) != 0, (String)"clazz.getType() must be \"TYPE\"");
        CCSMAssert.isTrue((boolean)clazz.getSubtype().equals("class"), (String)"clazz.getSubType() must be \"class\"");
        UnmodifiableList children = clazz.getChildren();
        int childCount = 0;
        for (ShallowEntity child : children) {
            if (child.getType() != EShallowEntityType.ATTRIBUTE && child.getType() != EShallowEntityType.METHOD && child.getType() != EShallowEntityType.TYPE) continue;
            ++childCount;
            if (this.isStatic(child)) continue;
            return false;
        }
        return childCount > 0;
    }

    public List<String> getGenericNamesForType(ShallowEntity type) {
        CCSMAssert.isTrue((type.getType() == EShallowEntityType.TYPE ? 1 : 0) != 0, (String)"Expected type entity");
        UnmodifiableList typeTokens = type.ownStartTokens();
        int nameIndex = TokenStreamUtils.firstTokenMatching((List<IToken>)typeTokens, (ITokenMatcher)ETokenType.IDENTIFIER);
        if (nameIndex == -1 || nameIndex >= typeTokens.size() - 1) {
            return CollectionUtils.emptyList();
        }
        if (((IToken)typeTokens.get(nameIndex + 1)).getType() != ETokenType.LT) {
            return CollectionUtils.emptyList();
        }
        return this.extractGenericTokens((List<IToken>)typeTokens);
    }

    public List<String> getGenericNamesForMethod(ShallowEntity method) {
        CCSMAssert.isTrue((method.getType() == EShallowEntityType.METHOD ? 1 : 0) != 0, (String)"Expected method entity");
        UnmodifiableList methodTokens = method.ownStartTokens();
        int nameIndex = TokenStreamUtils.firstTokenMatching((List<IToken>)methodTokens, (ITokenMatcher)ETokenType.LT);
        if (nameIndex == -1 || nameIndex >= methodTokens.size() - 1) {
            return CollectionUtils.emptyList();
        }
        return this.extractGenericTokens((List<IToken>)methodTokens);
    }

    private List<String> extractGenericTokens(List<IToken> tokens) {
        List<IToken> genericTokens = TokenStreamUtils.tokensBetweenWithNesting(tokens, ETokenType.LT, ETokenType.GT);
        List<List<IToken>> splitTokens = TokenStreamUtils.split(genericTokens, ETokenType.COMMA);
        List filteredTokens = CollectionUtils.map(splitTokens, this::filterGenericTokens);
        return TokenStreamTextUtils.concatAllTokenTexts(filteredTokens);
    }

    protected List<IToken> filterGenericTokens(List<IToken> genericTokens) {
        return genericTokens;
    }

    public boolean hasVoidReturnType(ShallowEntity method) {
        return NAME_VOID.equals(this.getReturnType(method));
    }

    public String getReturnType(ShallowEntity method) {
        Pair<List<IToken>, String> returnTypeAndModifiers = this.getModifiersAndReturnType(method);
        if (returnTypeAndModifiers == null) {
            return null;
        }
        return (String)returnTypeAndModifiers.getSecond();
    }

    public @Nullable Pair<List<IToken>, String> getModifiersAndReturnType(ShallowEntity method) {
        CCSMAssert.isTrue((method.getType() == EShallowEntityType.METHOD ? 1 : 0) != 0, (String)"method.getType() must be \"METHOD\"");
        UnmodifiableList methodTokens = method.ownStartTokens();
        int parameterParenthesisIndex = this.getMethodOpeningParenthesisIndex((List<IToken>)methodTokens);
        if (parameterParenthesisIndex < 0) {
            return null;
        }
        return this.getModifiersAndTypeFromTokens(methodTokens.subList(0, parameterParenthesisIndex));
    }

    protected int getMethodOpeningParenthesisIndex(List<IToken> methodTokens) {
        return TokenStreamUtils.findFirstTopLevel(methodTokens, (ITokenMatcher)ETokenType.LPAREN, Collections.singletonList(ETokenType.LT), Collections.singletonList(ETokenType.GT));
    }

    public List<IToken> getParameterTokens(ShallowEntity entity) {
        CCSMAssert.isTrue((entity.getType() == EShallowEntityType.METHOD || entity.getType() == EShallowEntityType.TYPE && entity.getSubtype().equals("record") ? 1 : 0) != 0, (String)"entity must be of type \"METHOD\" or \"TYPE\" with subtype \"RECORD\"");
        UnmodifiableList startTokens = entity.ownStartTokens();
        int indexOfName = TokenStreamTextUtils.findFirst((List<IToken>)startTokens, entity.getName());
        if (entity.getName() != null && entity.getSubtype().equals("operator")) {
            indexOfName = TokenStreamTextUtils.findFirst((List<IToken>)startTokens, StringUtils.stripPrefix((String)entity.getName(), (String)"operator"));
        }
        if (indexOfName != -1) {
            UnmodifiableList tokensAfterName = startTokens.subList(indexOfName + 1, startTokens.size());
            return this.extractParameterTokens((List<IToken>)tokensAfterName);
        }
        return new ArrayList<IToken>();
    }

    protected List<IToken> extractParameterTokens(List<IToken> tokensAfterMethodName) {
        return TokenStreamUtils.tokensBetweenWithNesting(tokensAfterMethodName, ETokenType.LPAREN, ETokenType.RPAREN);
    }

    public List<IToken> removeParameterAnnotationTokens(List<IToken> methodTokens) {
        List<TokenPatternMatch> paramAnnotationPatternMatches = this.getParamAnnotationPatternMatches(methodTokens);
        HashSet<Integer> indicesToRemove = new HashSet<Integer>();
        for (TokenPatternMatch match : paramAnnotationPatternMatches) {
            indicesToRemove.addAll(match.groupIndices(0));
        }
        return CollectionUtils.returnListWithoutGivenIndices(methodTokens, indicesToRemove);
    }

    public Pair<List<IToken>, String> getModifiersAndTypeFromTokens(List<IToken> tokens) {
        int endIndex = this.reverseSkipToDeclaredVariableOrMethodName(tokens);
        if (endIndex < 0) {
            return NO_MODIFIERS_AND_TYPE_RESULT;
        }
        ArrayList<IToken> modifierTokens = new ArrayList<IToken>();
        TypeNameTokenCollection typeNameTokenCollection = new TypeNameTokenCollection();
        if ((endIndex = this.collectTokensFromTypeAndModifications(tokens, endIndex, modifierTokens, typeNameTokenCollection)) < 0) {
            return NO_MODIFIERS_AND_TYPE_RESULT;
        }
        CLikeLanguageFeatureParserBase.collectTokensFromModifiers(tokens, endIndex, modifierTokens);
        String typeName = typeNameTokenCollection.formatTypeName();
        return new Pair(modifierTokens, (Object)typeName);
    }

    public List<IToken> getBaseTypeTokens(List<IToken> tokens) {
        int endIndex = this.reverseSkipToDeclaredVariableOrMethodName(tokens);
        if (endIndex < 0) {
            return CollectionUtils.emptyList();
        }
        TypeNameTokenCollection typeNameTokenCollection = new TypeNameTokenCollection();
        ArrayList<IToken> modifierTokens = new ArrayList<IToken>();
        if ((endIndex = this.collectTokensFromType(tokens, endIndex, typeNameTokenCollection, modifierTokens)) < 0) {
            return new ArrayList<IToken>();
        }
        return typeNameTokenCollection.getTypeNameTokens();
    }

    protected static int skipTrailingParenthesisLikeConstruct(List<IToken> tokens, int endIndex, ETokenType openingToken, ETokenType closingToken) {
        while (endIndex > 0 && TokenStreamUtils.hasTokenTypeSequence(tokens, endIndex - 1, closingToken)) {
            int lbrackIndex = TokenStreamUtils.findMatchingOpeningToken(tokens, endIndex - 2, openingToken, closingToken);
            if (lbrackIndex == -1) {
                IToken lastToken = tokens.get(endIndex - 1);
                LOGGER.debug("Could not find opening {} for {} in: {} ({}:{})", (Object)openingToken, (Object)closingToken, (Object)StringUtils.truncateWithEllipsis((String)TokenStreamTextUtils.concatTokenTexts(tokens, " "), (int)50), (Object)TokenStreamUtils.determineMostSpecificOrigin(tokens), (Object)lastToken.getLineNumber());
                return -1;
            }
            endIndex = lbrackIndex;
        }
        return endIndex;
    }

    private int collectTokensFromTypeAndModifications(List<IToken> tokens, int endIndex, List<IToken> modifierTokens, TypeNameTokenCollection typeName) {
        if ((endIndex = CLikeLanguageFeatureParserBase.collectTokensFromPointers(tokens, endIndex, modifierTokens, typeName)) != -1) {
            endIndex = this.collectTokensFromType(tokens, endIndex, typeName, modifierTokens);
        }
        return endIndex;
    }

    private static int collectTokensFromPointers(List<IToken> tokens, int endIndex, List<IToken> modifierTokens, TypeNameTokenCollection typeName) {
        int offset;
        if (tokens.size() > endIndex + 2 && tokens.get(endIndex).getType() == ETokenType.IDENTIFIER && tokens.get(endIndex + 1).getType() == ETokenType.LBRACK) {
            int closingToken = TokenStreamUtils.findMatchingClosingToken(tokens, endIndex + 2, ETokenType.LBRACK, ETokenType.RBRACK);
            if (closingToken == -1) {
                return closingToken;
            }
            typeName.addToken(tokens.get(closingToken));
            typeName.addToken(tokens.get(endIndex + 1));
        }
        for (offset = endIndex; offset > 0; --offset) {
            IToken token = tokens.get(offset - 1);
            if (POINTER_TYPE_MODIFIERS.matches(token)) {
                modifierTokens.add(token);
                continue;
            }
            if (token.getType() == ETokenType.RBRACK) {
                int openingToken = TokenStreamUtils.findMatchingOpeningToken(tokens, offset - 2, ETokenType.LBRACK, ETokenType.RBRACK);
                if (openingToken == -1) {
                    return openingToken;
                }
                typeName.addToken(token);
                typeName.addToken(tokens.get(openingToken));
                offset = openingToken + 1;
                continue;
            }
            if (POINTER_TYPES.matches(token)) {
                typeName.addToken(token);
                continue;
            }
            return offset;
        }
        return offset;
    }

    private int collectTokensFromType(List<IToken> tokens, int endIndex, TypeNameTokenCollection typeName, List<IToken> modifierTokens) {
        if (endIndex > 0 && CollectionUtils.asHashSet((Object[])new ETokenType[]{ETokenType.STATIC, ETokenType.VOLATILE}).contains(tokens.get(endIndex - 1).getType())) {
            modifierTokens.add(tokens.get(endIndex));
            --endIndex;
        }
        if (endIndex > 0 && this.primitiveTypeTokens.matches(tokens.get(endIndex - 1))) {
            return this.collectTokensFromPrimitiveType(tokens, endIndex, typeName);
        }
        int atomicEndIndex = CLikeLanguageFeatureParserBase.collectTokensFromAtomicTypeSpecifier(tokens, endIndex, typeName);
        if (atomicEndIndex != -1) {
            return atomicEndIndex;
        }
        if ((endIndex = this.collectTokenFromTypePart(tokens, endIndex, typeName, modifierTokens)) == -1) {
            return -1;
        }
        while (endIndex > 1 && tokens.get(endIndex - 1).getType() == this.packageSeparator) {
            typeName.addToken(tokens.get(endIndex - 1));
            if ((endIndex = this.collectTokenFromTypePart(tokens, endIndex - 1, typeName, modifierTokens)) != -1) continue;
            return -1;
        }
        return endIndex;
    }

    private int collectTokensFromPrimitiveType(List<IToken> tokens, int endIndex, TypeNameTokenCollection typeName) {
        typeName.markPrimitive();
        while (endIndex > 0 && this.primitiveTypeTokens.matches(tokens.get(endIndex - 1))) {
            typeName.addToken(tokens.get(endIndex - 1));
            --endIndex;
        }
        return endIndex;
    }

    private static int collectTokensFromAtomicTypeSpecifier(List<IToken> tokens, int endIndex, TypeNameTokenCollection typeName) {
        if (endIndex <= 0 || tokens.get(endIndex - 1).getType() != ETokenType.RPAREN) {
            return -1;
        }
        int openParenIndex = TokenStreamUtils.findMatchingOpeningToken(tokens, endIndex - 2, ETokenType.LPAREN, ETokenType.RPAREN);
        if (openParenIndex <= 0) {
            return -1;
        }
        IToken specifierToken = tokens.get(openParenIndex - 1);
        if (specifierToken.getType() == ETokenType.ATOMIC) {
            int specifierIndex = openParenIndex - 1;
            for (int i = endIndex - 1; i >= specifierIndex; --i) {
                typeName.addToken(tokens.get(i));
            }
            return specifierIndex;
        }
        return -1;
    }

    private int collectTokenFromTypePart(List<IToken> tokens, int endIndex, TypeNameTokenCollection typeName, List<IToken> modifierTokens) {
        if (endIndex > 0 && tokens.get(endIndex - 1).getType() == ETokenType.GT) {
            endIndex = this.skipGenericReverse(tokens, endIndex - 1);
        }
        if (endIndex == 1 && ETokenType.CONST == tokens.getFirst().getType()) {
            modifierTokens.add(tokens.getFirst());
            return 0;
        }
        if (endIndex <= 0 || !this.isTypeToken(tokens.get(endIndex - 1))) {
            return -1;
        }
        typeName.addToken(tokens.get(endIndex - 1));
        return endIndex - 1;
    }

    private static void collectTokensFromModifiers(List<IToken> tokens, int endIndex, List<IToken> modifierTokens) {
        modifierTokens.addAll(0, tokens.subList(0, endIndex));
    }

    public final boolean isTypeToken(IToken token) {
        return this.typeTokenMatcher().matches(token);
    }

    public final ITokenMatcher primitiveTypeToken() {
        return this.primitiveTypeTokens;
    }

    protected int reverseSkipToDeclaredVariableOrMethodName(List<IToken> tokens) {
        int endIndex = this.reverseSkipPastVariableAssignment(tokens);
        if ((endIndex = CLikeLanguageFeatureParserBase.skipTrailingParenthesisLikeConstruct(tokens, endIndex, ETokenType.LBRACK, ETokenType.RBRACK)) == -1) {
            return endIndex;
        }
        if ((endIndex = CLikeLanguageFeatureParserBase.skipTrailingParenthesisLikeConstruct(tokens, endIndex, ETokenType.LT, ETokenType.GT)) == -1) {
            return endIndex;
        }
        endIndex = TokenStreamUtils.lastTokenMatching(tokens.subList(0, endIndex), this.validIdentifiers);
        return endIndex;
    }

    protected int reverseSkipPastVariableAssignment(List<IToken> tokens) {
        int endIndex = TokenStreamUtils.firstTokenMatching(tokens, (ITokenMatcher)ETokenType.EQ);
        return TokenStreamUtils.endIndexIfNotFound(endIndex, tokens);
    }

    public int skipGeneric(List<IToken> tokens, int startIndex) {
        return TokenStreamUtils.findMatchingClosingToken(tokens, startIndex + 1, ETokenType.LT, ETokenType.GT);
    }

    public int skipGenericReverse(List<IToken> tokens, int startIndex) {
        return TokenStreamUtils.findMatchingOpeningToken(tokens, startIndex - 1, ETokenType.LT, ETokenType.GT);
    }

    public List<List<IToken>> getSplitParameterTokens(ShallowEntity method) {
        List<IToken> parameterTokens = this.getParameterTokens(method);
        if (parameterTokens.isEmpty()) {
            return CollectionUtils.emptyList();
        }
        return this.splitVariableTokens(parameterTokens);
    }

    public List<Optional<String>> getParameterTypeNames(ShallowEntity method) {
        List<List<IToken>> paramTokens = this.getSplitParameterTokens(method);
        ArrayList<Optional<String>> paramTypeNames = new ArrayList<Optional<String>>();
        for (List<IToken> tokens : paramTokens) {
            if (this.containsVariableLengthArgumentListIndicator(tokens)) {
                paramTypeNames.add(Optional.empty());
                continue;
            }
            if (tokens.size() == 1) {
                paramTypeNames.add(Optional.ofNullable(tokens.getFirst().getText()));
                continue;
            }
            paramTypeNames.add(Optional.ofNullable((String)this.getModifiersAndTypeFromTokens(tokens).getSecond()));
        }
        return paramTypeNames;
    }

    public List<IToken> getParameterAnnotations(List<IToken> methodTokenStream) {
        return TokenPatternMatch.getAllTokens(this.getParamAnnotationPatternMatches(methodTokenStream), 0);
    }

    private List<TokenPatternMatch> getParamAnnotationPatternMatches(List<IToken> methodTokenStream) {
        return this.getParameterAnnotationPattern().findNonOverlappingMatches(methodTokenStream);
    }

    protected TokenPattern getParameterAnnotationPattern() {
        return TokenPattern.NEVER_MATCHING_PATTERN;
    }

    protected int getTypeNameStartIndex(List<IToken> tokens, int lastTypeTokenIndex) {
        ETokenType first;
        int i;
        for (i = lastTypeTokenIndex; i > 1 && (first = tokens.get(i - 1).getType()) == ETokenType.DOT && this.validIdentifiers.matches(tokens.get(i - 2)); i -= 2) {
        }
        return i;
    }

    public List<String> getGenericTypeNames(List<IToken> tokens) {
        int endIndex;
        int openingIndex;
        ArrayList<String> typeNames = new ArrayList<String>();
        ArrayList<IToken> tokenDumpList = new ArrayList<IToken>();
        int startIndex = 0;
        while ((openingIndex = TokenStreamUtils.firstTokenMatching(tokens, startIndex, (ITokenMatcher)ETokenType.LT)) >= 0 && (endIndex = this.skipGeneric(tokens, openingIndex)) > 0) {
            List<IToken> subList = tokens.subList(openingIndex + 1, endIndex);
            TypeNameTokenCollection typeNameTokenCollection = new TypeNameTokenCollection();
            String subListStringRepresentation = TokenStreamTextUtils.concatTokenTexts(subList, "");
            if (StringUtils.isInteger((String)subListStringRepresentation)) {
                typeNames.add(subListStringRepresentation);
            } else if (this.collectTokensFromTypeAndModifications(subList, subList.size(), tokenDumpList, typeNameTokenCollection) >= 0) {
                typeNames.add(typeNameTokenCollection.formatTypeName());
            }
            startIndex = endIndex + 1;
        }
        return typeNames;
    }

    public List<List<IToken>> splitVariableTokens(List<IToken> variableTokens) {
        return TokenStreamUtils.splitWithNesting(variableTokens, this.variableSplitType, Arrays.asList(ETokenType.LPAREN, ETokenType.LBRACK, ETokenType.LBRACE, ETokenType.LT), Arrays.asList(ETokenType.RPAREN, ETokenType.RBRACK, ETokenType.RBRACE, ETokenType.GT));
    }

    public List<IToken> getVariableNamesFromTokens(List<IToken> variableTokens) {
        List<List<IToken>> splitTokens = this.splitVariableTokens(variableTokens);
        ArrayList<IToken> variableNames = new ArrayList<IToken>();
        for (List<IToken> tokens : splitTokens) {
            IToken name = this.getVariableNameFromTokens(tokens);
            if (name == null) continue;
            variableNames.add(name);
        }
        return variableNames;
    }

    public IToken getVariableNameFromTokens(List<IToken> tokens) {
        int nameIndex;
        int equalIndex = TokenStreamUtils.firstTokenMatching(tokens, (ITokenMatcher)ETokenType.EQ);
        int endIndex = tokens.size();
        if (equalIndex != -1) {
            endIndex = equalIndex;
        }
        if ((nameIndex = TokenStreamUtils.lastTokenMatching(tokens, 0, endIndex, this.validIdentifiers)) < 0) {
            return null;
        }
        return tokens.get(nameIndex);
    }

    public String getVariableTypeFromTokens(List<IToken> tokens) {
        int reverseSkipToType = this.reverseSkipToDeclaredVariableOrMethodName(tokens);
        if (reverseSkipToType == -1) {
            return null;
        }
        return TokenStreamTextUtils.concatTokenTexts(tokens.subList(0, reverseSkipToType), " ");
    }

    public IToken getVariableNameFromCatchTokens(List<IToken> catchTokens) {
        List<IToken> exceptionTokens = TokenStreamUtils.tokensBetween(catchTokens, ETokenType.LPAREN, ETokenType.RPAREN);
        int doubleIdentifierIndex = TokenStreamUtils.firstTokenOfTypeSequence(exceptionTokens, 0, ETokenType.IDENTIFIER, ETokenType.IDENTIFIER);
        if (doubleIdentifierIndex == -1) {
            return null;
        }
        return exceptionTokens.get(doubleIdentifierIndex + 1);
    }

    public String getTypeNameFromCatchTokens(List<IToken> catchTokens) {
        List<IToken> exceptionTokens = TokenStreamUtils.tokensBetween(catchTokens, ETokenType.LPAREN, ETokenType.RPAREN);
        if (exceptionTokens.isEmpty()) {
            return null;
        }
        if (exceptionTokens.size() == 1) {
            return exceptionTokens.getFirst().getText();
        }
        int typeEndIndex = TokenStreamUtils.firstTokenOfTypeSequence(exceptionTokens, 0, ETokenType.IDENTIFIER, ETokenType.IDENTIFIER);
        if (typeEndIndex == -1) {
            typeEndIndex = exceptionTokens.size() - 1;
        }
        int typeStartIndex = this.getTypeNameStartIndex(exceptionTokens, typeEndIndex);
        return TokenStreamTextUtils.concatTokenTexts(exceptionTokens.subList(typeStartIndex, typeEndIndex + 1));
    }

    public List<IToken> getVariableTokensFromForLikeTokens(List<IToken> forLikeTokens, ETokenType endToken) {
        int leftParenIndex = TokenStreamUtils.firstTokenMatching(forLikeTokens, (ITokenMatcher)ETokenType.LPAREN);
        if (leftParenIndex == -1) {
            return CollectionUtils.emptyList();
        }
        int endIndex = endToken == ETokenType.RPAREN ? TokenStreamUtils.findMatchingClosingToken(forLikeTokens, leftParenIndex + 1, ETokenType.LPAREN, ETokenType.RPAREN) : TokenStreamUtils.firstTokenMatching(forLikeTokens, (ITokenMatcher)endToken);
        if (endIndex == -1) {
            return CollectionUtils.emptyList();
        }
        return forLikeTokens.subList(leftParenIndex + 1, endIndex);
    }

    public List<Integer> getVariableUsesFromTokens(List<IToken> tokens, String variableName, boolean isField, boolean isShadowed) {
        return this.useExtractor.extractVariableUses(tokens, variableName, isField, isShadowed);
    }

    public List<Integer> getVariableReadsFromTokens(List<IToken> tokens, String variableName, boolean isField, boolean isShadowed) {
        return this.useExtractor.extractVariableReads(tokens, variableName, isField, isShadowed);
    }

    public List<Integer> getVariableWritesFromTokens(List<IToken> tokens, String variableName, boolean isField, boolean isShadowed) {
        return this.useExtractor.extractVariableWrites(tokens, variableName, isField, isShadowed);
    }

    public abstract boolean isImport(ShallowEntity var1);

    public abstract String getImportName(ShallowEntity var1);

    public boolean containsVariableLengthArgumentListIndicator(List<IToken> tokens) {
        return TokenStreamUtils.containsAll(tokens, ETokenType.ELLIPSIS);
    }

    public List<String> getImportedNames(List<ShallowEntity> importEntities) {
        ArrayList<String> importedNames = new ArrayList<String>();
        for (ShallowEntity usingEntity : importEntities) {
            String importName = this.getImportName(usingEntity);
            if (importName == null) continue;
            importedNames.add(importName);
        }
        return importedNames;
    }

    public String getPlainTypeName(String typeName) {
        return StringUtils.removeAll((String)typeName, TYPE_MODIFICATIONS);
    }

    public String getBaseTypeName(String typeName) {
        int index = typeName.lastIndexOf(this.packageSeparatorText);
        if (index == -1) {
            return typeName;
        }
        return typeName.substring(index + this.packageSeparatorText.length());
    }

    @Override
    public ELanguage getLanguage() {
        return this.language;
    }

    public boolean isAnnotation(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.META && ("annotation".equals(entity.getSubtype()) || "attribute annotation".equals(entity.getSubtype()));
    }

    public List<ShallowEntity> getAnnotations(ShallowEntity entity) {
        return this.getAnnotations(entity, false);
    }

    public List<ShallowEntity> getAnnotations(ShallowEntity entity, boolean includeParentEntities) {
        ShallowEntity previousEntity;
        ShallowEntity parent = entity.getParent();
        if (parent == null) {
            return CollectionUtils.emptyList();
        }
        ArrayList<ShallowEntity> annotations = new ArrayList<ShallowEntity>();
        UnmodifiableList entities = parent.getChildren();
        for (int i = entities.indexOf((Object)entity) - 1; i >= 0 && this.isAnnotation(previousEntity = (ShallowEntity)entities.get(i)); --i) {
            annotations.add(previousEntity);
        }
        if (includeParentEntities) {
            annotations.addAll(this.getAnnotations(entity.getParent(), true));
        }
        return annotations;
    }

    public boolean hasAnnotation(ShallowEntity method, Set<String> annotations) {
        return this.getAnnotations(method).stream().anyMatch(annotation -> this.isSpecificAnnotation((ShallowEntity)annotation, annotations));
    }

    public Optional<String> getFirstMatchingAnnotation(ShallowEntity method, Set<String> annotations) {
        return this.getAnnotations(method).stream().filter(annotation -> this.isSpecificAnnotation((ShallowEntity)annotation, annotations)).map(ShallowEntity::getName).findFirst();
    }

    public boolean hasAnnotation(ShallowEntity method, String ... annotations) {
        return this.getAnnotations(method).stream().anyMatch(annotation -> this.isSpecificAnnotation((ShallowEntity)annotation, CollectionUtils.asHashSet((Object[])annotations)));
    }

    public boolean isSpecificAnnotation(ShallowEntity annotation, Set<String> annotations) {
        Preconditions.checkArgument((boolean)this.isAnnotation(annotation), (Object)"Shallow entity must be an annotation.");
        String attributeName = annotation.getName();
        return annotations.contains(attributeName);
    }

    public List<IToken> getMethodReturnType(ShallowEntity method) {
        return CLikeCheckUtils.getMethodReturnType(method);
    }

    public List<IToken> getMethodModifiersAndReturnType(ShallowEntity method) {
        return CLikeCheckUtils.getMethodModifiersAndReturnType(method);
    }

    public List<List<IToken>> getMethodArguments(ShallowEntity methodOrStatement) {
        return CLikeCheckUtils.getMethodArguments(methodOrStatement, 0);
    }

    public List<List<IToken>> getMethodArguments(ShallowEntity methodOrStatement, int startOffset) {
        return CLikeCheckUtils.getMethodArguments(methodOrStatement, startOffset);
    }
}

