/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ICheckContext;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ITypeResolution;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.IMethodCallMatcher;
import eu.cqse.check.framework.util.JavaMethodCallFinder;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.jspecify.annotations.Nullable;

public class JavaMethodCallMatcher
implements IMethodCallMatcher {
    private final Set<String> fullTypeNames = new HashSet<String>();
    private final Set<String> targetMethodNames = new HashSet<String>();
    private final Set<String> knownMethodReturningSameType = new HashSet<String>();
    private boolean findConstructors;
    private boolean getInstanceCallsIncluded;
    private @Nullable Object tag = null;
    private boolean chainingAllowed;
    private final List<Predicate<List<List<IToken>>>> parameterPredicates = new ArrayList<Predicate<List<List<IToken>>>>();

    private JavaMethodCallMatcher() {
    }

    public static JavaMethodCallMatcher create() {
        return new JavaMethodCallMatcher();
    }

    public JavaMethodCallMatcher onTypes(Set<String> fullTypeNames) {
        this.fullTypeNames.addAll(fullTypeNames);
        return this;
    }

    public JavaMethodCallMatcher onTypes(String ... fullTypeNames) {
        this.fullTypeNames.addAll(Arrays.asList(fullTypeNames));
        return this;
    }

    public JavaMethodCallMatcher withTargetMethodNames(Set<String> targetMethodNames) {
        this.targetMethodNames.addAll(targetMethodNames);
        return this;
    }

    public JavaMethodCallMatcher withTargetMethodNames(String ... targetMethodNames) {
        return this.withTargetMethodNames(CollectionUtils.asHashSet((Object[])targetMethodNames));
    }

    public JavaMethodCallMatcher constructors() {
        return this.constructors(false);
    }

    public JavaMethodCallMatcher constructorsAndGetInstanceCalls() {
        return this.constructors(true);
    }

    private JavaMethodCallMatcher constructors(boolean alsoLookForGetInstanceCalls) {
        this.findConstructors = true;
        this.getInstanceCallsIncluded = alsoLookForGetInstanceCalls;
        return this;
    }

    public JavaMethodCallMatcher withKnownMethodReturningSameType(String ... knownMethodReturningSameType) {
        return this.withKnownMethodReturningSameType(CollectionUtils.asHashSet((Object[])knownMethodReturningSameType));
    }

    public JavaMethodCallMatcher withKnownMethodReturningSameType(Set<String> knownMethodReturningSameType) {
        this.knownMethodReturningSameType.addAll(knownMethodReturningSameType);
        return this;
    }

    public JavaMethodCallMatcher withParameterCount(int parameterCount) {
        return this.withParameterCount(parameterCount, parameterCount);
    }

    public JavaMethodCallMatcher withParameterMinCount(int minParameterCount) {
        return this.withParameters(parameters -> parameters.size() >= minParameterCount);
    }

    public JavaMethodCallMatcher withParameterMaxCount(int maxParameterCount) {
        return this.withParameters(parameters -> parameters.size() <= maxParameterCount);
    }

    public JavaMethodCallMatcher withParameterCount(int minParameters, int maxParameters) {
        return this.withParameters(parameters -> parameters.size() >= minParameters && parameters.size() <= maxParameters);
    }

    public JavaMethodCallMatcher withTag(@Nullable Object tag) {
        this.tag = tag;
        return this;
    }

    public JavaMethodCallMatcher withChainingAllowed(boolean allowed) {
        this.chainingAllowed = allowed;
        return this;
    }

    public boolean isChainingAllowed() {
        return this.chainingAllowed;
    }

    @Override
    public List<MethodCall> find(ICheckContext checkContext, JavaImportSensitiveTypeResolver typeResolver) throws CheckException {
        return this.find(checkContext.getRootEntity(ECodeViewOption.FILTERED), checkContext.getTypeResolution(ECodeViewOption.FILTERED), typeResolver);
    }

    @Override
    public List<MethodCall> find(ShallowEntity root, ITypeResolution typeResolution, JavaImportSensitiveTypeResolver typeResolver) {
        ArrayList<MethodCall> result = new ArrayList<MethodCall>();
        List statementsOrAttributes = root.getType() == EShallowEntityType.STATEMENT ? List.of(root) : ShallowEntityTraversalUtils.listEntitiesOfTypes((Collection)root.getChildren(), Set.of(EShallowEntityType.STATEMENT, EShallowEntityType.ATTRIBUTE));
        if (!this.targetMethodNames.isEmpty()) {
            result.addAll(JavaMethodCallFinder.findCallsOnType(statementsOrAttributes, typeResolver, typeResolution, this));
        }
        if (this.findConstructors) {
            result.addAll(JavaMethodCallFinder.findConstructorCalls(statementsOrAttributes, typeResolver, this));
        }
        return result;
    }

    public JavaMethodCallMatcher withParameters(Predicate<List<List<IToken>>> parameterPredicate) {
        this.parameterPredicates.add(parameterPredicate);
        return this;
    }

    public Set<String> getKnownMethodReturningSameType() {
        return CollectionUtils.asUnmodifiable(this.knownMethodReturningSameType);
    }

    public boolean isTargetMethod(String methodName) {
        return this.targetMethodNames.stream().anyMatch(targetMethod -> methodName.equals(targetMethod) || methodName.matches((String)targetMethod));
    }

    public List<Predicate<List<List<IToken>>>> getParameterPredicates() {
        return CollectionUtils.asUnmodifiable(this.parameterPredicates);
    }

    public @Nullable Object getTag() {
        return this.tag;
    }

    public Set<String> getFullTypeNames() {
        return CollectionUtils.asUnmodifiable(this.fullTypeNames);
    }

    public boolean isGetInstanceCallsIncluded() {
        return this.getInstanceCallsIncluded;
    }

    public record ChainedCall(String methodName, IToken callToken, List<IToken> parameters) {
    }

    public record MethodCall(ShallowEntity entity, IToken token, List<List<IToken>> parameters, @Nullable Object tag) {
        private static final int CHAIN_TOKENS_GROUP_INDEX = 0;
        private static final TokenPattern CHAINED_CALL_PATTERN = TokenPattern.of().beginningOfStream().sequence(ETokenType.RPAREN).repeated(TokenPattern.of().sequence(ETokenType.DOT, ETokenType.IDENTIFIER).skipNested(ETokenType.LPAREN, ETokenType.RPAREN, false)).group(0).alternative(TokenPattern.of().endOfStream(), TokenPattern.of().sequence(ETokenType.SEMICOLON));

        public String methodName() {
            return this.token.getText();
        }

        public List<ChainedCall> findChainedCalls() {
            IToken startTokenExclusive;
            UnmodifiableList includedTokens = this.entity.includedTokens();
            if (this.parameters.isEmpty()) {
                int startTokenExclusiveIndex = includedTokens.indexOf(this.token) + 1;
                startTokenExclusive = (IToken)includedTokens.get(startTokenExclusiveIndex);
            } else {
                startTokenExclusive = this.parameters.getLast().getLast();
            }
            List<IToken> tokensAfterCall = includedTokens.stream().filter(token -> token.getOffset() > startTokenExclusive.getOffset()).toList();
            ArrayList<ChainedCall> chainedCalls = new ArrayList<ChainedCall>();
            for (TokenPatternMatch match : CHAINED_CALL_PATTERN.findNonOverlappingMatches(tokensAfterCall)) {
                List<IToken> allChainTokens = match.groupTokens(0);
                List<List<IToken>> methods = TokenStreamUtils.splitWithNesting(allChainTokens, ETokenType.DOT, ETokenType.LPAREN, ETokenType.RPAREN);
                for (List<IToken> method : methods) {
                    if (method.isEmpty()) continue;
                    IToken callToken = method.getFirst();
                    List<IToken> parameterTokens = LanguageFeatureParser.JAVA.extractParameterTokens(method);
                    chainedCalls.add(new ChainedCall(callToken.getText(), callToken, parameterTokens));
                }
            }
            return chainedCalls;
        }
    }
}

