/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util.clike;

import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SequencedCollection;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class CLikeCheckUtils {
    public static List<IToken> getMethodReturnType(ShallowEntity method) {
        List<IToken> methodModifiersAndReturnType = CLikeCheckUtils.getMethodModifiersAndReturnType(method);
        if (methodModifiersAndReturnType.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<IToken> returnTypeTokens = new ArrayList<IToken>();
        int bracketsLevel = 0;
        int angleBracketsLevel = 0;
        SequencedCollection reversed = methodModifiersAndReturnType.reversed();
        for (int i = 0; i < reversed.size(); ++i) {
            IToken tokenFromRight = (IToken)reversed.get(i);
            ETokenType type = tokenFromRight.getType();
            if (type == ETokenType.LBRACK) {
                --bracketsLevel;
            } else if (type == ETokenType.RBRACK) {
                ++bracketsLevel;
            } else if (type == ETokenType.LT) {
                --angleBracketsLevel;
            } else if (type == ETokenType.GT) {
                ++angleBracketsLevel;
            } else if (tokenFromRight.getType() != ETokenType.DOT) {
                if (i > 0 && !tokenFromRight.getType().isIdentifier() && !tokenFromRight.getType().isLiteral() && bracketsLevel == 0 && angleBracketsLevel == 0) break;
                if (angleBracketsLevel == 0 && i + 1 < reversed.size() && ((IToken)reversed.get(i + 1)).getType() != ETokenType.DOT) {
                    returnTypeTokens.add(tokenFromRight);
                    break;
                }
            }
            returnTypeTokens.add(tokenFromRight);
        }
        return returnTypeTokens.reversed().stream().toList();
    }

    public static List<IToken> getMethodModifiersAndReturnType(ShallowEntity method) {
        UnmodifiableList methodDefinition = method.includedTokens();
        IToken lParen = methodDefinition.stream().filter(token -> ETokenType.LPAREN == token.getType()).findFirst().orElse(null);
        int parenthesisIndex = methodDefinition.indexOf(lParen);
        int methodNameIndex = parenthesisIndex - 1;
        return methodDefinition.subList(0, methodNameIndex);
    }

    public static List<List<IToken>> getMethodDeclarationArguments(ShallowEntity method) {
        return CLikeCheckUtils.getMethodArguments(method, 0);
    }

    public static List<List<IToken>> getMethodArguments(ShallowEntity methodOrStatement, int startOffset) {
        return CLikeCheckUtils.getMethodArguments((List<IToken>)methodOrStatement.includedTokens(), startOffset);
    }

    public static List<List<IToken>> getMethodArguments(List<IToken> tokenList, int startOffset) {
        List<IToken> tokens = tokenList.stream().filter(token -> token.getOffset() >= startOffset).toList();
        List<IToken> parameterTokens = TokenStreamUtils.tokensBetweenWithNesting(tokens, ETokenType.LPAREN, ETokenType.RPAREN);
        if (parameterTokens.isEmpty()) {
            return Collections.emptyList();
        }
        return TokenStreamUtils.splitWithNesting(parameterTokens, ETokenType.COMMA, List.of(ETokenType.LPAREN, ETokenType.LBRACE), List.of(ETokenType.RPAREN, ETokenType.RBRACE));
    }

    public static boolean isReturnStatementOrVariableDeclaration(ShallowEntity statement) {
        return ((IToken)statement.includedTokens().getFirst()).getType() == ETokenType.RETURN || statement.getSubtype().equals("local variable");
    }

    private CLikeCheckUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

