/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util.cpp.alignment;

import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.cpp.BinarySizeCheckUtils;
import eu.cqse.check.framework.util.cpp.alignment.ContainerTypeDataAlignmentInfo;
import eu.cqse.check.framework.util.cpp.alignment.DataAlignmentInfo;
import eu.cqse.check.framework.util.cpp.alignment.TypeEntityAlignmentInfoExtractor;
import java.util.List;

public class UnionAlignmentInfoExtractor
extends TypeEntityAlignmentInfoExtractor {
    private static UnionAlignmentInfoExtractor singletonInstance;

    private UnionAlignmentInfoExtractor() {
    }

    @Override
    public final boolean isApplicable(ShallowEntity entity) {
        return entity.getType() == EShallowEntityType.TYPE && "union".equals(entity.getSubtype());
    }

    @Override
    protected final ContainerTypeDataAlignmentInfo extractFromType(ShallowEntity union, List<DataAlignmentInfo> members, int alignment, boolean hasPackedAttribute, boolean hasAlignmentImposedByAttribute) {
        int largestMember = UnionAlignmentInfoExtractor.getLargestMember(members);
        int size = hasPackedAttribute && !hasAlignmentImposedByAttribute ? largestMember : largestMember + BinarySizeCheckUtils.calculatePadding(largestMember, alignment);
        int smallestMember = UnionAlignmentInfoExtractor.getSmallestMember(members);
        int padding = size - smallestMember;
        return UnionAlignmentInfoExtractor.createInfo(union, size, alignment, members, padding, hasPackedAttribute, hasAlignmentImposedByAttribute);
    }

    private static int getLargestMember(List<DataAlignmentInfo> members) {
        return members.stream().mapToInt(DataAlignmentInfo::getSize).max().orElse(1);
    }

    private static int getSmallestMember(List<DataAlignmentInfo> members) {
        return members.stream().mapToInt(DataAlignmentInfo::getSize).min().orElse(1);
    }

    public static UnionAlignmentInfoExtractor getInstance() {
        if (singletonInstance == null) {
            singletonInstance = new UnionAlignmentInfoExtractor();
        }
        return singletonInstance;
    }
}

