/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.framework.util.tokens;

import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.Token;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.test.IndexValueClass;

public class TokenStreamSplitter {
    private List<List<IToken>> tokenStreams = new ArrayList<List<IToken>>();

    public TokenStreamSplitter(List<IToken> tokens) {
        this.tokenStreams.add(tokens);
    }

    public List<List<IToken>> getTokenStreams() {
        return this.tokenStreams;
    }

    public void splitNested(ETokenType openToken, ETokenType closeToken) {
        ArrayList<List<IToken>> splitStreams = new ArrayList<List<IToken>>();
        for (List<IToken> tokens : this.tokenStreams) {
            splitStreams.addAll(TokenStreamSplitter.split(tokens, openToken, closeToken));
        }
        this.tokenStreams = splitStreams;
    }

    private static List<List<IToken>> split(List<IToken> tokens, ETokenType openToken, ETokenType closeToken) {
        ArrayList<List<IToken>> result = new ArrayList<List<IToken>>();
        Stack splits = new Stack();
        splits.push(new ArrayList());
        result.add((List)splits.peek());
        for (IToken token : tokens) {
            ETokenType tokenType = token.getType();
            if (tokenType == openToken) {
                SentinelToken sentinel = new SentinelToken(token.getOffset(), token.getLineNumber(), token.getLanguage());
                ((List)splits.peek()).add(sentinel);
                splits.push(new ArrayList());
                result.add((List)splits.peek());
                continue;
            }
            if (tokenType == closeToken) {
                splits.pop();
                if (!splits.isEmpty()) continue;
                return Collections.singletonList(tokens);
            }
            ((List)splits.peek()).add(token);
        }
        return result;
    }

    @IndexValueClass(containedInBackup=true)
    private static class SentinelToken
    extends Token {
        private static final long serialVersionUID = 1L;
        private ELanguage language;

        public SentinelToken(int offset, int lineNumber, ELanguage language) {
            super(ETokenType.SENTINEL, offset, lineNumber, "sentinel", "sentinel");
            this.language = language;
        }

        public ELanguage getLanguage() {
            return this.language;
        }

        public IToken newToken(ETokenType type, int offset, int lineNumber, String text, String originId) {
            CCSMAssert.fail((String)"Operation not supported for sentinel token");
            return null;
        }
    }
}

