/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl;

import com.teamscale.commons.annotation.ClassIndexUtils;
import com.teamscale.service.framework.IServiceProfiler;
import com.teamscale.service.framework.IStaticServiceContext;
import com.teamscale.service.framework.ITeamscaleServiceInfo;
import com.teamscale.service.framework.impl.factory.CriticalEventLoggerFactory;
import com.teamscale.service.framework.impl.factory.RequestInfoFactory;
import com.teamscale.service.framework.impl.factory.ServiceInfoFactory;
import com.teamscale.service.framework.impl.factory.ServiceLoggerFactory;
import com.teamscale.service.framework.impl.factory.ServiceProfilingFactory;
import com.teamscale.service.framework.impl.factory.StaticContextFactory;
import com.teamscale.service.framework.impl.logging.IRecordingLoggerWrapper;
import com.teamscale.service.framework.logging.ICriticalEventLogger;
import com.teamscale.service.framework.logging.IRequestInfo;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.enums.SecuritySchemeType;
import io.swagger.v3.oas.annotations.info.Contact;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.security.SecurityScheme;
import jakarta.inject.Singleton;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.ext.Provider;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.message.filtering.EntityFilteringFeature;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.filter.EncodingFilter;

@ApplicationPath(value="/")
@OpenAPIDefinition(info=@Info(title="Teamscale REST API", contact=@Contact(email="support@teamscale.com")), externalDocs=@ExternalDocumentation(url="https://docs.teamscale.com/reference/rest-api/"), security={@SecurityRequirement(name="basicAuth")})
@SecurityScheme(name="basicAuth", type=SecuritySchemeType.HTTP, scheme="basic", description="Basic authentication with username and access token")
public class ApiApplication
extends ResourceConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String LEGACY_ENABLE_ADDITIONAL_TRACING_JVM_FLAG_NAME = "org.conqat.engine.service.enableAdditionalJaxTracing";
    private static final String ENABLE_ADDITIONAL_TRACING_JVM_FLAG_NAME = "com.teamscale.service.enableAdditionalJaxTracing";

    public ApiApplication() {
        for (Class providerClass : ClassIndexUtils.getAnnotated(Provider.class)) {
            this.register(providerClass);
        }
        for (Class serviceClass : ClassIndexUtils.getAnnotated(Path.class)) {
            this.register(serviceClass);
        }
        this.register(EntityFilteringFeature.class);
        this.register(EncodingFilter.class);
        this.register(MultiPartFeature.class);
        this.registerContextFactories();
        this.property("jersey.config.server.wadl.disableWadl", "true");
        this.property("jersey.config.server.headers.location.relative.resolution.disabled", "true");
        if (Boolean.getBoolean(ENABLE_ADDITIONAL_TRACING_JVM_FLAG_NAME) || Boolean.getBoolean(LEGACY_ENABLE_ADDITIONAL_TRACING_JVM_FLAG_NAME)) {
            if (Boolean.getBoolean(LEGACY_ENABLE_ADDITIONAL_TRACING_JVM_FLAG_NAME)) {
                LOGGER.warn("\"%s\" is deprecated, please use \"%s\" instead".formatted(LEGACY_ENABLE_ADDITIONAL_TRACING_JVM_FLAG_NAME, ENABLE_ADDITIONAL_TRACING_JVM_FLAG_NAME));
            }
            this.property("jersey.config.server.tracing.type", "ALL");
            this.property("jersey.config.server.tracing.threshold", "TRACE");
        }
    }

    private void registerContextFactories() {
        this.register(new AbstractBinder(this){
            {
                Objects.requireNonNull(this$0);
            }

            protected void configure() {
                this.bindFactory(RequestInfoFactory.class).to(IRequestInfo.class).proxy(true).proxyForSameScope(true).in(RequestScoped.class);
                this.bindFactory(ServiceInfoFactory.class).to(ITeamscaleServiceInfo.class).proxy(true).proxyForSameScope(true).in(RequestScoped.class);
                this.bindFactory(ServiceLoggerFactory.class).to(IRecordingLoggerWrapper.class).proxy(true).proxyForSameScope(true).in(RequestScoped.class);
                this.bindFactory(ServiceProfilingFactory.class).to(IServiceProfiler.class).proxy(true).proxyForSameScope(true).in(RequestScoped.class);
                this.bindFactory(CriticalEventLoggerFactory.class).to(ICriticalEventLogger.class).proxy(true).proxyForSameScope(true).in(RequestScoped.class);
                this.bindFactory(StaticContextFactory.class).to(IStaticServiceContext.class).proxy(false).proxyForSameScope(false).in(Singleton.class);
            }
        });
    }
}

